/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.quartz.jobs.ee.jms;

import com.alibaba.dts.shade.org.quartz.Job;
import com.alibaba.dts.shade.org.quartz.JobDataMap;
import com.alibaba.dts.shade.org.quartz.JobDetail;
import com.alibaba.dts.shade.org.quartz.JobExecutionContext;
import com.alibaba.dts.shade.org.quartz.JobExecutionException;
import com.alibaba.dts.shade.org.quartz.jobs.ee.jms.JmsHelper;
import com.alibaba.dts.shade.org.quartz.jobs.ee.jms.JmsJobException;
import com.alibaba.dts.shade.org.quartz.jobs.ee.jms.JmsMessageFactory;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SendDestinationMessageJob
implements Job {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ConnectionFactory factory = null;
        Connection connection = null;
        Session session = null;
        MessageProducer producer = null;
        Destination destination = null;
        InitialContext initCtx = null;
        JobDetail detail = context.getJobDetail();
        JobDataMap jobDataMap = detail.getJobDataMap();
        try {
            initCtx = JmsHelper.getInitialContext(jobDataMap);
            factory = (ConnectionFactory)initCtx.lookup("jms.connection.factory");
            if (JmsHelper.isDestinationSecure(jobDataMap)) {
                String user = jobDataMap.getString("jms.user");
                String pw = jobDataMap.getString("jms.password");
                connection = factory.createConnection(user, pw);
            } else {
                connection = factory.createConnection();
            }
            session = connection.createSession(false, 1);
            destination = (Destination)initCtx.lookup("jms.destination");
            producer = session.createProducer(destination);
            String factoryClass = jobDataMap.getString("jms.message.factory.class.name");
            JmsMessageFactory messageFactory = JmsHelper.getMessageFactory(factoryClass);
            Message m = messageFactory.createMessage(jobDataMap, session);
            producer.send(m);
        }
        catch (NamingException e) {
            try {
                throw new JobExecutionException(e);
                catch (JMSException e2) {
                    throw new JobExecutionException(e2);
                }
                catch (JmsJobException e3) {
                    throw new JobExecutionException(e3);
                }
            }
            catch (Throwable throwable) {
                JmsHelper.closeResource(producer);
                JmsHelper.closeResource(session);
                JmsHelper.closeResource(connection);
                throw throwable;
            }
        }
        JmsHelper.closeResource(producer);
        JmsHelper.closeResource(session);
        JmsHelper.closeResource(connection);
    }
}

