/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.quartz.listeners;

import com.alibaba.dts.shade.org.quartz.JobExecutionContext;
import com.alibaba.dts.shade.org.quartz.JobExecutionException;
import com.alibaba.dts.shade.org.quartz.SchedulerException;
import com.alibaba.dts.shade.org.quartz.listeners.JobListenerSupport;
import com.alibaba.dts.shade.org.quartz.utils.Key;
import java.util.HashMap;
import java.util.Map;

public class JobChainingJobListener
extends JobListenerSupport {
    private String name;
    private Map chainLinks;

    public JobChainingJobListener(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Listener name cannot be null!");
        }
        this.name = name;
        this.chainLinks = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public void addJobChainLink(Key firstJob, Key secondJob) {
        if (firstJob == null || secondJob == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        if (firstJob.getName() == null || secondJob.getName() == null) {
            throw new IllegalArgumentException("Key cannot have a null name!");
        }
        this.chainLinks.put(firstJob, secondJob);
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        Key sj = (Key)this.chainLinks.get(context.getJobDetail().getKey());
        if (sj == null) {
            return;
        }
        this.getLog().info((Object)("Job '" + context.getJobDetail().getFullName() + "' will now chain to Job '" + sj + "'"));
        try {
            if (context.getJobDetail().isVolatile() || context.getTrigger().isVolatile()) {
                context.getScheduler().triggerJobWithVolatileTrigger(sj.getName(), sj.getGroup());
            } else {
                context.getScheduler().triggerJob(sj.getName(), sj.getGroup());
            }
        }
        catch (SchedulerException se) {
            this.getLog().error((Object)("Error encountered during chaining to Job '" + sj + "'"), (Throwable)se);
        }
    }
}

