/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.quartz.plugins;

import com.alibaba.dts.shade.org.quartz.Scheduler;
import com.alibaba.dts.shade.org.quartz.SchedulerException;
import com.alibaba.dts.shade.org.quartz.ee.jta.UserTransactionHelper;
import com.alibaba.dts.shade.org.quartz.spi.SchedulerPlugin;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SchedulerPluginWithUserTransactionSupport
implements SchedulerPlugin {
    private String name;
    private Scheduler scheduler;
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean wrapInUserTransaction = false;

    protected void start(UserTransaction userTransaction) {
    }

    protected void shutdown(UserTransaction userTransaction) {
    }

    protected Log getLog() {
        return this.log;
    }

    protected String getName() {
        return this.name;
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.name = name;
        this.scheduler = scheduler;
    }

    public boolean getWrapInUserTransaction() {
        return this.wrapInUserTransaction;
    }

    public void setWrapInUserTransaction(boolean wrapInUserTransaction) {
        this.wrapInUserTransaction = wrapInUserTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        UserTransaction userTransaction = this.startUserTransaction();
        try {
            this.start(userTransaction);
        }
        finally {
            this.resolveUserTransaction(userTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        UserTransaction userTransaction = this.startUserTransaction();
        try {
            this.shutdown(userTransaction);
        }
        finally {
            this.resolveUserTransaction(userTransaction);
        }
    }

    private UserTransaction startUserTransaction() {
        if (!this.wrapInUserTransaction) {
            return null;
        }
        UserTransaction userTransaction = null;
        try {
            userTransaction = UserTransactionHelper.lookupUserTransaction();
            userTransaction.begin();
        }
        catch (Throwable t) {
            UserTransactionHelper.returnUserTransaction(userTransaction);
            userTransaction = null;
            this.getLog().error((Object)("Failed to start UserTransaction for plugin: " + this.getName()), t);
        }
        return userTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveUserTransaction(UserTransaction userTransaction) {
        if (userTransaction != null) {
            try {
                if (userTransaction.getStatus() == 1) {
                    userTransaction.rollback();
                } else {
                    userTransaction.commit();
                }
            }
            catch (Throwable t) {
                this.getLog().error((Object)("Failed to resolve UserTransaction for plugin: " + this.getName()), t);
            }
            finally {
                UserTransactionHelper.returnUserTransaction(userTransaction);
            }
        }
    }
}

