/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.quartz.plugins.xml;

import com.alibaba.dts.shade.org.quartz.JobDetail;
import com.alibaba.dts.shade.org.quartz.Scheduler;
import com.alibaba.dts.shade.org.quartz.SchedulerException;
import com.alibaba.dts.shade.org.quartz.SimpleTrigger;
import com.alibaba.dts.shade.org.quartz.jobs.FileScanJob;
import com.alibaba.dts.shade.org.quartz.jobs.FileScanListener;
import com.alibaba.dts.shade.org.quartz.plugins.SchedulerPluginWithUserTransactionSupport;
import com.alibaba.dts.shade.org.quartz.simpl.CascadingClassLoadHelper;
import com.alibaba.dts.shade.org.quartz.spi.ClassLoadHelper;
import com.alibaba.dts.shade.org.quartz.xml.JobSchedulingDataProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.transaction.UserTransaction;

public class JobInitializationPlugin
extends SchedulerPluginWithUserTransactionSupport
implements FileScanListener {
    private static final int MAX_JOB_TRIGGER_NAME_LEN = 80;
    private static final String JOB_INITIALIZATION_PLUGIN_NAME = "JobInitializationPlugin";
    private static final String FILE_NAME_DELIMITERS = ",";
    private boolean overWriteExistingJobs = false;
    private boolean failOnFileNotFound = true;
    private String fileNames = "quartz_jobs.xml";
    private Map jobFiles = new HashMap();
    private boolean validating = false;
    private boolean validatingSchema = true;
    private long scanInterval = 0L;
    boolean started = false;
    protected ClassLoadHelper classLoadHelper = null;
    private Set jobTriggerNameSet = new HashSet();
    static /* synthetic */ Class class$org$quartz$jobs$FileScanJob;

    public String getFileName() {
        return this.fileNames;
    }

    public void setFileName(String fileName) {
        this.getLog().warn((Object)"The \"filename\" plugin property is deprecated.  Please use \"filenames\" in the future.");
        this.fileNames = fileName;
    }

    public String getFileNames() {
        return this.fileNames;
    }

    public void setFileNames(String fileNames) {
        this.fileNames = fileNames;
    }

    public boolean isOverWriteExistingJobs() {
        return this.overWriteExistingJobs;
    }

    public void setOverWriteExistingJobs(boolean overWriteExistingJobs) {
        this.overWriteExistingJobs = overWriteExistingJobs;
    }

    public long getScanInterval() {
        return this.scanInterval / 1000L;
    }

    public void setScanInterval(long scanInterval) {
        this.scanInterval = scanInterval * 1000L;
    }

    public boolean isFailOnFileNotFound() {
        return this.failOnFileNotFound;
    }

    public void setFailOnFileNotFound(boolean failOnFileNotFound) {
        this.failOnFileNotFound = failOnFileNotFound;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isValidatingSchema() {
        return this.validatingSchema;
    }

    public void setValidatingSchema(boolean validatingSchema) {
        this.validatingSchema = validatingSchema;
    }

    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        super.initialize(name, scheduler);
        this.classLoadHelper = new CascadingClassLoadHelper();
        this.classLoadHelper.initialize();
        this.getLog().info((Object)"Registering Quartz Job Initialization Plug-in.");
        StringTokenizer stok = new StringTokenizer(this.fileNames, FILE_NAME_DELIMITERS);
        while (stok.hasMoreTokens()) {
            String fileName = stok.nextToken();
            JobFile jobFile = new JobFile(fileName);
            this.jobFiles.put(fileName, jobFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(UserTransaction userTransaction) {
        try {
            if (!this.jobFiles.isEmpty()) {
                if (this.scanInterval > 0L) {
                    this.getScheduler().getContext().put((Object)("JobInitializationPlugin_" + this.getName()), this);
                }
                Iterator iterator = this.jobFiles.values().iterator();
                while (iterator.hasNext()) {
                    JobFile jobFile = (JobFile)iterator.next();
                    if (this.scanInterval > 0L) {
                        String jobTriggerName = this.buildJobTriggerName(jobFile.getFileBasename());
                        SimpleTrigger trig = new SimpleTrigger(jobTriggerName, JOB_INITIALIZATION_PLUGIN_NAME, new Date(), null, SimpleTrigger.REPEAT_INDEFINITELY, this.scanInterval);
                        trig.setVolatility(true);
                        JobDetail job = new JobDetail(jobTriggerName, JOB_INITIALIZATION_PLUGIN_NAME, class$org$quartz$jobs$FileScanJob == null ? JobInitializationPlugin.class$("com.alibaba.dts.shade.org.quartz.jobs.FileScanJob") : class$org$quartz$jobs$FileScanJob);
                        job.setVolatility(true);
                        job.getJobDataMap().put(FileScanJob.FILE_NAME, jobFile.getFileName());
                        job.getJobDataMap().put(FileScanJob.FILE_SCAN_LISTENER_NAME, "JobInitializationPlugin_" + this.getName());
                        this.getScheduler().scheduleJob(job, trig);
                    }
                    this.processFile(jobFile);
                }
            }
        }
        catch (SchedulerException se) {
            this.getLog().error((Object)"Error starting background-task for watching jobs file.", (Throwable)se);
        }
        finally {
            this.started = true;
        }
    }

    private String buildJobTriggerName(String fileBasename) {
        String jobTriggerName = "JobInitializationPlugin_" + this.getName() + '_' + fileBasename.replace('.', '_');
        if (jobTriggerName.length() > 80) {
            jobTriggerName = jobTriggerName.substring(0, 80);
        }
        int currentIndex = 1;
        while (!this.jobTriggerNameSet.add(jobTriggerName)) {
            if (currentIndex > 1) {
                jobTriggerName = jobTriggerName.substring(0, jobTriggerName.lastIndexOf(95));
            }
            String numericSuffix = "_" + currentIndex++;
            if (jobTriggerName.length() > 80 - numericSuffix.length()) {
                jobTriggerName = jobTriggerName.substring(0, 80 - numericSuffix.length());
            }
            jobTriggerName = jobTriggerName + numericSuffix;
        }
        return jobTriggerName;
    }

    public void shutdown() {
    }

    private void processFile(JobFile jobFile) {
        if (jobFile == null || !jobFile.getFileFound()) {
            return;
        }
        JobSchedulingDataProcessor processor = new JobSchedulingDataProcessor(this.classLoadHelper, this.isValidating(), this.isValidatingSchema());
        try {
            processor.processFileAndScheduleJobs(jobFile.getFileName(), jobFile.getFileName(), this.getScheduler(), this.isOverWriteExistingJobs());
        }
        catch (Exception e) {
            this.getLog().error((Object)("Error scheduling jobs: " + e.getMessage()), (Throwable)e);
        }
    }

    public void processFile(String filePath) {
        this.processFile((JobFile)this.jobFiles.get(filePath));
    }

    public void fileUpdated(String fileName) {
        if (this.started) {
            this.processFile(fileName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JobFile {
        private String fileName;
        private String filePath;
        private String fileBasename;
        private boolean fileFound;

        protected JobFile(String fileName) throws SchedulerException {
            this.fileName = fileName;
            this.initialize();
        }

        protected String getFileName() {
            return this.fileName;
        }

        protected boolean getFileFound() {
            return this.fileFound;
        }

        protected String getFilePath() {
            return this.filePath;
        }

        protected String getFileBasename() {
            return this.fileBasename;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize() throws SchedulerException {
            InputStream f = null;
            try {
                String furl = null;
                File file = new File(this.getFileName());
                if (!file.exists()) {
                    URL url = JobInitializationPlugin.this.classLoadHelper.getResource(this.getFileName());
                    if (url != null) {
                        furl = URLDecoder.decode(url.getPath());
                        file = new File(furl);
                        try {
                            f = url.openStream();
                        }
                        catch (IOException ignor) {}
                    }
                } else {
                    try {
                        f = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                }
                if (f == null) {
                    if (JobInitializationPlugin.this.isFailOnFileNotFound()) {
                        throw new SchedulerException("File named '" + this.getFileName() + "' does not exist.");
                    }
                    JobInitializationPlugin.this.getLog().warn((Object)("File named '" + this.getFileName() + "' does not exist."));
                } else {
                    this.fileFound = true;
                    this.filePath = furl != null ? furl : file.getAbsolutePath();
                    this.fileBasename = file.getName();
                }
            }
            finally {
                try {
                    if (f != null) {
                        f.close();
                    }
                }
                catch (IOException ioe) {
                    JobInitializationPlugin.this.getLog().warn((Object)("Error closing jobs file " + this.getFileName()), (Throwable)ioe);
                }
            }
        }
    }
}

