/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.quartz.simpl;

import com.alibaba.dts.shade.org.quartz.simpl.InitThreadContextClassLoadHelper;
import com.alibaba.dts.shade.org.quartz.simpl.LoadingLoaderClassLoadHelper;
import com.alibaba.dts.shade.org.quartz.simpl.SimpleClassLoadHelper;
import com.alibaba.dts.shade.org.quartz.simpl.ThreadContextClassLoadHelper;
import com.alibaba.dts.shade.org.quartz.spi.ClassLoadHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

public class CascadingClassLoadHelper
implements ClassLoadHelper {
    private LinkedList loadHelpers;
    private ClassLoadHelper bestCandidate;

    public void initialize() {
        this.loadHelpers = new LinkedList();
        this.loadHelpers.add(new LoadingLoaderClassLoadHelper());
        this.loadHelpers.add(new SimpleClassLoadHelper());
        this.loadHelpers.add(new ThreadContextClassLoadHelper());
        this.loadHelpers.add(new InitThreadContextClassLoadHelper());
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext()) {
            ClassLoadHelper loadHelper = (ClassLoadHelper)iter.next();
            loadHelper.initialize();
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.bestCandidate != null) {
            try {
                return this.bestCandidate.loadClass(name);
            }
            catch (Exception e) {
                this.bestCandidate = null;
            }
        }
        ClassNotFoundException cnfe = null;
        Class clazz = null;
        ClassLoadHelper loadHelper = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext()) {
            loadHelper = (ClassLoadHelper)iter.next();
            try {
                clazz = loadHelper.loadClass(name);
                break;
            }
            catch (ClassNotFoundException e) {
                cnfe = e;
            }
        }
        if (clazz == null) {
            throw cnfe;
        }
        this.bestCandidate = loadHelper;
        return clazz;
    }

    public URL getResource(String name) {
        if (this.bestCandidate != null) {
            try {
                return this.bestCandidate.getResource(name);
            }
            catch (Exception e) {
                this.bestCandidate = null;
            }
        }
        URL result = null;
        ClassLoadHelper loadHelper = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext() && (result = (loadHelper = (ClassLoadHelper)iter.next()).getResource(name)) == null) {
        }
        this.bestCandidate = loadHelper;
        return result;
    }

    public InputStream getResourceAsStream(String name) {
        if (this.bestCandidate != null) {
            try {
                return this.bestCandidate.getResourceAsStream(name);
            }
            catch (Exception e) {
                this.bestCandidate = null;
            }
        }
        InputStream result = null;
        ClassLoadHelper loadHelper = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext() && (result = (loadHelper = (ClassLoadHelper)iter.next()).getResourceAsStream(name)) == null) {
        }
        this.bestCandidate = loadHelper;
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.bestCandidate == null ? Thread.currentThread().getContextClassLoader() : this.bestCandidate.getClassLoader();
    }
}

