/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.quartz.utils;

import com.alibaba.dts.shade.org.quartz.utils.DirtyFlagMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public class StringKeyDirtyFlagMap
extends DirtyFlagMap {
    static final long serialVersionUID = -9076749120524952280L;
    private boolean allowsTransientData = false;

    public StringKeyDirtyFlagMap() {
    }

    public StringKeyDirtyFlagMap(int initialCapacity) {
        super(initialCapacity);
    }

    public StringKeyDirtyFlagMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public String[] getKeys() {
        return this.keySet().toArray(new String[this.size()]);
    }

    public void setAllowsTransientData(boolean allowsTransientData) {
        if (this.containsTransientData() && !allowsTransientData) {
            throw new IllegalStateException("Cannot set property 'allowsTransientData' to 'false' when data map contains non-serializable objects.");
        }
        this.allowsTransientData = allowsTransientData;
    }

    public boolean getAllowsTransientData() {
        return this.allowsTransientData;
    }

    public boolean containsTransientData() {
        if (!this.getAllowsTransientData()) {
            return false;
        }
        String[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Object o = super.get(keys[i]);
            if (o instanceof Serializable) continue;
            return true;
        }
        return false;
    }

    public void removeTransientData() {
        if (!this.getAllowsTransientData()) {
            return;
        }
        String[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Object o = super.get(keys[i]);
            if (o instanceof Serializable) continue;
            this.remove(keys[i]);
        }
    }

    public void putAll(Map map) {
        Iterator entryIter = map.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry entry = entryIter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void put(String key, int value) {
        super.put(key, new Integer(value));
    }

    public void put(String key, long value) {
        super.put(key, new Long(value));
    }

    public void put(String key, float value) {
        super.put(key, new Float(value));
    }

    public void put(String key, double value) {
        super.put(key, new Double(value));
    }

    public void put(String key, boolean value) {
        super.put(key, new Boolean(value));
    }

    public void put(String key, char value) {
        super.put(key, new Character(value));
    }

    public void put(String key, String value) {
        super.put(key, value);
    }

    public Object put(Object key, Object value) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Keys in map must be Strings.");
        }
        return super.put(key, value);
    }

    public int getInt(String key) {
        Object obj = this.get(key);
        try {
            return (Integer)obj;
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not an Integer.");
        }
    }

    public long getLong(String key) {
        Object obj = this.get(key);
        try {
            return (Long)obj;
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Long.");
        }
    }

    public float getFloat(String key) {
        Object obj = this.get(key);
        try {
            return ((Float)obj).floatValue();
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Float.");
        }
    }

    public double getDouble(String key) {
        Object obj = this.get(key);
        try {
            return (Double)obj;
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Double.");
        }
    }

    public boolean getBoolean(String key) {
        Object obj = this.get(key);
        try {
            return (Boolean)obj;
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Boolean.");
        }
    }

    public char getChar(String key) {
        Object obj = this.get(key);
        try {
            return ((Character)obj).charValue();
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Character.");
        }
    }

    public String getString(String key) {
        Object obj = this.get(key);
        try {
            return (String)obj;
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a String.");
        }
    }
}

