/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.middleware.innerlog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class LogConfigure {
    public abstract InputStream configure();

    public static InputStream getResourceFromClassPath(String resourceName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
    }

    public static InputStream getResourceFromFileSystem(String filePath) {
        FileInputStream inputStream = null;
        File systemConfigFile = new File(filePath);
        if (systemConfigFile.exists()) {
            try {
                inputStream = new FileInputStream(systemConfigFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    public static String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("BufferedReader readLine Error! ", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

