/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.middleware.innerlog;

import com.alibaba.dts.shade.org.apache.commons.lang.ClassUtils;
import com.alibaba.dts.shade.org.apache.commons.lang.reflect.MethodUtils;
import com.alibaba.middleware.innerlog.LogLevel;
import com.alibaba.middleware.innerlog.LoggerClassLoader;
import com.alibaba.middleware.innerlog.LoggerMethodCache;
import com.alibaba.middleware.innerlog.LoggerMethodEnum;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Logger {
    private static final LoggerMethodCache methodCache = new LoggerMethodCache();
    private final LoggerClassLoader loggerClassLoader;
    private String appKey = null;
    private String appValue = null;
    private final Object innerlogback;
    private Method setMDC;
    private Method removeMDC;

    public Logger(Object innerlogback, LoggerClassLoader loggerClassLoader) {
        this(innerlogback, loggerClassLoader, null, null);
    }

    public Logger(Object innerlogback, LoggerClassLoader loggerClassLoader, String appKey, String appValue) {
        this.loggerClassLoader = loggerClassLoader;
        this.innerlogback = innerlogback;
        this.appKey = appKey;
        this.appValue = appValue;
        try {
            this.setMDC = MethodUtils.getAccessibleMethod(ClassUtils.getClass(loggerClassLoader, "org.slf4j.MDC"), "put", new Class[]{String.class, String.class});
            this.setMDC.setAccessible(true);
            this.removeMDC = MethodUtils.getAccessibleMethod(ClassUtils.getClass(loggerClassLoader, "org.slf4j.MDC"), "remove", new Class[]{String.class});
            this.removeMDC.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return (String)this.invokeMethod(LoggerMethodEnum.GET_NAME, new Object[0]);
    }

    public boolean isTraceEnabled() {
        return (Boolean)this.invokeMethod(LoggerMethodEnum.IS_TRACE_ENABLED, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(String msg) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.TRACE, msg);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(String format, Object arg) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.TRACE_FORMAT_ONE, format, arg);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(String format, Object arg1, Object arg2) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.TRACE_FORMAT_TWO, format, arg1, arg2);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(String format, Object ... arguments) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.TRACE_FORMAT_MANY, format, arguments);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(String msg, Throwable t) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.TRACE_THROWABLE, msg, t);
        }
        finally {
            this.clearMDC();
        }
    }

    public boolean isDebugEnabled() {
        return (Boolean)this.invokeMethod(LoggerMethodEnum.IS_DEBUG_ENABLED, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String msg) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.DEBUG, msg);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String format, Object arg) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.DEBUG_FORMAT_ONE, format, arg);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String format, Object arg1, Object arg2) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.DEBUG_FORMAT_TWO, format, arg1, arg2);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String format, Object ... arguments) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.DEBUG_FORMAT_MANY, format, arguments);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String msg, Throwable t) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.DEBUG_THROWABLE, msg, t);
        }
        finally {
            this.clearMDC();
        }
    }

    public boolean isInfoEnabled() {
        return (Boolean)this.invokeMethod(LoggerMethodEnum.IS_INFO_ENABLED, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String msg) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.INFO, msg);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String format, Object arg) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.INFO_FORMAT_ONE, format, arg);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String format, Object arg1, Object arg2) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.INFO_FORMAT_TWO, format, arg1, arg2);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String format, Object ... arguments) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.INFO_FORMAT_MANY, format, arguments);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String msg, Throwable t) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.INFO_THROWABLE, msg, t);
        }
        finally {
            this.clearMDC();
        }
    }

    public boolean isWarnEnabled() {
        return (Boolean)this.invokeMethod(LoggerMethodEnum.IS_WARN_ENABLED, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.WARN, msg);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String format, Object arg) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.WARN_FORMAT_ONE, format, arg);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String format, Object arg1, Object arg2) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.WARN_FORMAT_TWO, format, arg1, arg2);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String format, Object ... arguments) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.WARN_FORMAT_MANY, format, arguments);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg, Throwable t) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.WARN_THROWABLE, msg, t);
        }
        finally {
            this.clearMDC();
        }
    }

    public boolean isErrorEnabled() {
        return (Boolean)this.invokeMethod(LoggerMethodEnum.IS_ERROR_ENABLED, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String msg) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.ERROR, msg);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String format, Object arg) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.ERROR_FORMAT_ONE, format, arg);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String format, Object arg1, Object arg2) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.ERROR_FORMAT_TWO, format, arg1, arg2);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String format, Object ... arguments) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.ERROR_FORMAT_MANY, format, arguments);
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String msg, Throwable t) {
        try {
            this.prepareMDC();
            this.invokeMethod(LoggerMethodEnum.ERROR_THROWABLE, msg, t);
        }
        finally {
            this.clearMDC();
        }
    }

    public void setLevel(LogLevel level) {
        try {
            Class levelClass = ClassUtils.getClass(this.loggerClassLoader, "ch.qos.logback.classic.Level");
            Object logBackLevel = MethodUtils.invokeStaticMethod(levelClass, "toLevel", level.name());
            MethodUtils.invokeMethod(this.innerlogback, "setLevel", logBackLevel);
        }
        catch (Exception e) {
            throw new RuntimeException("setLevel to inner logback Error! ", e);
        }
    }

    private void prepareMDC() {
        if (this.appKey != null && this.setMDC != null) {
            try {
                this.setMDC.invoke(null, this.appKey, this.appValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void clearMDC() {
        if (this.appKey != null && this.removeMDC != null) {
            try {
                this.removeMDC.invoke(null, this.appKey);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Object invokeMethod(LoggerMethodEnum methodEnum, Object ... arguments) {
        Integer classLoaderId = this.loggerClassLoader.getId();
        try {
            if (!methodCache.containsKey(classLoaderId, methodEnum.getmKey())) {
                methodCache.put(classLoaderId, methodEnum.getmKey(), this.innerlogback.getClass(), methodEnum.getmName(), methodEnum.getParmClassTypes());
            }
            return methodCache.invoke(classLoaderId, methodEnum.getmKey(), this.innerlogback, arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringBuilder sb = new StringBuilder("invokeMethod Error! ");
            sb.append(" class: ").append(this.innerlogback.getClass());
            sb.append(" method: ").append(methodEnum.getmKey());
            sb.append(" arguments: ").append(Arrays.toString(arguments));
            throw new RuntimeException(sb.toString(), e);
        }
    }
}

