/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.config;

import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.Cluster;
import com.alibaba.tmq.common.exception.InitException;
import com.alibaba.tmq.common.remoting.protocol.RemotingSerializable;
import com.alibaba.tmq.common.util.DiamondHelper;
import com.alibaba.tmq.common.util.IdAndKeyUtil;
import com.alibaba.tmq.common.util.RemotingUtil;

public class ClientConfig
implements Constants {
    private int coreRemotingThreads = DEFAULT_REMOTING_THREADS * 8;
    private int maxRemotingThreads = DEFAULT_REMOTING_THREADS * 12;
    private long heartBeatIntervalTime = 30000L;
    private long connectionTimeout = 3000L;
    private String zkHosts;
    private int zkSessionTimeout = 10000;
    private int zkConnectionTimeout = 10000;
    private int queueSize = 1000;
    private String version;
    private String localAddress;
    private String clientId;
    private int clusterId = -1;
    private boolean openMonitor = false;
    private boolean zkHostsAutoChange = true;
    private String domainName;
    private String backupDomainName;
    private int backupClusterId = -1;

    public void init() throws InitException {
        try {
            this.version = "1.6.13-SNAPSHOT";
        }
        catch (Throwable e) {
            throw new InitException("[ClientConfig]: init version error", e);
        }
        String json = DiamondHelper.getData("com.alibaba.tmq.client.config.dataId", 10000L);
        if (StringUtil.isBlank(json)) {
            throw new InitException("[ClientConfig]: init get ClientConfig error, dataId:com.alibaba.tmq.client.config.dataId");
        }
        ClientConfig clientConfig = ClientConfig.newInstance(json);
        if (this.clusterId < 0) {
            this.clusterId = clientConfig.getClusterId();
        }
        if (!Cluster.isValid(this.clusterId)) {
            throw new InitException("[ClientConfig]: init clusterId is not valid error, this:" + this);
        }
        this.localAddress = RemotingUtil.getLocalAddress();
        try {
            this.clientId = IdAndKeyUtil.acquireUniqueId() + "-" + this.localAddress;
        }
        catch (Throwable e) {
            throw new InitException("[ClientConfig]: init clientId error", e);
        }
        if (StringUtil.isBlank(this.domainName)) {
            try {
                this.domainName = DiamondHelper.getData("com.alibaba.tmq.common.domainName", 10000L);
            }
            catch (Throwable e) {
                throw new InitException("[ClientConfig]: get domainName from diamond error", e);
            }
        }
        if (StringUtil.isBlank(this.domainName)) {
            throw new InitException("[ClientConfig]: domainName is empty error, domainName:" + this.domainName);
        }
    }

    public static ClientConfig newInstance(String json) {
        return RemotingSerializable.fromJson(json, ClientConfig.class);
    }

    public String toString() {
        return RemotingSerializable.toJson(this, false);
    }

    public int getCoreRemotingThreads() {
        return this.coreRemotingThreads;
    }

    public void setCoreRemotingThreads(int coreRemotingThreads) {
        this.coreRemotingThreads = coreRemotingThreads;
    }

    public int getMaxRemotingThreads() {
        return this.maxRemotingThreads;
    }

    public void setMaxRemotingThreads(int maxRemotingThreads) {
        this.maxRemotingThreads = maxRemotingThreads;
    }

    public long getHeartBeatIntervalTime() {
        return this.heartBeatIntervalTime;
    }

    public void setHeartBeatIntervalTime(long heartBeatIntervalTime) {
        this.heartBeatIntervalTime = heartBeatIntervalTime;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getZkHosts() {
        return this.zkHosts;
    }

    public void setZkHosts(String zkHosts) {
        this.zkHosts = zkHosts;
    }

    public int getZkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public void setZkSessionTimeout(int zkSessionTimeout) {
        this.zkSessionTimeout = zkSessionTimeout;
    }

    public int getZkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public void setZkConnectionTimeout(int zkConnectionTimeout) {
        this.zkConnectionTimeout = zkConnectionTimeout;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(int clusterId) {
        this.clusterId = clusterId;
    }

    public boolean isOpenMonitor() {
        return this.openMonitor;
    }

    public void setOpenMonitor(boolean openMonitor) {
        this.openMonitor = openMonitor;
    }

    public boolean isZkHostsAutoChange() {
        return this.zkHostsAutoChange;
    }

    public void setZkHostsAutoChange(boolean zkHostsAutoChange) {
        this.zkHostsAutoChange = zkHostsAutoChange;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getBackupDomainName() {
        return this.backupDomainName;
    }

    public void setBackupDomainName(String backupDomainName) {
        this.backupDomainName = backupDomainName;
    }

    public int getBackupClusterId() {
        return this.backupClusterId;
    }

    public void setBackupClusterId(int backupClusterId) {
        this.backupClusterId = backupClusterId;
    }
}

