/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.remoting;

import com.alibaba.dts.shade.io.netty.channel.Channel;
import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.client.remoting.processor.ClientRequestProcessor;
import com.alibaba.tmq.client.remoting.proxy.ClientInvocationHandler;
import com.alibaba.tmq.client.remoting.timer.ClientHeartBeatTimer;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.context.InvocationContext;
import com.alibaba.tmq.common.domain.ConnectionKey;
import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;
import com.alibaba.tmq.common.domain.result.Result;
import com.alibaba.tmq.common.exception.InitException;
import com.alibaba.tmq.common.exception.RemotingConnectException;
import com.alibaba.tmq.common.exception.RemotingSendRequestException;
import com.alibaba.tmq.common.exception.RemotingTimeoutException;
import com.alibaba.tmq.common.remoting.netty.NettyClientConfig;
import com.alibaba.tmq.common.remoting.netty.NettyRemotingClient;
import com.alibaba.tmq.common.remoting.protocol.RemotingCommand;
import com.alibaba.tmq.common.service.ServerService;
import com.alibaba.tmq.common.util.ListUtil;
import com.alibaba.tmq.common.util.RandomUtil;
import com.alibaba.tmq.common.util.TableUtil;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class ClientRemoting
extends ClientContext
implements Constants {
    private static final Log logger = LogFactory.getLog(ClientRemoting.class);
    private NettyRemotingClient client = null;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        int index = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            ++this.index;
            return new Thread(runnable, "TMQ-heart-beat-thread-" + this.index);
        }
    });
    private static InvocationHandler invocationHandler = new ClientInvocationHandler();
    public static ServerService serverService = ClientRemoting.proxyInterface(ServerService.class);
    private ThreadPoolExecutor executors = null;
    private LinkedBlockingQueue<Runnable> requestQueue;
    private volatile List<String> cachedServerList;
    private volatile List<String> cachedBackupServerList;

    public void init() throws InitException {
        this.initRemotingClient();
        this.initHeartBeatTimer();
    }

    private void initRemotingClient() throws InitException {
        NettyClientConfig config = new NettyClientConfig();
        this.requestQueue = new LinkedBlockingQueue(clientConfig.getQueueSize());
        ClientRequestProcessor processor = new ClientRequestProcessor(this.requestQueue);
        processor.init();
        this.client = new NettyRemotingClient(config);
        this.executors = new ThreadPoolExecutor(clientConfig.getCoreRemotingThreads(), clientConfig.getMaxRemotingThreads(), 60000L, TimeUnit.MILLISECONDS, this.requestQueue, new ThreadFactory(){
            int index = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                ++this.index;
                return new Thread(runnable, "TMQ-remoting-thread-" + this.index);
            }
        });
        this.client.registerProcessor(0, processor, this.executors);
        try {
            this.client.start();
        }
        catch (Throwable e) {
            throw new InitException("[ClientRemoting]: initRemotingClient error", e);
        }
    }

    public void initConnection(String instanceName, int roleType, String roleId, String topic, String tag) throws InitException {
        List<String> serverList = this.getServerList();
        List<String> backupServerList = this.getbackupServerList();
        if (StringUtil.isNotBlank(clientConfig.getBackupDomainName()) && !CollectionUtils.isEmpty(backupServerList)) {
            serverList.addAll(backupServerList);
        }
        if (ListUtil.isEmpty(serverList)) {
            logger.error((Object)("[ClientRemoting]: initConnection error, serverList is empty, roleType:" + roleType + ", roleId:" + roleId + ", topic:" + topic + ", tag:" + tag));
            throw new InitException("initConnection error, serverList is empty");
        }
        for (String server : serverList) {
            this.connectServer(instanceName, server, roleType, roleId, topic, tag);
        }
    }

    public void removeConnection(String instanceName, int roleType, String roleId, String topic, String tag) throws InitException {
        List<String> serverList = this.getServerList();
        List<String> backupServerList = this.getbackupServerList();
        if (StringUtil.isNotBlank(clientConfig.getBackupDomainName()) && !CollectionUtils.isEmpty(backupServerList)) {
            serverList.addAll(backupServerList);
        }
        if (ListUtil.isEmpty(serverList)) {
            logger.error((Object)("[ClientRemoting]: removeConnection error, serverList is empty, roleType:" + roleType + ", roleId:" + roleId + ", topic:" + topic + ", tag:" + tag));
            return;
        }
        for (String server : serverList) {
            this.disconnectServer(instanceName, server, roleType, roleId, topic, tag);
        }
    }

    public void connectServer(String instanceName, String server, int roleType, String roleId, String topic, String tag) {
        Result<Boolean> connectResult = null;
        try {
            ConnectionChannel connectionChannel = new ConnectionChannel(server, roleType, roleId);
            connectionChannel.setInstanceName(instanceName);
            InvocationContext.setConnectionChannel(connectionChannel);
            connectResult = serverService.connect(topic, tag);
        }
        catch (Throwable e) {
            logger.error((Object)("[ClientRemoting]: connectServer error, clientConfig:" + clientConfig + ", server:" + server + ", roleType:" + roleType + ", roleId:" + roleId + ", topic:" + topic + ", tag:" + tag + ", instanceName" + instanceName), e);
        }
        if (connectResult == null || !connectResult.getData().booleanValue()) {
            logger.error((Object)("[ClientRemoting]: connectServer failed, clientConfig:" + clientConfig + ", server:" + server + ", roleType:" + roleType + ", roleId:" + roleId + ", topic:" + topic + ", tag:" + tag + ", connectResult:" + connectResult));
        }
    }

    public void disconnectServer(String instanceName, String server, int roleType, String roleId, String topic, String tag) {
        Result<Boolean> disconnectResult = null;
        try {
            ConnectionChannel connectionChannel = new ConnectionChannel(server, roleType, roleId);
            connectionChannel.setInstanceName(instanceName);
            InvocationContext.setConnectionChannel(connectionChannel);
            disconnectResult = serverService.disconnect(new ConnectionKey(roleId, topic, tag));
        }
        catch (Throwable e) {
            logger.error((Object)("[ClientRemoting]: disconnectServer error, clientConfig:" + clientConfig + ", server:" + server + ", roleType:" + roleType + ", roleId:" + roleId + ", topic:" + topic + ", tag:" + tag + ", instanceName" + instanceName), e);
        }
        if (disconnectResult == null || !disconnectResult.getData().booleanValue()) {
            logger.error((Object)("[ClientRemoting]: disconnectServer failed, clientConfig:" + clientConfig + ", server:" + server + ", roleType:" + roleType + ", roleId:" + roleId + ", topic:" + topic + ", tag:" + tag + ", disconnectResult:" + disconnectResult));
        }
    }

    public String acquireRandomServer() {
        if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
            return RandomUtil.getRandomObject4List(this.cachedBackupServerList);
        }
        return RandomUtil.getRandomObject4List(this.cachedServerList);
    }

    public String acquireFireServer(String messageKey) {
        if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
            if (ListUtil.isEmpty(this.cachedBackupServerList)) {
                return null;
            }
            return TableUtil.acquireFireServer(this.cachedBackupServerList, messageKey);
        }
        if (ListUtil.isEmpty(this.cachedServerList)) {
            return null;
        }
        return TableUtil.acquireFireServer(this.cachedServerList, messageKey);
    }

    public List<String> getServerList() {
        if (null == this.cachedServerList) {
            this.cachedServerList = zookeeper.getServerList();
        }
        return this.cachedServerList;
    }

    public List<String> getbackupServerList() {
        if (null == this.cachedBackupServerList) {
            this.cachedBackupServerList = zookeeper.getbackupServerList();
        }
        return this.cachedBackupServerList;
    }

    private void initHeartBeatTimer() throws InitException {
        try {
            this.executorService.scheduleAtFixedRate(new ClientHeartBeatTimer(), clientConfig.getHeartBeatIntervalTime(), clientConfig.getHeartBeatIntervalTime(), TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new InitException("[ClientRemoting]: initHeartBeatTimer error, heartBeatIntervalTime:" + clientConfig.getHeartBeatIntervalTime(), e);
        }
        logger.warn((Object)("[ClientRemoting]: initHeartBeatTimer success, heartBeatIntervalTime:" + clientConfig.getHeartBeatIntervalTime()));
    }

    public static <T> T proxyInterface(Class<T> interfaceClass) {
        return proxyService.proxyInterface(interfaceClass, invocationHandler);
    }

    public Channel getAndCreateChannel(String addr) throws InterruptedException {
        return this.client.getAndCreateChannel(addr);
    }

    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        return this.client.invokeSync(addr, request, timeoutMillis);
    }

    public AtomicLong getCounter(ConcurrentHashMap<String, AtomicLong> heartBeatCounter, String key) {
        AtomicLong existCounter;
        AtomicLong counter = heartBeatCounter.get(key);
        if (null == counter && (existCounter = heartBeatCounter.putIfAbsent(key, counter = new AtomicLong(0L))) != null) {
            counter = existCounter;
        }
        return counter;
    }

    public void increaseCounter(ConnectionChannel connectionChannel) {
        switch (connectionChannel.getRoleType()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void setCachedServerList(List<String> cachedServerList) {
        this.cachedServerList = cachedServerList;
    }

    public void setCachedBackupServerList(List<String> cachedBackupServerList) {
        this.cachedBackupServerList = cachedBackupServerList;
    }
}

