/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.service;

import com.alibaba.tmq.client.TMQFactory;
import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.client.system.consumer.executer.ConsumerExecuter;
import com.alibaba.tmq.client.system.producer.executer.TransactionProducerExecuter;
import com.alibaba.tmq.common.context.InvocationContext;
import com.alibaba.tmq.common.domain.Action;
import com.alibaba.tmq.common.domain.ConsumerKey;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.ProducerKey;
import com.alibaba.tmq.common.domain.TransactionStatus;
import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;
import com.alibaba.tmq.common.domain.result.Result;
import com.alibaba.tmq.common.domain.result.ResultCode;
import com.alibaba.tmq.common.service.ClientService;
import com.alibaba.tmq.common.util.LoggerUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultClientService
extends ClientContext
implements ClientService {
    private static final Log logger = LogFactory.getLog(DefaultClientService.class);

    @Override
    public Result<String> heartBeatCheck() {
        ConnectionChannel connectionChannel = InvocationContext.acquireConnectionChannel();
        try {
            clientRemoting.increaseCounter(connectionChannel);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultClientService]: heartBeatCheck error, connectionChannel:" + connectionChannel), e);
            return new Result<String>("something wrong with connectionChannel:" + connectionChannel, ResultCode.FAILURE);
        }
        return new Result<String>("I am alive !", ResultCode.SUCCESS);
    }

    @Override
    public Result<Action> push(String consumerId, Message message) {
        logger.error((Object)("[DefaultClientService]: push error, consumerId:" + consumerId + ", message:" + message));
        return new Result<Action>(Action.RETRY, ResultCode.FAILURE);
    }

    @Override
    public Result<Action> push(ConsumerKey consumerKey, Message message) {
        ConnectionChannel connectionChannel = InvocationContext.acquireConnectionChannel();
        long startTime = System.currentTimeMillis();
        ConsumerExecuter consumerExecuter = TMQFactory.aquireConsumerExecuter(consumerKey, connectionChannel.getInstanceName());
        if (null == consumerExecuter) {
            logger.error((Object)("[DefaultClientService]: push consumer is null error, consumerKey:" + consumerKey + ", message:" + message + ", instanceName:" + connectionChannel.getInstanceName()));
            LoggerUtil.info(message, "[TMQ-CLIENT-CONSUMER]-push-consumerExecuter-failed-" + consumerKey + "-" + connectionChannel.getInstanceName(), startTime, clientConfig.getLocalAddress());
            return new Result<Action>(Action.RETRY, ResultCode.CONSUMER_NULL_ERROR);
        }
        Result<Action> consumeResult = null;
        try {
            consumeResult = consumerExecuter.consume(consumerKey, message, connectionChannel);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultClientService]: consume error, consumerKey:" + consumerKey + ", instanceName:" + connectionChannel.getInstanceName() + ", message:" + message), e);
            LoggerUtil.info(message, "[TMQ-CLIENT-CONSUMER]-push-consume-error-" + consumerKey + "-" + connectionChannel.getInstanceName(), startTime, clientConfig.getLocalAddress());
            return new Result<Action>(Action.RETRY, ResultCode.CONSUME_EXCEPTION);
        }
        if (null == consumeResult) {
            LoggerUtil.info(message, "[TMQ-CLIENT-CONSUMER]-push-result-failed-" + consumerKey + "-" + connectionChannel.getInstanceName(), startTime, clientConfig.getLocalAddress());
            return new Result<Action>(Action.RETRY, ResultCode.FAILURE);
        }
        LoggerUtil.info(message, "[TMQ-CLIENT-CONSUMER]-push-" + consumerKey + "-" + connectionChannel.getInstanceName() + "-" + consumeResult, startTime, clientConfig.getLocalAddress());
        return consumeResult;
    }

    @Override
    public Result<TransactionStatus> check(ProducerKey producerKey, Message message) {
        TransactionProducerExecuter producerExecuter = TMQFactory.aquireTransactionProducerExecuter(producerKey.getProducerId(), null);
        if (null == producerExecuter) {
            logger.error((Object)("[DefaultClientService]: check producer is null error, producerId:" + producerKey.getProducerId() + ", message:" + message));
            return new Result<TransactionStatus>(TransactionStatus.UnKnow, ResultCode.PRODUCER_NULL_ERROR);
        }
        Result<TransactionStatus> checkResult = null;
        try {
            checkResult = producerExecuter.check(message);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultClientService]: check error, producerId:" + producerKey.getProducerId() + ", message:" + message));
            return new Result<TransactionStatus>(TransactionStatus.UnKnow, ResultCode.CHECK_EXCEPTION);
        }
        if (null == checkResult) {
            return new Result<TransactionStatus>(TransactionStatus.UnKnow, ResultCode.FAILURE);
        }
        return checkResult;
    }
}

