/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.system.producer.implement;

import com.alibaba.dts.shade.com.taobao.common.fulllinkstresstesting.SplitEnvUtil;
import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.client.remoting.ClientRemoting;
import com.alibaba.tmq.client.system.producer.Producer;
import com.alibaba.tmq.client.system.producer.config.ProducerConfig;
import com.alibaba.tmq.client.system.producer.executer.ProducerExecuter;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.context.InvocationContext;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;
import com.alibaba.tmq.common.domain.result.DeleteResult;
import com.alibaba.tmq.common.domain.result.Result;
import com.alibaba.tmq.common.domain.result.ResultCode;
import com.alibaba.tmq.common.domain.result.UpdateResult;
import com.alibaba.tmq.common.exception.TMQClientException;
import com.alibaba.tmq.common.exception.TMQException;
import com.alibaba.tmq.common.exception.TMQServerException;
import com.alibaba.tmq.common.service.ServerService;
import com.alibaba.tmq.common.util.IdAndKeyUtil;
import com.alibaba.tmq.common.util.ListUtil;
import com.alibaba.tmq.common.util.LoggerUtil;
import com.alibaba.tmq.common.util.MessageUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultProducer
extends ClientContext
implements Producer,
Constants {
    private static final Log logger = LogFactory.getLog(DefaultProducer.class);
    private final ServerService serverService = ClientRemoting.proxyInterface(ServerService.class);
    private final ProducerConfig producerConfig;
    private final ProducerExecuter producerExecuter;

    public DefaultProducer(ProducerConfig producerConfig, ProducerExecuter producerExecuter) {
        this.producerConfig = producerConfig;
        this.producerExecuter = producerExecuter;
    }

    @Override
    public void start() {
        if (!SplitEnvUtil.needStartDTS()) {
            logger.error((Object)"[DefaultProducer]: start error, because of isolation environment");
            return;
        }
        try {
            DefaultProducer.initClient();
        }
        catch (Throwable e) {
            throw new RuntimeException("[DefaultProducer]: start initClient error, clientConfig:" + clientConfig + ", producerConfig:" + this.producerConfig, e);
        }
        try {
            clientRemoting.initConnection(this.producerConfig.getInstanceName(), 0, this.producerConfig.getProducerId(), "NULL", "NULL");
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultProducer]: start initConnection error, clientConfig:" + clientConfig + ", producerConfig:" + this.producerConfig), e);
            throw new RuntimeException("[DefaultProducer]: start initConnection error, clientConfig:" + clientConfig + ", producerConfig:" + this.producerConfig, e);
        }
        this.producerExecuter.setStart(true);
    }

    @Override
    public List<Message> get(Message message) throws TMQException {
        if (!this.producerExecuter.isStart()) {
            throw new TMQClientException("producer has just create, not start");
        }
        try {
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                MessageUtil.reset(message, clientConfig.getBackupClusterId());
            } else {
                MessageUtil.reset(message, clientConfig.getClusterId());
            }
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        Result<Boolean> checkResult = null;
        try {
            checkResult = MessageUtil.check4Get(message);
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        if (!checkResult.getData().booleanValue()) {
            return new ArrayList<Message>();
        }
        IdAndKeyUtil.renderingMessageKey(this.producerConfig.getProducerId(), message);
        String server = clientRemoting.acquireFireServer(message.getMessageKey());
        if (StringUtil.isBlank(server)) {
            throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
        }
        List<Message> messageList = this.get(message, server);
        if (null == messageList) {
            String otherServer;
            List<String> serverList = clientRemoting.getServerList();
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                serverList = clientRemoting.getbackupServerList();
            }
            if (ListUtil.isEmpty(serverList)) {
                throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
            }
            Iterator<String> i$ = serverList.iterator();
            while (i$.hasNext() && (messageList = this.get(message, otherServer = i$.next())) == null) {
            }
        }
        if (null == messageList) {
            throw new TMQClientException(ResultCode.TIMEOUT.getInformation());
        }
        return messageList;
    }

    private List<Message> get(Message message, String server) {
        List<Message> messageList = null;
        try {
            InvocationContext.setConnectionChannel(new ConnectionChannel(server, 0, this.producerConfig.getProducerId()));
            messageList = this.serverService.get(message);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultProducer]: get message error, message:" + message), e);
        }
        return messageList;
    }

    @Override
    public UpdateResult update(Message message) throws TMQException {
        if (!this.producerExecuter.isStart()) {
            throw new TMQClientException("producer has just create, not start");
        }
        long startTime = System.currentTimeMillis();
        try {
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                MessageUtil.reset(message, clientConfig.getBackupClusterId());
            } else {
                MessageUtil.reset(message, clientConfig.getClusterId());
            }
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        Result<Boolean> checkResult = null;
        try {
            checkResult = MessageUtil.check4UpdateSingle(message);
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        if (!checkResult.getData().booleanValue()) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-update-single-check-failed", startTime, clientConfig.getLocalAddress());
            return new UpdateResult(checkResult);
        }
        IdAndKeyUtil.renderingMessageKey(this.producerConfig.getProducerId(), message);
        String server = clientRemoting.acquireFireServer(message.getMessageKey());
        if (StringUtil.isBlank(server)) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-update-single-server-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
        }
        Result<Boolean> updateResult = this.update(message, server);
        if (null == updateResult) {
            String otherServer;
            List<String> serverList = clientRemoting.getServerList();
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                serverList = clientRemoting.getbackupServerList();
            }
            if (ListUtil.isEmpty(serverList)) {
                LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-update-single-server-empty", startTime, clientConfig.getLocalAddress());
                throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
            }
            Iterator<String> i$ = serverList.iterator();
            while (i$.hasNext() && (updateResult = this.update(message, otherServer = i$.next())) == null) {
            }
        }
        if (null == updateResult) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-update-single-result-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQClientException(ResultCode.TIMEOUT.getInformation());
        }
        LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-update-single-" + updateResult, startTime, clientConfig.getLocalAddress());
        if (ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.equals(updateResult.getResultCode())) {
            throw new TMQServerException(ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.getInformation());
        }
        return new UpdateResult(updateResult);
    }

    private Result<Boolean> update(Message message, String server) {
        Result<Boolean> updateResult = null;
        try {
            InvocationContext.setConnectionChannel(new ConnectionChannel(server, 0, this.producerConfig.getProducerId()));
            updateResult = this.serverService.update(message);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultProducer]: update message error, message:" + message), e);
        }
        return updateResult;
    }

    public UpdateResult updateMessageList(List<Message> messageList) throws TMQException {
        long startTime = System.currentTimeMillis();
        String server = clientRemoting.acquireFireServer(messageList.get(0).getMessageKey());
        if (StringUtil.isBlank(server)) {
            LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-update-mulit-server-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
        }
        Result<Boolean> updateResult = this.update(messageList, server);
        if (null == updateResult) {
            String otherServer;
            List<String> serverList = clientRemoting.getServerList();
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                serverList = clientRemoting.getbackupServerList();
            }
            if (ListUtil.isEmpty(serverList)) {
                LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-update-mulit-server-empty", startTime, clientConfig.getLocalAddress());
                throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
            }
            Iterator<String> i$ = serverList.iterator();
            while (i$.hasNext() && (updateResult = this.update(messageList, otherServer = i$.next())) == null) {
            }
        }
        if (null == updateResult) {
            throw new TMQClientException(ResultCode.TIMEOUT.getInformation());
        }
        return new UpdateResult(updateResult);
    }

    private Result<Boolean> update(List<Message> messageList, String server) {
        Result<Boolean> updateResult = null;
        try {
            InvocationContext.setConnectionChannel(new ConnectionChannel(server, 0, this.producerConfig.getProducerId()));
            updateResult = this.serverService.update(messageList);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultProducer]: update messageList error, messageList:" + messageList), e);
        }
        return updateResult;
    }

    @Override
    public DeleteResult delete(Message message) throws TMQException {
        if (!this.producerExecuter.isStart()) {
            throw new TMQClientException("producer has just create, not start");
        }
        long startTime = System.currentTimeMillis();
        try {
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                MessageUtil.reset(message, clientConfig.getBackupClusterId());
            } else {
                MessageUtil.reset(message, clientConfig.getClusterId());
            }
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        Result<Boolean> checkResult = null;
        try {
            checkResult = MessageUtil.check4Delete(message);
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        if (!checkResult.getData().booleanValue()) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-delete-single-check-failed", startTime, clientConfig.getLocalAddress());
            return new DeleteResult(checkResult);
        }
        IdAndKeyUtil.renderingMessageKey(this.producerConfig.getProducerId(), message);
        String server = clientRemoting.acquireFireServer(message.getMessageKey());
        if (StringUtil.isBlank(server)) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-delete-single-server-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
        }
        Result<Boolean> deleteResult = this.delete(message, server);
        if (null == deleteResult) {
            String otherServer;
            List<String> serverList = clientRemoting.getServerList();
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                serverList = clientRemoting.getbackupServerList();
            }
            if (ListUtil.isEmpty(serverList)) {
                LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-delete-single-server-empty", startTime, clientConfig.getLocalAddress());
                throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
            }
            Iterator<String> i$ = serverList.iterator();
            while (i$.hasNext() && (deleteResult = this.delete(message, otherServer = i$.next())) == null) {
            }
        }
        if (null == deleteResult) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-delete-single-result-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQClientException(ResultCode.TIMEOUT.getInformation());
        }
        LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-delete-single-" + deleteResult, startTime, clientConfig.getLocalAddress());
        if (ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.equals(deleteResult.getResultCode())) {
            throw new TMQServerException(ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.getInformation());
        }
        return new DeleteResult(deleteResult);
    }

    private Result<Boolean> delete(Message message, String server) {
        Result<Boolean> deleteResult = null;
        try {
            InvocationContext.setConnectionChannel(new ConnectionChannel(server, 0, this.producerConfig.getProducerId()));
            deleteResult = this.serverService.delete(message);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultProducer]: delete message error, message:" + message), e);
        }
        return deleteResult;
    }

    public DeleteResult delete(List<Message> messageList) throws TMQException {
        if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
            MessageUtil.reset(messageList, clientConfig.getBackupClusterId());
        } else {
            MessageUtil.reset(messageList, clientConfig.getClusterId());
        }
        Result<Boolean> checkResult = MessageUtil.check4Delete(messageList);
        if (!checkResult.getData().booleanValue()) {
            return new DeleteResult(checkResult);
        }
        IdAndKeyUtil.renderingMessageKey(this.producerConfig.getProducerId(), messageList);
        String server = clientRemoting.acquireFireServer(messageList.get(0).getMessageKey());
        if (StringUtil.isBlank(server)) {
            return new DeleteResult(false, ResultCode.SERVER_ERROR);
        }
        Result<Boolean> deleteResult = null;
        try {
            InvocationContext.setConnectionChannel(new ConnectionChannel(server, 0, this.producerConfig.getProducerId()));
            deleteResult = this.serverService.delete(messageList);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultProducer]: delete message error, messageList:" + messageList), e);
        }
        if (null == deleteResult) {
            return new DeleteResult(false, ResultCode.DELETE_MESSAGE_TIMEOUT);
        }
        return new DeleteResult(deleteResult);
    }

    @Override
    public void shutdown() {
    }
}

