/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.util;

import com.alibaba.tmq.client.util.ArrayUtil;
import com.alibaba.tmq.client.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ClassUtil {
    public static final char RESOURCE_SEPARATOR_CHAR = '/';
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR = String.valueOf('.');
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String INNER_CLASS_SEPARATOR = String.valueOf('$');
    private static Map TYPE_MAP = Collections.synchronizedMap(new WeakHashMap());

    public static String getClassNameForObject(Object object) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getClassName(object.getClass().getName(), true);
    }

    public static String getClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getClassName(clazz.getName(), true);
    }

    public static String getClassName(String className) {
        return ClassUtil.getClassName(className, true);
    }

    private static String getClassName(String className, boolean processInnerClass) {
        if (StringUtil.isEmpty(className)) {
            return className;
        }
        if (processInnerClass) {
            className = className.replace('$', '.');
        }
        int length = className.length();
        int dimension = 0;
        int i = 0;
        while (i < length && className.charAt(i) == '[') {
            ++i;
            ++dimension;
        }
        if (dimension == 0) {
            return className;
        }
        if (length <= dimension) {
            return className;
        }
        StringBuffer componentTypeName = new StringBuffer();
        switch (className.charAt(dimension)) {
            case 'Z': {
                componentTypeName.append("boolean");
                break;
            }
            case 'B': {
                componentTypeName.append("byte");
                break;
            }
            case 'C': {
                componentTypeName.append("char");
                break;
            }
            case 'D': {
                componentTypeName.append("double");
                break;
            }
            case 'F': {
                componentTypeName.append("float");
                break;
            }
            case 'I': {
                componentTypeName.append("int");
                break;
            }
            case 'J': {
                componentTypeName.append("long");
                break;
            }
            case 'S': {
                componentTypeName.append("short");
                break;
            }
            case 'L': {
                if (className.charAt(length - 1) != ';' || length <= dimension + 2) {
                    return className;
                }
                componentTypeName.append(className.substring(dimension + 1, length - 1));
                break;
            }
            default: {
                return className;
            }
        }
        for (int i2 = 0; i2 < dimension; ++i2) {
            componentTypeName.append("[]");
        }
        return componentTypeName.toString();
    }

    public static String getShortClassNameForObject(Object object) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getShortClassName(object.getClass().getName());
    }

    public static String getShortClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getShortClassName(clazz.getName());
    }

    public static String getShortClassName(String className) {
        if (StringUtil.isEmpty(className)) {
            return className;
        }
        className = ClassUtil.getClassName(className, false);
        char[] chars = className.toCharArray();
        int lastDot = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '.') {
                lastDot = i + 1;
                continue;
            }
            if (chars[i] != '$') continue;
            chars[i] = 46;
        }
        return new String(chars, lastDot, chars.length - lastDot);
    }

    public static String getPackageNameForObject(Object object) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getPackageName(object.getClass().getName());
    }

    public static String getPackageName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getPackageName(clazz.getName());
    }

    public static String getPackageName(String className) {
        if (StringUtil.isEmpty(className)) {
            return null;
        }
        int i = (className = ClassUtil.getClassName(className, false)).lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return className.substring(0, i);
    }

    public static String getClassNameForObjectAsResource(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName().replace('.', '/') + ".class";
    }

    public static String getClassNameAsResource(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.getName().replace('.', '/') + ".class";
    }

    public static String getClassNameAsResource(String className) {
        if (className == null) {
            return null;
        }
        return className.replace('.', '/') + ".class";
    }

    public static String getPackageNameForObjectAsResource(Object object) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getPackageNameForObject(object).replace('.', '/');
    }

    public static String getPackageNameAsResource(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getPackageName(clazz).replace('.', '/');
    }

    public static String getPackageNameAsResource(String className) {
        if (className == null) {
            return null;
        }
        return ClassUtil.getPackageName(className).replace('.', '/');
    }

    public static Class getArrayClass(Class componentType, int dimension) {
        if (dimension <= 0) {
            return componentType;
        }
        if (componentType == null) {
            return null;
        }
        return Array.newInstance(componentType, new int[dimension]).getClass();
    }

    public static Class getArrayComponentType(Class type) {
        if (type == null) {
            return null;
        }
        return ClassUtil.getTypeInfo(type).getArrayComponentType();
    }

    public static int getArrayDimension(Class clazz) {
        if (clazz == null) {
            return -1;
        }
        return ClassUtil.getTypeInfo(clazz).getArrayDimension();
    }

    public static List getSuperclasses(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getTypeInfo(clazz).getSuperclasses();
    }

    public static List getInterfaces(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getTypeInfo(clazz).getInterfaces();
    }

    public static boolean isInnerClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return StringUtil.contains(clazz.getName(), '$');
    }

    public static boolean isAssignable(Class[] classes, Class[] fromClasses) {
        if (!ArrayUtil.isSameLength(fromClasses, classes)) {
            return false;
        }
        if (fromClasses == null) {
            fromClasses = ArrayUtil.EMPTY_CLASS_ARRAY;
        }
        if (classes == null) {
            classes = ArrayUtil.EMPTY_CLASS_ARRAY;
        }
        for (int i = 0; i < fromClasses.length; ++i) {
            if (ClassUtil.isAssignable(classes[i], fromClasses[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Class clazz, Class fromClass) {
        if (clazz == null) {
            return false;
        }
        if (fromClass == null) {
            return !clazz.isPrimitive();
        }
        if (clazz.isAssignableFrom(fromClass)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (Boolean.TYPE.equals(clazz)) {
                return Boolean.class.equals((Object)fromClass);
            }
            if (Byte.TYPE.equals(clazz)) {
                return Byte.class.equals((Object)fromClass);
            }
            if (Character.TYPE.equals(clazz)) {
                return Character.class.equals((Object)fromClass);
            }
            if (Short.TYPE.equals(clazz)) {
                return Short.class.equals((Object)fromClass) || Byte.TYPE.equals(fromClass) || Byte.class.equals((Object)fromClass);
            }
            if (Integer.TYPE.equals(clazz)) {
                return Integer.class.equals((Object)fromClass) || Byte.TYPE.equals(fromClass) || Byte.class.equals((Object)fromClass) || Short.TYPE.equals(fromClass) || Short.class.equals((Object)fromClass) || Character.TYPE.equals(fromClass) || Character.class.equals((Object)fromClass);
            }
            if (Long.TYPE.equals(clazz)) {
                return Long.class.equals((Object)fromClass) || Integer.TYPE.equals(fromClass) || Integer.class.equals((Object)fromClass) || Byte.TYPE.equals(fromClass) || Byte.class.equals((Object)fromClass) || Short.TYPE.equals(fromClass) || Short.class.equals((Object)fromClass) || Character.TYPE.equals(fromClass) || Character.class.equals((Object)fromClass);
            }
            if (Float.TYPE.equals(clazz)) {
                return Float.class.equals((Object)fromClass) || Long.TYPE.equals(fromClass) || Long.class.equals((Object)fromClass) || Integer.TYPE.equals(fromClass) || Integer.class.equals((Object)fromClass) || Byte.TYPE.equals(fromClass) || Byte.class.equals((Object)fromClass) || Short.TYPE.equals(fromClass) || Short.class.equals((Object)fromClass) || Character.TYPE.equals(fromClass) || Character.class.equals((Object)fromClass);
            }
            if (Double.TYPE.equals(clazz)) {
                return Double.class.equals((Object)fromClass) || Float.TYPE.equals(fromClass) || Float.class.equals((Object)fromClass) || Long.TYPE.equals(fromClass) || Long.class.equals((Object)fromClass) || Integer.TYPE.equals(fromClass) || Integer.class.equals((Object)fromClass) || Byte.TYPE.equals(fromClass) || Byte.class.equals((Object)fromClass) || Short.TYPE.equals(fromClass) || Short.class.equals((Object)fromClass) || Character.TYPE.equals(fromClass) || Character.class.equals((Object)fromClass);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TypeInfo getTypeInfo(Class type) {
        TypeInfo classInfo;
        if (type == null) {
            throw new IllegalArgumentException("Parameter clazz should not be null");
        }
        Map map = TYPE_MAP;
        synchronized (map) {
            classInfo = (TypeInfo)TYPE_MAP.get(type);
            if (classInfo == null) {
                classInfo = new TypeInfo(type);
                TYPE_MAP.put(type, classInfo);
            }
        }
        return classInfo;
    }

    public static Class getPrimitiveType(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz.equals(Long.class)) {
            return Long.TYPE;
        }
        if (clazz.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (clazz.equals(Short.class)) {
            return Short.TYPE;
        }
        if (clazz.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (clazz.equals(Double.class)) {
            return Double.TYPE;
        }
        if (clazz.equals(Float.class)) {
            return Float.TYPE;
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (clazz.equals(Character.class)) {
            return Character.TYPE;
        }
        return null;
    }

    public static Class getNonPrimitiveType(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Short.TYPE)) {
            return Short.class;
        }
        if (clazz.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.class;
        }
        return null;
    }

    protected static class TypeInfo {
        private Class type;
        private Class componentType;
        private int dimension;
        private List superclasses = new ArrayList(2);
        private List interfaces = new ArrayList(2);

        private TypeInfo(Class type) {
            this.type = type;
            Class componentType = null;
            if (type.isArray()) {
                componentType = type;
                do {
                    componentType = componentType.getComponentType();
                    ++this.dimension;
                } while (componentType.isArray());
            }
            this.componentType = componentType;
            if (this.dimension > 0) {
                Class<Object> superComponentType = (componentType = this.getNonPrimitiveType(componentType)).getSuperclass();
                if (superComponentType == null && !Object.class.equals((Object)componentType)) {
                    superComponentType = Object.class;
                }
                if (superComponentType != null) {
                    Class superclass = ClassUtil.getArrayClass(superComponentType, this.dimension);
                    this.superclasses.add(superclass);
                    this.superclasses.addAll(ClassUtil.getTypeInfo((Class)superclass).superclasses);
                } else {
                    for (int i = this.dimension - 1; i >= 0; --i) {
                        this.superclasses.add(ClassUtil.getArrayClass(Object.class, i));
                    }
                }
            } else {
                Class superclass = (type = this.getNonPrimitiveType(type)).getSuperclass();
                if (superclass != null) {
                    this.superclasses.add(superclass);
                    this.superclasses.addAll(ClassUtil.getTypeInfo(superclass).superclasses);
                }
            }
            if (this.dimension == 0) {
                Class<?>[] typeInterfaces = type.getInterfaces();
                ArrayList<Class> set = new ArrayList<Class>();
                for (int i = 0; i < typeInterfaces.length; ++i) {
                    Class typeInterface = typeInterfaces[i];
                    set.add(typeInterface);
                    set.addAll(ClassUtil.getTypeInfo(typeInterface).interfaces);
                }
                for (Class typeInterface : this.superclasses) {
                    set.addAll(ClassUtil.getTypeInfo((Class)typeInterface).interfaces);
                }
                for (Class interfaceClass : set) {
                    if (this.interfaces.contains(interfaceClass)) continue;
                    this.interfaces.add(interfaceClass);
                }
            } else {
                for (Class componentInterface : ClassUtil.getTypeInfo((Class)componentType).interfaces) {
                    this.interfaces.add(ClassUtil.getArrayClass(componentInterface, this.dimension));
                }
            }
        }

        private Class getNonPrimitiveType(Class type) {
            if (type.isPrimitive()) {
                if (Integer.TYPE.equals(type)) {
                    type = Integer.class;
                } else if (Long.TYPE.equals(type)) {
                    type = Long.class;
                } else if (Short.TYPE.equals(type)) {
                    type = Short.class;
                } else if (Byte.TYPE.equals(type)) {
                    type = Byte.class;
                } else if (Float.TYPE.equals(type)) {
                    type = Float.class;
                } else if (Double.TYPE.equals(type)) {
                    type = Double.class;
                } else if (Boolean.TYPE.equals(type)) {
                    type = Boolean.class;
                } else if (Character.TYPE.equals(type)) {
                    type = Character.class;
                }
            }
            return type;
        }

        public Class getType() {
            return this.type;
        }

        public Class getArrayComponentType() {
            return this.componentType;
        }

        public int getArrayDimension() {
            return this.dimension;
        }

        public List getSuperclasses() {
            return Collections.unmodifiableList(this.superclasses);
        }

        public List getInterfaces() {
            return Collections.unmodifiableList(this.interfaces);
        }
    }
}

