/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.util;

import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.domain.CreateMessage;
import com.alibaba.tmq.common.domain.DeleteMessage;
import com.alibaba.tmq.common.domain.KeyValuePair;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.MessageStatus;
import com.alibaba.tmq.common.domain.MessageType;
import com.alibaba.tmq.common.domain.UpdateMessage;
import com.alibaba.tmq.common.domain.result.Result;
import com.alibaba.tmq.common.domain.result.ResultCode;
import com.alibaba.tmq.common.exception.TMQException;
import com.alibaba.tmq.common.proxy.ProxyService;
import com.alibaba.tmq.common.util.CronExpressionUtil;
import com.alibaba.tmq.common.util.IdAndKeyUtil;
import com.alibaba.tmq.common.util.TimeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class MessageUtil {
    public static final ProxyService proxyService = new ProxyService();

    public static Result<Boolean> checkMessage(MessageUtil messageUtil, List<? extends Message> messageList) {
        if (null == messageList || messageList.size() <= 0) {
            throw new RuntimeException(ResultCode.MESSAGE_LIST_EMPTY_ERROR.getInformation());
        }
        Message firstMessage = messageList.get(0);
        String messageKey = firstMessage.getMessageKey();
        String topic = firstMessage.getTopic();
        for (Message message : messageList) {
            if (!firstMessage.getClass().getSimpleName().equals(message.getClass().getSimpleName())) {
                throw new RuntimeException(ResultCode.MESSAGE_CLASS_NOT_ALL_THE_SAME_ERROR.getInformation());
            }
            if (!MessageUtil.isCompleteArguments(message)) {
                throw new RuntimeException(ResultCode.MESSAGE_ARGUMENTS_ERROR.getInformation());
            }
            if (StringUtil.isBlank(message.getMessageKey())) {
                throw new RuntimeException(ResultCode.MESSAGE_KEY_NULL_ERROR.getInformation());
            }
            if (!message.getMessageKey().equals(messageKey)) {
                throw new RuntimeException(ResultCode.MESSAGE_KEY_NOT_ALL_THE_SAME_ERROR.getInformation());
            }
            Result<Boolean> checkResult = MessageUtil.checkMessage(messageUtil, message);
            if (!message.getTopic().equals(topic)) {
                throw new RuntimeException(ResultCode.MESSAGE_TOPIC_NOT_ALL_THE_SAME_ERROR.getInformation());
            }
            if (checkResult.getData().booleanValue()) continue;
            return checkResult;
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public static boolean fireTimeOut(Date fireTime) {
        Date timeLine = TimeUtil.increaseDate(new Date(), 1, 3);
        return !fireTime.before(timeLine);
    }

    public static boolean isCompleteArguments(Message message) {
        return (null != message.getFireTime() || !StringUtil.isBlank(message.getCronExpression())) && !StringUtil.isBlank(message.getTopic()) && null != message.getBody();
    }

    public static Result<Boolean> checkMessage(MessageUtil messageUtil, Message message) {
        if (null == message) {
            throw new RuntimeException(ResultCode.MESSAGE_NULL_ERROR.getInformation());
        }
        if (!(message instanceof CreateMessage || message instanceof UpdateMessage || message instanceof DeleteMessage)) {
            throw new RuntimeException(ResultCode.MESSAGE_CLASS_ERROR.getInformation());
        }
        Map<String, KeyValuePair<Class<?>[], Object[]>> argumentsTable = message.getArgumentsTable();
        for (Map.Entry<String, KeyValuePair<Class<?>[], Object[]>> entry : argumentsTable.entrySet()) {
            KeyValuePair<Class<?>[], Object[]> pair;
            String field = entry.getKey();
            Result result = (Result)proxyService.invokeMethod(messageUtil, field, (pair = entry.getValue()).getKey(), pair.getValue());
            if (((Boolean)result.getData()).booleanValue()) continue;
            throw new RuntimeException(result.getResultCode().getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public Result<Boolean> messageKey(String messageKey) {
        if (StringUtil.isBlank(messageKey)) {
            throw new RuntimeException(ResultCode.MESSAGE_KEY_NULL_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public Result<Boolean> topic(String topic) {
        if (StringUtil.isBlank(topic)) {
            throw new RuntimeException(ResultCode.MESSAGE_TOPIC_NULL_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public Result<Boolean> unitRoute(String unitRoute) {
        if (StringUtil.isBlank(unitRoute)) {
            throw new RuntimeException(ResultCode.MESSAGE_UNIT_ROUTE_NULL_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public Result<Boolean> tag(String tag) {
        if (StringUtil.isBlank(tag)) {
            throw new RuntimeException(ResultCode.MESSAGE_TAG_NULL_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public Result<Boolean> fireTime(Date fireTime) {
        if (null == fireTime) {
            throw new RuntimeException(ResultCode.MESSAGE_FIRE_TIME_NULL_ERROR.getInformation());
        }
        if (MessageUtil.fireTimeOut(fireTime)) {
            throw new RuntimeException(ResultCode.MESSAGE_FIRE_TIME_ERROR.getInformation() + ", fireTime:" + TimeUtil.date2SecondsString(fireTime));
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public Result<Boolean> body(byte[] body) {
        if (null == body || body.length <= 0) {
            throw new RuntimeException(ResultCode.MESSAGE_BODY_NULL_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public Result<Boolean> cronExpression(Message message, String cronExpression) {
        if (StringUtil.isBlank(cronExpression)) {
            throw new RuntimeException(ResultCode.MESSAGE_CRON_EXPRESSION_NULL_ERROR.getInformation());
        }
        if (!CronExpressionUtil.isValidExpression(cronExpression)) {
            throw new RuntimeException(ResultCode.MESSAGE_CRON_EXPRESSION_INVALID_ERROR.getInformation());
        }
        Date fireTime = CronExpressionUtil.getNextValidTime(cronExpression, new Date());
        if (null == fireTime) {
            throw new RuntimeException(ResultCode.MESSAGE_CRON_EXPRESSION_OBSOLETE_ERROR.getInformation());
        }
        message.setFireTime(fireTime);
        if (MessageUtil.fireTimeOut(fireTime)) {
            throw new RuntimeException(ResultCode.MESSAGE_FIRE_TIME_ERROR.getInformation() + ", fireTime:" + TimeUtil.date2SecondsString(fireTime));
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public Result<Boolean> startTime(Date startTime) {
        if (null == startTime) {
            throw new RuntimeException(ResultCode.MESSAGE_START_TIME_NULL_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public Result<Boolean> totalExeCount(long totalExeCount) {
        if (totalExeCount < 0L) {
            throw new RuntimeException(ResultCode.MESSAGE_TOTAL_EXE_COUNT_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public Result<Boolean> endTime(Date endTime) {
        if (null == endTime) {
            throw new RuntimeException(ResultCode.MESSAGE_END_TIME_NULL_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public Result<Boolean> checkStartTimeAndEndTime(Date startTime, Date endTime) {
        this.startTime(startTime);
        this.endTime(endTime);
        if (startTime.after(endTime)) {
            throw new RuntimeException(ResultCode.MESSAGE_START_TIME_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public static Result<Boolean> check4Send(Message message) {
        if (null == message) {
            throw new RuntimeException(ResultCode.MESSAGE_NULL_ERROR.getInformation());
        }
        if (message instanceof CreateMessage || message instanceof UpdateMessage || message instanceof DeleteMessage) {
            throw new RuntimeException(ResultCode.MESSAGE_OLD_CLASS_ERROR.getInformation());
        }
        if (null == message.getFireTime() && StringUtil.isBlank(message.getCronExpression())) {
            throw new RuntimeException(ResultCode.MESSAGE_TIME_BOTH_NULL_ERROR.getInformation());
        }
        if (message.getFireTime() != null && MessageUtil.fireTimeOut(message.getFireTime())) {
            throw new RuntimeException(ResultCode.MESSAGE_FIRE_TIME_ERROR.getInformation() + ", fireTime:" + TimeUtil.date2SecondsString(message.getFireTime()));
        }
        if (StringUtil.isNotBlank(message.getCronExpression())) {
            if (!CronExpressionUtil.isValidExpression(message.getCronExpression())) {
                throw new RuntimeException(ResultCode.MESSAGE_CRON_EXPRESSION_INVALID_ERROR.getInformation());
            }
            Date fireTime = CronExpressionUtil.getNextValidTime(message.getCronExpression(), new Date());
            if (null == fireTime) {
                throw new RuntimeException(ResultCode.MESSAGE_CRON_EXPRESSION_OBSOLETE_ERROR.getInformation());
            }
            message.setFireTime(fireTime);
        }
        if (StringUtil.isBlank(message.getTopic())) {
            throw new RuntimeException(ResultCode.MESSAGE_TOPIC_NULL_ERROR.getInformation());
        }
        if (null == message.getBody() || message.getBody().length <= 0) {
            throw new RuntimeException(ResultCode.MESSAGE_BODY_NULL_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public static Result<Boolean> check4Send(List<Message> messageList) {
        if (null == messageList || messageList.size() <= 0) {
            throw new RuntimeException(ResultCode.MESSAGE_LIST_EMPTY_ERROR.getInformation());
        }
        String messageKey = messageList.get(0).getMessageKey();
        String topic = messageList.get(0).getTopic();
        for (Message message : messageList) {
            if (StringUtil.isBlank(message.getMessageKey())) {
                throw new RuntimeException(ResultCode.MESSAGE_KEY_NULL_ERROR.getInformation());
            }
            if (!message.getMessageKey().equals(messageKey)) {
                throw new RuntimeException(ResultCode.MESSAGE_KEY_NOT_ALL_THE_SAME_ERROR.getInformation());
            }
            Result<Boolean> checkResult = MessageUtil.check4Send(message);
            if (!message.getTopic().equals(topic)) {
                throw new RuntimeException(ResultCode.MESSAGE_TOPIC_NOT_ALL_THE_SAME_ERROR.getInformation());
            }
            if (!checkResult.getData().booleanValue()) {
                return checkResult;
            }
            if (EagleEye.getUserData("t") == null || !EagleEye.getUserData("t").equals("1")) continue;
            message.setTb_eagleeyex_t("1");
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public static KeyValuePair<String, Message> rendering(String producerId, Message message, MessageStatus status, MessageType messageType) throws TMQException {
        String messageId = IdAndKeyUtil.acquireUniqueId();
        String messageKey = IdAndKeyUtil.acquireUniqueKey(messageId, message);
        if (StringUtil.isNotBlank(producerId)) {
            message.setProducerId(producerId);
        }
        if (status != null && !(message instanceof DeleteMessage)) {
            message.setStatus(status.getStatus());
        }
        if (message instanceof CreateMessage || message instanceof UpdateMessage) {
            message.setMessageId(messageId);
        }
        message.setMessageKey(messageKey);
        if (messageType != null) {
            message.setType(messageType.getType());
        }
        return new KeyValuePair<String, Message>(messageId, message);
    }

    public static List<KeyValuePair<String, Message>> rendering(String producerId, List<? extends Message> messageList, MessageStatus status, MessageType messageType) throws TMQException {
        ArrayList<KeyValuePair<String, Message>> messageKeyValueList = new ArrayList<KeyValuePair<String, Message>>();
        for (Message message : messageList) {
            messageKeyValueList.add(MessageUtil.rendering(producerId, message, status, messageType));
        }
        return messageKeyValueList;
    }

    public static KeyValuePair<String, Message> renderingMessage(String producerId, Message message, MessageStatus status, MessageType messageType) throws TMQException {
        String messageId = IdAndKeyUtil.acquireUniqueId();
        String messageKey = IdAndKeyUtil.acquireUniqueKey(messageId, message);
        if (StringUtil.isNotBlank(producerId)) {
            message.setProducerId(producerId);
        }
        if (status != null) {
            message.setStatus(status.getStatus());
        }
        message.setMessageId(messageId);
        message.setMessageKey(messageKey);
        if (messageType != null) {
            message.setType(messageType.getType());
        }
        return new KeyValuePair<String, Message>(messageId, message);
    }

    public static List<KeyValuePair<String, Message>> renderingMessage(String producerId, List<Message> messageList, MessageStatus status, MessageType messageType) throws TMQException {
        ArrayList<KeyValuePair<String, Message>> messageKeyValueList = new ArrayList<KeyValuePair<String, Message>>();
        for (Message message : messageList) {
            messageKeyValueList.add(MessageUtil.renderingMessage(producerId, message, status, messageType));
        }
        return messageKeyValueList;
    }

    public static void setMessageStatus(Message message, MessageStatus status) {
        message.setStatus(status.getStatus());
    }

    public static void setMessageStatus(List<Message> messageList, MessageStatus status) {
        for (Message message : messageList) {
            MessageUtil.setMessageStatus(message, status);
        }
    }

    public static Result<Boolean> check4Get(Message message) {
        if (null == message) {
            throw new RuntimeException(ResultCode.MESSAGE_NULL_ERROR.getInformation());
        }
        if (message instanceof CreateMessage || message instanceof UpdateMessage || message instanceof DeleteMessage) {
            throw new RuntimeException(ResultCode.MESSAGE_OLD_CLASS_ERROR.getInformation());
        }
        if (StringUtil.isBlank(message.getTopic())) {
            throw new RuntimeException(ResultCode.MESSAGE_TOPIC_NULL_ERROR.getInformation());
        }
        if (StringUtil.isBlank(message.getMessageKey())) {
            throw new RuntimeException(ResultCode.MESSAGE_KEY_NULL_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public static Result<Boolean> check4Update(Message message) {
        if (null == message) {
            throw new RuntimeException(ResultCode.MESSAGE_NULL_ERROR.getInformation());
        }
        if (message instanceof CreateMessage || message instanceof UpdateMessage || message instanceof DeleteMessage) {
            throw new RuntimeException(ResultCode.MESSAGE_OLD_CLASS_ERROR.getInformation());
        }
        if (StringUtil.isBlank(message.getMessageId()) && StringUtil.isBlank(message.getMessageKey())) {
            throw new RuntimeException(ResultCode.MESSAGE_ID_AND_KEY_NULL_ERROR.getInformation());
        }
        if (StringUtil.isBlank(message.getTopic())) {
            throw new RuntimeException(ResultCode.MESSAGE_TOPIC_NULL_ERROR.getInformation());
        }
        if (message.getFireTime() != null && MessageUtil.fireTimeOut(message.getFireTime())) {
            throw new RuntimeException(ResultCode.MESSAGE_FIRE_TIME_ERROR.getInformation() + ", fireTime:" + TimeUtil.date2SecondsString(message.getFireTime()));
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public static Result<Boolean> check4UpdateSingle(Message message) {
        if (null == message) {
            throw new RuntimeException(ResultCode.MESSAGE_NULL_ERROR.getInformation());
        }
        if (message instanceof CreateMessage || message instanceof UpdateMessage || message instanceof DeleteMessage) {
            throw new RuntimeException(ResultCode.MESSAGE_OLD_CLASS_ERROR.getInformation());
        }
        if (StringUtil.isBlank(message.getMessageId()) && StringUtil.isBlank(message.getMessageKey())) {
            throw new RuntimeException(ResultCode.MESSAGE_ID_AND_KEY_NULL_ERROR.getInformation());
        }
        if (null == message.getFireTime() && (null == message.getBody() || message.getBody().length <= 0)) {
            throw new RuntimeException(ResultCode.MESSAGE_FIRE_TIME_AND_BODY_NULL_ERROR.getInformation());
        }
        if (message.getFireTime() != null && MessageUtil.fireTimeOut(message.getFireTime())) {
            throw new RuntimeException(ResultCode.MESSAGE_FIRE_TIME_ERROR.getInformation() + ", fireTime:" + TimeUtil.date2SecondsString(message.getFireTime()));
        }
        if (StringUtil.isBlank(message.getTopic())) {
            throw new RuntimeException(ResultCode.MESSAGE_TOPIC_NULL_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public static Result<Boolean> check4Update(List<Message> messageList) {
        if (null == messageList || messageList.size() <= 0) {
            throw new RuntimeException(ResultCode.MESSAGE_LIST_EMPTY_ERROR.getInformation());
        }
        String messageKey = messageList.get(0).getMessageKey();
        String topic = messageList.get(0).getTopic();
        for (Message message : messageList) {
            if (StringUtil.isBlank(message.getMessageKey())) {
                throw new RuntimeException(ResultCode.MESSAGE_KEY_NULL_ERROR.getInformation());
            }
            if (!message.getMessageKey().equals(messageKey)) {
                throw new RuntimeException(ResultCode.MESSAGE_KEY_NOT_ALL_THE_SAME_ERROR.getInformation());
            }
            Result<Boolean> checkResult = MessageUtil.check4Update(message);
            if (!message.getTopic().equals(topic)) {
                throw new RuntimeException(ResultCode.MESSAGE_TOPIC_NOT_ALL_THE_SAME_ERROR.getInformation());
            }
            if (checkResult.getData().booleanValue()) continue;
            return checkResult;
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public static Result<Boolean> check4Delete(Message message) {
        if (null == message) {
            throw new RuntimeException(ResultCode.MESSAGE_NULL_ERROR.getInformation());
        }
        if (message instanceof CreateMessage || message instanceof UpdateMessage || message instanceof DeleteMessage) {
            throw new RuntimeException(ResultCode.MESSAGE_OLD_CLASS_ERROR.getInformation());
        }
        if (StringUtil.isBlank(message.getMessageId()) && StringUtil.isBlank(message.getMessageKey())) {
            throw new RuntimeException(ResultCode.MESSAGE_ID_AND_KEY_NULL_ERROR.getInformation());
        }
        if (StringUtil.isBlank(message.getTopic())) {
            throw new RuntimeException(ResultCode.MESSAGE_TOPIC_NULL_ERROR.getInformation());
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public static Result<Boolean> check4Delete(List<Message> messageList) {
        if (null == messageList || messageList.size() <= 0) {
            throw new RuntimeException(ResultCode.MESSAGE_LIST_EMPTY_ERROR.getInformation());
        }
        String messageKey = messageList.get(0).getMessageKey();
        for (Message message : messageList) {
            if (StringUtil.isBlank(message.getMessageKey())) {
                throw new RuntimeException(ResultCode.MESSAGE_KEY_NULL_ERROR.getInformation());
            }
            if (!message.getMessageKey().equals(messageKey)) {
                throw new RuntimeException(ResultCode.MESSAGE_KEY_NOT_ALL_THE_SAME_ERROR.getInformation());
            }
            Result<Boolean> checkResult = MessageUtil.check4Delete(message);
            if (checkResult.getData().booleanValue()) continue;
            return checkResult;
        }
        return new Result<Boolean>(true, ResultCode.SUCCESS);
    }

    public static void reset(Message message, int clusterId) {
        if (null == message) {
            throw new RuntimeException("message is null");
        }
        message.setRetryConsumers(null);
        message.setRetryCount(0);
        message.setClusterId(clusterId);
    }

    public static void reset(List<? extends Message> messageList, int clusterId) {
        if (null == messageList || messageList.size() <= 0) {
            throw new RuntimeException("messageList is empty");
        }
        for (Message message : messageList) {
            MessageUtil.reset(message, clusterId);
        }
    }

    public static void date2Seconds(List<Message> messageList) {
        if (null == messageList || messageList.size() <= 0) {
            throw new RuntimeException("messageList is empty");
        }
        for (Message message : messageList) {
            MessageUtil.date2Seconds(message);
        }
    }

    public static void date2Seconds(Message message) {
        if (null == message.getFireTime()) {
            return;
        }
        message.setFireTime(TimeUtil.date2Seconds(message.getFireTime()));
    }

    public static Message retryClone(Message message) {
        if (null == message) {
            return null;
        }
        Message retryMessage = new Message();
        retryMessage.setId(0L);
        retryMessage.setGmtCreate(null);
        retryMessage.setGmtModified(null);
        retryMessage.setMessageId(IdAndKeyUtil.acquireUniqueId());
        retryMessage.setFireTime(new Date());
        retryMessage.setProducerId(message.getProducerId());
        retryMessage.setTopic(message.getTopic());
        retryMessage.setTag(message.getTag());
        retryMessage.setBody(message.getBody());
        retryMessage.setRetryConsumers(null);
        retryMessage.setStatus(MessageStatus.RETRY.getStatus());
        retryMessage.setRetryCount(0);
        retryMessage.setMessageKey(message.getMessageKey());
        retryMessage.setType(MessageType.NORMAL_CRON_RETRY.getType());
        retryMessage.setClusterId(message.getClusterId());
        retryMessage.setUnitRoute(message.getUnitRoute());
        retryMessage.setCronExpression(null);
        retryMessage.setStartTime(null);
        retryMessage.setTotalExeCount(0L);
        retryMessage.setCurrentExeCount(message.getCurrentExeCount());
        retryMessage.setEndTime(null);
        retryMessage.setFireTimeMinute(null);
        return retryMessage;
    }
}

