/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.util;

import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.util.TimeUtil;
import java.util.Date;

public class PathUtil
implements Constants {
    public static int HOUR_MIN = 2;
    public static int HOUR_MAX = 24;
    public static int DAY_MIN = 2;
    public static int DAY_MAX = 31;
    public static int MONTH_MIN = 2;
    public static int MONTH_MAX = 12;
    public static int YEAR_MIN = 2;
    public static int YEAR_MAX = 3;

    public static String getLoggerPath() {
        String separator = System.getProperty("file.separator");
        return System.getProperties().getProperty("user.home") + separator + "logs";
    }

    public static String getHomeConfigPath(String fileName) {
        String separator = System.getProperty("file.separator");
        return System.getProperties().getProperty("user.home") + separator + "tmq-config" + separator + fileName;
    }

    public static String getMasterNewRegionPath() {
        return HOME_PATH + SEPARATOR + "tmq-data" + SEPARATOR + "master-data" + SEPARATOR + "new-region" + SEPARATOR;
    }

    public static String getMasterNewRegionFilePath(String fileName) {
        return HOME_PATH + SEPARATOR + "tmq-data" + SEPARATOR + "master-data" + SEPARATOR + "new-region" + SEPARATOR + fileName + ".tmq";
    }

    public static String getMasterActiveRegionPath() {
        return HOME_PATH + SEPARATOR + "tmq-data" + SEPARATOR + "master-data" + SEPARATOR + "active-region" + SEPARATOR;
    }

    public static String getMasterActiveRegionFilePath(String fileName) {
        return HOME_PATH + SEPARATOR + "tmq-data" + SEPARATOR + "master-data" + SEPARATOR + "active-region" + SEPARATOR + fileName + ".tmq";
    }

    public static String getMasterOldRegionPath() {
        return HOME_PATH + SEPARATOR + "tmq-data" + SEPARATOR + "master-data" + SEPARATOR + "old-region" + SEPARATOR;
    }

    public static String getMasterOldRegionFilePath(String fileName) {
        return HOME_PATH + SEPARATOR + "tmq-data" + SEPARATOR + "master-data" + SEPARATOR + "old-region" + SEPARATOR + fileName + ".tmq";
    }

    public static String getMasterCompressionRegionPath() {
        return HOME_PATH + SEPARATOR + "tmq-data" + SEPARATOR + "master-data" + SEPARATOR + "compression-region" + SEPARATOR;
    }

    public static String getMasterCompressionRegionFilePath(String fileName) {
        return HOME_PATH + SEPARATOR + "tmq-data" + SEPARATOR + "master-data" + SEPARATOR + "compression-region" + SEPARATOR + fileName + ".tmq";
    }

    public static String getMasterCompressionRegionBucketPath(String bucket) {
        return PathUtil.getMasterCompressionRegionPath() + bucket;
    }

    public static String getCompressionHourLevelPath(int hour) {
        if (hour < HOUR_MIN || hour > HOUR_MAX) {
            return null;
        }
        return PathUtil.getMasterCompressionRegionPath() + "hour-" + hour;
    }

    public static String getCompressionDayLevelPath(int day) {
        if (day < DAY_MIN || day > DAY_MAX) {
            return null;
        }
        return PathUtil.getMasterCompressionRegionPath() + "day-" + day;
    }

    public static String getCompressionMonthLevelPath(int month) {
        if (month < MONTH_MIN || month > MONTH_MAX) {
            return null;
        }
        return PathUtil.getMasterCompressionRegionPath() + "month-" + month;
    }

    public static String getCompressionYearLevelPath(int year) {
        if (year < YEAR_MIN || year > YEAR_MAX) {
            return null;
        }
        return PathUtil.getMasterCompressionRegionPath() + "year-" + year;
    }

    public static String getCompressionTargetLevelPath(String timePeriod) {
        Date date = TimeUtil.string2Date(timePeriod, "yyyy-MM-dd HH:mm");
        int year = date.getYear();
        int month = date.getMonth();
        int day = date.getDay();
        int hours = date.getHours();
        int minutes = date.getMinutes();
        Date dateNow = new Date();
        int yearNow = dateNow.getYear();
        int monthNow = dateNow.getMonth();
        int dayNow = dateNow.getDay();
        int hoursNow = dateNow.getHours();
        int minutesNow = dateNow.getMinutes();
        if (year - yearNow > 0) {
            return PathUtil.getCompressionYearLevelPath(year - yearNow);
        }
        if (month - monthNow > 0) {
            return PathUtil.getCompressionMonthLevelPath(month - monthNow);
        }
        if (day - dayNow > 0) {
            return PathUtil.getCompressionDayLevelPath(day - dayNow);
        }
        if (hours - hoursNow > 0) {
            return PathUtil.getCompressionHourLevelPath(hours - hoursNow);
        }
        return null;
    }

    public static String getServerClusterPath(long serverClusterId) {
        return "/zk-tmq-root/server-cluster/" + serverClusterId;
    }

    public static String getServerPath(long serverClusterId, String server) {
        return "/zk-tmq-root/server-cluster/" + serverClusterId + "/" + server;
    }

    public static String getConsolePath() {
        return "/zk-tmq-root/console-cluster";
    }

    public static String getConsoleServerPath(String server) {
        return "/zk-tmq-root/console-cluster/" + server;
    }
}

