/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.standalone;

import com.taobao.hsf.standalone.HSFMiniContainer;
import com.taobao.hsf.standalone.sar.HSFSarUtil;
import com.taobao.hsf.standalone.util.Constant;
import com.taobao.hsf.standalone.util.IOUtil;
import java.io.File;

public class HSFEasyStarter {
    public static String DEFAULT_LIGHTAPI_HOME = System.getProperty("user.home") + "/lightapi";
    public static String DEFAULT_RELEASE_PATH = DEFAULT_LIGHTAPI_HOME + "/release";

    @Deprecated
    public static void start() {
        HSFEasyStarter.startFromPath(DEFAULT_RELEASE_PATH);
    }

    private static void start(String releasePath, String version) {
        if (releasePath == null || version == null) {
            throw new IllegalArgumentException("releasePath or version can't be null");
        }
        if (releasePath.trim().length() == 0) {
            releasePath = DEFAULT_RELEASE_PATH;
        }
        String sarBasePath = IOUtil.buildDirPath(releasePath, version);
        String sarPath = null;
        try {
            sarPath = HSFSarUtil.prepareHSFSar(sarBasePath, version);
            HSFMiniContainer.start(sarPath);
        }
        catch (Exception e) {
            throw new RuntimeException("HSFMiniContainer.start(sarPath) fail, please check your sar under path: " + sarPath, e);
        }
    }

    public static void startFromPath(String releasePath) {
        HSFEasyStarter.start(releasePath, "");
    }

    public static void startWithPathAndIdentifier(String path, String identifier) {
        HSFEasyStarter.multiProcess(DEFAULT_LIGHTAPI_HOME, identifier);
        HSFEasyStarter.startFromPath(path);
    }

    private static void multiProcess(String standaloneHome, String identifier) {
        String osgiDir = standaloneHome + "/osgidir/" + identifier;
        String logsDir = standaloneHome + "/logs/" + identifier;
        String pandoraDir = standaloneHome + "/pandora/" + identifier;
        System.setProperty("hsf.configuration.dir", osgiDir);
        System.setProperty("HSF.LOG.PATH", logsDir);
        System.setProperty("com.taobao.pandora.tmp_path", pandoraDir);
        System.setProperty("pandora.qos.port", "0");
        Runtime.getRuntime().addShutdownHook(new TmpDirCleaner(osgiDir, pandoraDir));
    }

    public static void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("version cannot be null");
        }
        Constant.version.set(version);
    }

    private static class TmpDirCleaner
    extends Thread {
        private String osgiDirPath;
        private String pandoraDirPath;

        public TmpDirCleaner(String osgiDirPath, String pandoraDirPath) {
            this.osgiDirPath = osgiDirPath;
            this.pandoraDirPath = pandoraDirPath;
        }

        @Override
        public void run() {
            IOUtil.deleteDir(new File(this.osgiDirPath));
            IOUtil.deleteDir(new File(this.pandoraDirPath));
        }
    }
}

