/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client.impl;

import com.alibaba.rocketmq.client.QueryResult;
import com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.common.TopicConfig;
import com.alibaba.rocketmq.common.help.FAQUrl;
import com.alibaba.rocketmq.common.message.MessageClientIDSetter;
import com.alibaba.rocketmq.common.message.MessageDecoder;
import com.alibaba.rocketmq.common.message.MessageExt;
import com.alibaba.rocketmq.common.message.MessageId;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.common.protocol.header.QueryMessageRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.QueryMessageResponseHeader;
import com.alibaba.rocketmq.common.protocol.route.BrokerData;
import com.alibaba.rocketmq.common.protocol.route.TopicRouteData;
import com.alibaba.rocketmq.remoting.InvokeCallback;
import com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.alibaba.rocketmq.remoting.exception.RemotingException;
import com.alibaba.rocketmq.remoting.netty.ResponseFuture;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class MQAdminImpl {
    private final Logger log = ClientLogger.getLog();
    private final MQClientInstance mQClientFactory;
    private long timeoutMillis = 6000L;

    public MQAdminImpl(MQClientInstance mQClientFactory) {
        this.mQClientFactory = mQClientFactory;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void createTopic(String key, String newTopic, int queueNum) throws MQClientException {
        this.createTopic(key, newTopic, queueNum, 0);
    }

    public void createTopic(String key, String newTopic, int queueNum, int topicSysFlag) throws MQClientException {
        block8: {
            try {
                TopicRouteData topicRouteData = this.mQClientFactory.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(key, this.timeoutMillis);
                List brokerDataList = topicRouteData.getBrokerDatas();
                if (brokerDataList != null && !brokerDataList.isEmpty()) {
                    Collections.sort(brokerDataList);
                    boolean createOKAtLeastOnce = false;
                    MQClientException exception = null;
                    StringBuilder orderTopicString = new StringBuilder();
                    for (BrokerData brokerData : brokerDataList) {
                        String addr = (String)brokerData.getBrokerAddrs().get(0L);
                        if (addr == null) continue;
                        TopicConfig topicConfig = new TopicConfig(newTopic);
                        topicConfig.setReadQueueNums(queueNum);
                        topicConfig.setWriteQueueNums(queueNum);
                        topicConfig.setTopicSysFlag(topicSysFlag);
                        boolean createOK = false;
                        for (int i = 0; i < 5; ++i) {
                            try {
                                this.mQClientFactory.getMQClientAPIImpl().createTopic(addr, key, topicConfig, this.timeoutMillis);
                                createOK = true;
                                createOKAtLeastOnce = true;
                                break;
                            }
                            catch (Exception e) {
                                if (4 != i) continue;
                                exception = new MQClientException("create topic to broker exception", e);
                                continue;
                            }
                        }
                        if (!createOK) continue;
                        orderTopicString.append(brokerData.getBrokerName());
                        orderTopicString.append(":");
                        orderTopicString.append(queueNum);
                        orderTopicString.append(";");
                    }
                    if (exception != null && !createOKAtLeastOnce) {
                        throw exception;
                    }
                    break block8;
                }
                throw new MQClientException("Not found broker, maybe key is wrong", null);
            }
            catch (Exception e) {
                throw new MQClientException("create new topic failed", e);
            }
        }
    }

    public List<MessageQueue> fetchPublishMessageQueues(String topic) throws MQClientException {
        try {
            TopicPublishInfo topicPublishInfo;
            TopicRouteData topicRouteData = this.mQClientFactory.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(topic, this.timeoutMillis);
            if (topicRouteData != null && (topicPublishInfo = MQClientInstance.topicRouteData2TopicPublishInfo(topic, topicRouteData)) != null && topicPublishInfo.ok()) {
                return topicPublishInfo.getMessageQueueList();
            }
        }
        catch (Exception e) {
            throw new MQClientException("Can not find Message Queue for this topic, " + topic, e);
        }
        throw new MQClientException("Unknow why, Can not find Message Queue for this topic, " + topic, null);
    }

    public Set<MessageQueue> fetchSubscribeMessageQueues(String topic) throws MQClientException {
        try {
            TopicRouteData topicRouteData = this.mQClientFactory.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(topic, this.timeoutMillis);
            if (topicRouteData != null) {
                Set<MessageQueue> mqList = MQClientInstance.topicRouteData2TopicSubscribeInfo(topic, topicRouteData);
                if (!mqList.isEmpty()) {
                    return mqList;
                }
                throw new MQClientException("Can not find Message Queue for this topic, " + topic + " Namesrv return empty", null);
            }
        }
        catch (Exception e) {
            throw new MQClientException("Can not find Message Queue for this topic, " + topic + FAQUrl.suggestTodo((String)"http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&queue_not_exist"), e);
        }
        throw new MQClientException("Unknow why, Can not find Message Queue for this topic, " + topic, null);
    }

    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().searchOffset(brokerAddr, mq.getTopic(), mq.getQueueId(), timestamp, this.timeoutMillis);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public long maxOffset(MessageQueue mq) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().getMaxOffset(brokerAddr, mq.getTopic(), mq.getQueueId(), this.timeoutMillis);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public long minOffset(MessageQueue mq) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().getMinOffset(brokerAddr, mq.getTopic(), mq.getQueueId(), this.timeoutMillis);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        if (null == brokerAddr) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        }
        if (brokerAddr != null) {
            try {
                return this.mQClientFactory.getMQClientAPIImpl().getEarliestMsgStoretime(brokerAddr, mq.getTopic(), mq.getQueueId(), this.timeoutMillis);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", e);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    public MessageExt viewMessage(String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        MessageId messageId = null;
        try {
            messageId = MessageDecoder.decodeMessageId((String)msgId);
        }
        catch (Exception e) {
            throw new MQClientException(208, "query message by id finished, but no message.");
        }
        return this.mQClientFactory.getMQClientAPIImpl().viewMessage(RemotingUtil.socketAddress2String((SocketAddress)messageId.getAddress()), messageId.getOffset(), this.timeoutMillis);
    }

    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        return this.queryMessage(topic, key, maxNum, begin, end, false);
    }

    public MessageExt queryMessageByUniqKey(String topic, String uniqKey) throws InterruptedException, MQClientException {
        QueryResult qr = this.queryMessage(topic, uniqKey, 32, MessageClientIDSetter.getNearlyTimeFromID((String)uniqKey).getTime() - 1000L, Long.MAX_VALUE, true);
        if (qr != null && qr.getMessageList() != null && qr.getMessageList().size() > 0) {
            return qr.getMessageList().get(0);
        }
        return null;
    }

    protected QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end, boolean isUniqKey) throws MQClientException, InterruptedException {
        TopicRouteData topicRouteData = this.mQClientFactory.getAnExistTopicRouteData(topic);
        if (null == topicRouteData) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(topic);
            topicRouteData = this.mQClientFactory.getAnExistTopicRouteData(topic);
        }
        if (topicRouteData != null) {
            LinkedList<String> brokerAddrs = new LinkedList<String>();
            for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
                String addr = brokerData.selectBrokerAddr();
                if (addr == null) continue;
                brokerAddrs.add(addr);
            }
            if (!brokerAddrs.isEmpty()) {
                final CountDownLatch countDownLatch = new CountDownLatch(brokerAddrs.size());
                final LinkedList queryResultList = new LinkedList();
                for (String addr : brokerAddrs) {
                    try {
                        QueryMessageRequestHeader requestHeader = new QueryMessageRequestHeader();
                        requestHeader.setTopic(topic);
                        requestHeader.setKey(key);
                        requestHeader.setMaxNum(Integer.valueOf(maxNum));
                        requestHeader.setBeginTimestamp(Long.valueOf(begin));
                        requestHeader.setEndTimestamp(Long.valueOf(end));
                        this.mQClientFactory.getMQClientAPIImpl().queryMessage(addr, requestHeader, this.timeoutMillis * 3L, new InvokeCallback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void operationComplete(ResponseFuture responseFuture) {
                                block10: {
                                    try {
                                        RemotingCommand response = responseFuture.getResponseCommand();
                                        if (response != null) {
                                            switch (response.getCode()) {
                                                case 0: {
                                                    QueryMessageResponseHeader responseHeader = null;
                                                    try {
                                                        responseHeader = (QueryMessageResponseHeader)response.decodeCommandCustomHeader(QueryMessageResponseHeader.class);
                                                    }
                                                    catch (RemotingCommandException e) {
                                                        MQAdminImpl.this.log.error("decodeCommandCustomHeader exception", (Throwable)e);
                                                        countDownLatch.countDown();
                                                        return;
                                                    }
                                                    List wrappers = MessageDecoder.decodes((ByteBuffer)ByteBuffer.wrap(response.getBody()), (boolean)true);
                                                    QueryResult qr = new QueryResult(responseHeader.getIndexLastUpdateTimestamp(), wrappers);
                                                    queryResultList.add(qr);
                                                    break;
                                                }
                                                default: {
                                                    MQAdminImpl.this.log.warn("getResponseCommand failed, {} {}", (Object)response.getCode(), (Object)response.getRemark());
                                                    break;
                                                }
                                            }
                                            break block10;
                                        }
                                        MQAdminImpl.this.log.warn("getResponseCommand return null");
                                    }
                                    finally {
                                        countDownLatch.countDown();
                                    }
                                }
                            }
                        }, isUniqKey);
                    }
                    catch (Exception e) {
                        this.log.warn("queryMessage exception", (Throwable)e);
                    }
                }
                boolean ok = countDownLatch.await(this.timeoutMillis * 4L, TimeUnit.MILLISECONDS);
                if (!ok) {
                    this.log.warn("queryMessage, maybe some broker failed");
                }
                long indexLastUpdateTimestamp = 0L;
                LinkedList<MessageExt> messageList = new LinkedList<MessageExt>();
                for (QueryResult qr : queryResultList) {
                    if (qr.getIndexLastUpdateTimestamp() > indexLastUpdateTimestamp) {
                        indexLastUpdateTimestamp = qr.getIndexLastUpdateTimestamp();
                    }
                    for (MessageExt msgExt : qr.getMessageList()) {
                        if (isUniqKey) {
                            if (msgExt.getMsgId().equals(key)) {
                                if (messageList.size() > 0) {
                                    if (((MessageExt)messageList.get(0)).getStoreTimestamp() <= msgExt.getStoreTimestamp()) continue;
                                    messageList.clear();
                                    messageList.add(msgExt);
                                    continue;
                                }
                                messageList.add(msgExt);
                                continue;
                            }
                            this.log.warn("queryMessage by uniqKey, find message key not matched, maybe hash duplicate {}", (Object)msgExt.toString());
                            continue;
                        }
                        String keys = msgExt.getKeys();
                        if (keys == null) continue;
                        boolean matched = false;
                        String[] keyArray = keys.split(" ");
                        if (keyArray != null) {
                            for (String k : keyArray) {
                                if (!key.equals(k)) continue;
                                matched = true;
                                break;
                            }
                        }
                        if (matched) {
                            messageList.add(msgExt);
                            continue;
                        }
                        this.log.warn("queryMessage, find message key not matched, maybe hash duplicate {}", (Object)msgExt.toString());
                    }
                }
                if (!messageList.isEmpty()) {
                    return new QueryResult(indexLastUpdateTimestamp, messageList);
                }
                throw new MQClientException(208, "query message by key finished, but no message.");
            }
        }
        throw new MQClientException(17, "The topic[" + topic + "] not matched route info");
    }
}

