/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.DataSerializable;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.system.Configuration;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Dictionary;

public class SubTransactionCoordinatorParticipant
implements Participant,
DataSerializable {
    private static final long serialVersionUID = -321213151844934630L;
    private transient Participant subordinateCoordinator;
    private String subordinateId;
    private HeuristicMessage[] msgs;
    private boolean prepareCalled;

    public SubTransactionCoordinatorParticipant(CoordinatorImp subordinateCoordinator) {
        this.subordinateCoordinator = subordinateCoordinator;
        this.subordinateId = subordinateCoordinator.getCoordinatorId();
        this.msgs = subordinateCoordinator.getHeuristicMessages();
        this.prepareCalled = false;
    }

    public boolean recover() throws SysException {
        TransactionService ts = Configuration.getTransactionService();
        this.subordinateCoordinator = ts.getParticipant(this.subordinateId);
        return this.subordinateCoordinator != null;
    }

    public String getURI() {
        return this.subordinateId;
    }

    public void setCascadeList(Dictionary allParticipants) throws SysException {
        this.subordinateCoordinator.setCascadeList(allParticipants);
    }

    public void setGlobalSiblingCount(int count) {
        this.subordinateCoordinator.setGlobalSiblingCount(count);
    }

    public int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        this.prepareCalled = true;
        return this.subordinateCoordinator.prepare();
    }

    public HeuristicMessage[] commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        HeuristicMessage[] ret = this.getHeuristicMessages();
        if (this.subordinateCoordinator == null) {
            if (this.prepareCalled) {
                throw new HeurHazardException(ret);
            }
            throw new RollbackException();
        }
        this.subordinateCoordinator.commit(onePhase);
        return ret;
    }

    public HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        HeuristicMessage[] ret = this.getHeuristicMessages();
        if (this.subordinateCoordinator != null) {
            this.subordinateCoordinator.rollback();
        } else if (this.prepareCalled) {
            throw new HeurHazardException(ret);
        }
        return ret;
    }

    public void forget() {
        if (this.subordinateCoordinator != null) {
            this.subordinateCoordinator.forget();
        }
    }

    public HeuristicMessage[] getHeuristicMessages() {
        if (this.subordinateCoordinator != null) {
            this.msgs = this.subordinateCoordinator.getHeuristicMessages();
        }
        return this.msgs;
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.subordinateId);
        out.writeInt(this.msgs.length);
        for (int i = 0; i < this.msgs.length; ++i) {
            out.writeUTF(this.msgs[i].toString());
        }
        out.writeBoolean(this.prepareCalled);
    }

    public void readData(DataInput in) throws IOException {
        this.subordinateId = in.readUTF();
        int size = in.readInt();
        this.msgs = new HeuristicMessage[size];
        for (int i = 0; i < this.msgs.length; ++i) {
            this.msgs[i] = new StringHeuristicMessage(in.readUTF());
        }
        this.prepareCalled = in.readBoolean();
    }
}

