/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class CollectionUtils {
    private static final int MAX_POWER_OF_TWO = 0x40000000;
    private static boolean isJdk8;

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtils.isEmpty(map);
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(CollectionUtils.capacity(expectedSize));
    }

    public static <K, V> V computeIfAbsent(Map<K, V> concurrentHashMap, K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        if (isJdk8) {
            V v = concurrentHashMap.get(key);
            if (null == v) {
                v = mappingFunction.apply(key);
                if (null == v) {
                    return null;
                }
                V res = concurrentHashMap.putIfAbsent(key, v);
                if (null != res) {
                    return res;
                }
            }
            return v;
        }
        return concurrentHashMap.computeIfAbsent(key, mappingFunction);
    }

    private static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            if (expectedSize < 0) {
                throw new IllegalArgumentException("expectedSize cannot be negative but was: " + expectedSize);
            }
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> List<V> getCollection(Map<K, V> map, Iterable<K> keys) {
        ArrayList result = new ArrayList();
        if (map != null && !map.isEmpty() && keys != null) {
            keys.forEach(key -> Optional.ofNullable(map.get(key)).ifPresent(result::add));
        }
        return result;
    }

    public static <K, V> List<V> getCollection(Map<K, V> map, Iterable<K> keys, Comparator<V> comparator) {
        Objects.requireNonNull(comparator);
        List<V> result = CollectionUtils.getCollection(map, keys);
        Collections.sort(result, comparator);
        return result;
    }

    static {
        try {
            isJdk8 = System.getProperty("java.version").startsWith("1.8.");
        }
        catch (Exception ignore) {
            isJdk8 = true;
        }
    }
}

