/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt;

public class LingerUDT
extends Number
implements Comparable<LingerUDT> {
    public static final LingerUDT LINGER_ZERO = new LingerUDT(0);
    final int timeout;
    private static final long serialVersionUID = 3414455799823407217L;

    public LingerUDT(int lingerSeconds) throws IllegalArgumentException {
        if (65535 < lingerSeconds) {
            throw new IllegalArgumentException("lingerSeconds is out of range: 0 <= linger <= 65535");
        }
        this.timeout = lingerSeconds > 0 ? lingerSeconds : 0;
    }

    @Override
    public double doubleValue() {
        return this.timeout;
    }

    @Override
    public float floatValue() {
        return this.timeout;
    }

    @Override
    public int intValue() {
        return this.timeout;
    }

    @Override
    public long longValue() {
        return this.timeout;
    }

    boolean isLingerOn() {
        return this.timeout > 0;
    }

    int timeout() {
        return this.timeout;
    }

    public boolean equals(Object otherLinger) {
        if (otherLinger instanceof LingerUDT) {
            LingerUDT other = (LingerUDT)otherLinger;
            return other.timeout == this.timeout;
        }
        return false;
    }

    public int hashCode() {
        return this.timeout;
    }

    @Override
    public int compareTo(LingerUDT other) {
        return other.timeout - this.timeout;
    }

    public String toString() {
        return String.valueOf(this.timeout);
    }
}

