/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository;

import com.bstek.urule.RuleException;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.DataSourceConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.RepositoryConfigurationParser;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.SecurityManagerConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreFactory;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.state.DefaultISMLocking;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ISMLockingFactory;
import org.apache.jackrabbit.core.util.CooperativeFileLock;
import org.apache.jackrabbit.core.util.RepositoryLockMechanism;
import org.apache.jackrabbit.core.util.RepositoryLockMechanismFactory;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RepositoryBuilder
implements InitializingBean,
ApplicationContextAware {
    private String repoHomeDir;
    private Element workspaceTemplate;
    private RepositoryImpl repository;
    private String repositoryXml;
    private ApplicationContext applicationContext;
    private String repositoryDatasourceName;
    public static String databaseType;
    public static DataSource datasource;
    private Logger log = Logger.getLogger(RepositoryBuilder.class.getName());

    public RepositoryImpl getRepository() {
        return this.repository;
    }

    private SecurityConfig buildSecurityConfig() {
        SecurityConfig securityConfig = new SecurityConfig("uruleRepoSecurity", this.buildSecurityManagerConfig(), this.buildAccessManagerConfig(), this.buildLoginModuleConfig());
        return securityConfig;
    }

    private RepositoryLockMechanismFactory buildRepositoryLockMechanismFactory() {
        return new RepositoryLockMechanismFactory(){

            public RepositoryLockMechanism getRepositoryLockMechanism() throws RepositoryException {
                return new CooperativeFileLock();
            }
        };
    }

    private FileSystemFactory buildFileSystemFactory(final String dirName) {
        return new FileSystemFactory(){

            public FileSystem getFileSystem() throws RepositoryException {
                try {
                    LocalFileSystem fs = new LocalFileSystem();
                    fs.setPath("" + RepositoryBuilder.this.repoHomeDir + "/" + dirName);
                    fs.init();
                    return fs;
                }
                catch (FileSystemException e) {
                    throw new RepositoryException("File system initialization failure.", (Throwable)e);
                }
            }
        };
    }

    private DataStoreFactory buildDataStoreFactory() {
        return new DataStoreFactory(){

            public DataStore getDataStore() throws RepositoryException {
                FileDataStore datastore = new FileDataStore();
                datastore.setPath("" + RepositoryBuilder.this.repoHomeDir + "/repository/datastore");
                datastore.setMinRecordLength(100);
                return null;
            }
        };
    }

    private VersioningConfig buildVersioningConfig() {
        String homeDir = "" + this.repoHomeDir + "/version";
        FileSystemFactory fileSystemFactory = this.buildFileSystemFactory("version");
        PersistenceManagerConfig persistenceManagerConfig = this.buildPersistenceManagerConfig();
        ISMLockingFactory ismLockingFactory = this.buildISMLockingFactory();
        VersioningConfig versioningConfig = new VersioningConfig(homeDir, fileSystemFactory, persistenceManagerConfig, ismLockingFactory);
        return versioningConfig;
    }

    private ISMLockingFactory buildISMLockingFactory() {
        return new ISMLockingFactory(){

            public ISMLocking getISMLocking() throws RepositoryException {
                return new DefaultISMLocking();
            }
        };
    }

    private PersistenceManagerConfig buildPersistenceManagerConfig() {
        Properties prop = new Properties();
        BeanConfig beanConfig = new BeanConfig("org.apache.jackrabbit.core.persistence.bundle.BundleFsPersistenceManager", prop);
        PersistenceManagerConfig persistenceManagerConfig = new PersistenceManagerConfig(beanConfig);
        return persistenceManagerConfig;
    }

    private SecurityManagerConfig buildSecurityManagerConfig() {
        Properties prop = new Properties();
        BeanConfig beanConfig = new BeanConfig("org.apache.jackrabbit.core.security.simple.SimpleSecurityManager", prop);
        SecurityManagerConfig securityManagerConfig = new SecurityManagerConfig(beanConfig, "default", null);
        return securityManagerConfig;
    }

    private AccessManagerConfig buildAccessManagerConfig() {
        Properties prop = new Properties();
        BeanConfig beanConfig = new BeanConfig("org.apache.jackrabbit.core.security.simple.SimpleAccessManager", prop);
        AccessManagerConfig accessManagerConfig = new AccessManagerConfig(beanConfig);
        return accessManagerConfig;
    }

    private LoginModuleConfig buildLoginModuleConfig() {
        Properties prop = new Properties();
        prop.put("anonymousId", "anonymous");
        prop.put("adminId", "admin");
        BeanConfig beanConfig = new BeanConfig("org.apache.jackrabbit.core.security.simple.SimpleLoginModule", prop);
        LoginModuleConfig loginModuleConfig = new LoginModuleConfig(beanConfig);
        return loginModuleConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepositoryByXml(String xml) throws Exception {
        this.log.info("Build repository from user custom xml file...");
        try (InputStream inputStream = null;){
            inputStream = this.applicationContext.getResource(xml).getInputStream();
            String tempRepoHomeDir = System.getProperty("java.io.tmpdir");
            if (StringUtils.isNotBlank((String)tempRepoHomeDir) && tempRepoHomeDir.length() > 1) {
                tempRepoHomeDir = tempRepoHomeDir.endsWith("/") || tempRepoHomeDir.endsWith("\\") ? tempRepoHomeDir + "urule-temp-repo-home/" : tempRepoHomeDir + "/urule-temp-repo-home/";
                File tempDir = new File(tempRepoHomeDir);
                this.clearTempDir(tempDir);
            } else {
                tempRepoHomeDir = "";
            }
            RepositoryConfig repositoryConfig = RepositoryConfig.create((InputStream)inputStream, (String)tempRepoHomeDir);
            this.repository = RepositoryImpl.create((RepositoryConfig)repositoryConfig);
        }
    }

    private void clearTempDir(File file) {
        if (file.isDirectory()) {
            for (File childFile : file.listFiles()) {
                this.clearTempDir(childFile);
            }
        }
        file.delete();
    }

    private void initDefaultRepository() throws Exception {
        SecurityConfig securityConfig = this.buildSecurityConfig();
        FileSystemFactory fileSystemFactory = this.buildFileSystemFactory("repository");
        String workspaceDirectory = "" + this.repoHomeDir + "/workspaces";
        String workspaceConfigDirectory = null;
        String defaultWorkspace = "default";
        int workspaceMaxIdleTime = 0;
        VersioningConfig versioningConfig = this.buildVersioningConfig();
        QueryHandlerFactory queryHandlerFactory = null;
        ClusterConfig clusterConfig = null;
        DataStoreFactory dataStoreFactory = this.buildDataStoreFactory();
        RepositoryLockMechanismFactory repositoryLockMechanismFactory = this.buildRepositoryLockMechanismFactory();
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        ConnectionFactory connectionFactory = new ConnectionFactory();
        RepositoryConfigurationParser repositoryConfigurationParser = new RepositoryConfigurationParser(new Properties());
        this.initWorkspaceTemplate();
        RepositoryConfig repositoryConfig = new RepositoryConfig(this.repoHomeDir, securityConfig, fileSystemFactory, workspaceDirectory, workspaceConfigDirectory, defaultWorkspace, workspaceMaxIdleTime, this.workspaceTemplate, versioningConfig, queryHandlerFactory, clusterConfig, dataStoreFactory, repositoryLockMechanismFactory, dataSourceConfig, connectionFactory, repositoryConfigurationParser);
        repositoryConfig.init();
        this.repository = RepositoryImpl.create((RepositoryConfig)repositoryConfig);
    }

    private void initWorkspaceTemplate() {
        InputStream inputStream = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            inputStream = this.applicationContext.getResource("classpath:com/bstek/urule/console/repository/workspace_template.xml").getInputStream();
            Document doc = builder.parse(inputStream);
            this.workspaceTemplate = doc.getDocumentElement();
        }
        catch (Exception e) {
            try {
                throw new RuleException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void initRepositoryDir(ApplicationContext applicationContext) {
        if (applicationContext instanceof WebApplicationContext) {
            WebApplicationContext context = (WebApplicationContext)applicationContext;
            ServletContext servletContext = context.getServletContext();
            File file = new File(this.repoHomeDir);
            if (!file.exists()) {
                this.repoHomeDir = servletContext.getRealPath(this.repoHomeDir);
            }
            if (!(file = new File(this.repoHomeDir)).exists()) {
                throw new RuleException("Repository root dir " + this.repoHomeDir + " is not exist.");
            }
        } else {
            this.log.info("Current is not a standard web container,so can't resolve real path for repo home dir.");
        }
        this.log.info("Use \"" + this.repoHomeDir + "\" as urule repository home directory.");
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotBlank((String)this.repositoryDatasourceName)) {
            datasource = (DataSource)this.applicationContext.getBean(this.repositoryDatasourceName);
        }
        if (StringUtils.isNotBlank((String)this.repoHomeDir) && !this.repoHomeDir.equals("${urule.repository.dir}")) {
            this.initRepositoryDir(this.applicationContext);
        }
        if (StringUtils.isNotBlank((String)this.repositoryXml)) {
            this.initRepositoryByXml(this.repositoryXml);
        } else if (datasource != null) {
            if (databaseType == null) {
                throw new RuleException("You need config \"urule.repository.databasetype\" property when use spring datasource!");
            }
            this.initRepositoryFromSpringDatasource();
        } else {
            if (StringUtils.isBlank((String)this.repoHomeDir)) {
                throw new RuleException("You need config \"urule.repository.dir\" property for set repository home dir.");
            }
            this.initDefaultRepository();
        }
    }

    private void initRepositoryFromSpringDatasource() throws Exception {
        System.out.println("Init repository from spring datasource [" + this.repositoryDatasourceName + "] with database type [" + databaseType + "]...");
        String xml = "classpath:com/bstek/urule/console/repository/database/configs/" + databaseType + ".xml";
        this.initRepositoryByXml(xml);
    }

    public void setRepoHomeDir(String repoHomeDir) {
        this.repoHomeDir = repoHomeDir;
    }

    public void setRepositoryXml(String repositoryXml) {
        this.repositoryXml = repositoryXml;
    }

    public void setDatabaseType(String databaseType) {
        RepositoryBuilder.databaseType = databaseType;
    }

    public void setRepositoryDatasourceName(String repositoryDatasourceName) {
        this.repositoryDatasourceName = repositoryDatasourceName;
    }

    public void destroy() {
        System.out.println("Shutdown repository...");
        this.repository.shutdown();
        System.out.println("Shutdown repository completed...");
    }
}

