/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.database;

import com.bstek.urule.console.repository.RepositoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.db.DbDataStore;

public class DatabaseDataStore
extends DbDataStore {
    public synchronized void init(String homeDir) throws DataStoreException {
        try {
            this.initDatabaseType();
            this.conHelper = this.createConnectionHelper(RepositoryBuilder.datasource);
            if (this.isSchemaCheckEnabled()) {
                this.createCheckSchemaOperation().run();
            }
        }
        catch (Exception e) {
            throw this.convert("Can not init data store, driver=" + this.driver + " url=" + this.url + " user=" + this.user + " schemaObjectPrefix=" + this.schemaObjectPrefix + " tableSQL=" + this.tableSQL + " createTableSQL=" + this.createTableSQL, e);
        }
    }

    protected void initDatabaseType() throws DataStoreException {
        this.databaseType = RepositoryBuilder.databaseType;
        InputStream in = DbDataStore.class.getResourceAsStream(this.databaseType + ".properties");
        if (in == null) {
            String msg = "Configuration error: The resource '" + this.databaseType + ".properties' could not be found;" + " Please verify the databaseType property";
            throw new DataStoreException(msg);
        }
        Properties prop = new Properties();
        try {
            try {
                prop.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            String msg = "Configuration error: Could not read properties '" + this.databaseType + ".properties'";
            throw new DataStoreException(msg, (Throwable)e);
        }
        if (this.driver == null) {
            this.driver = this.getProperty(prop, "driver", this.driver);
        }
        this.tableSQL = this.getProperty(prop, "table", this.tableSQL);
        this.createTableSQL = this.getProperty(prop, "createTable", this.createTableSQL);
        this.insertTempSQL = this.getProperty(prop, "insertTemp", this.insertTempSQL);
        this.updateDataSQL = this.getProperty(prop, "updateData", this.updateDataSQL);
        this.updateLastModifiedSQL = this.getProperty(prop, "updateLastModified", this.updateLastModifiedSQL);
        this.updateSQL = this.getProperty(prop, "update", this.updateSQL);
        this.deleteSQL = this.getProperty(prop, "delete", this.deleteSQL);
        this.deleteOlderSQL = this.getProperty(prop, "deleteOlder", this.deleteOlderSQL);
        this.selectMetaSQL = this.getProperty(prop, "selectMeta", this.selectMetaSQL);
        this.selectAllSQL = this.getProperty(prop, "selectAll", this.selectAllSQL);
        this.selectDataSQL = this.getProperty(prop, "selectData", this.selectDataSQL);
        this.storeStream = this.getProperty(prop, "storeStream", this.storeStream);
        if (!("-1".equals(this.storeStream) || "tempFile".equals(this.storeStream) || "max".equals(this.storeStream))) {
            String msg = "Unsupported Stream store mechanism: " + this.storeStream + " supported are: " + "-1" + ", " + "tempFile" + ", " + "max";
            throw new DataStoreException(msg);
        }
    }
}

