/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.model;

import com.bstek.urule.console.repository.model.LibType;
import com.bstek.urule.console.repository.model.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonIgnore;

public class RepositoryFile {
    private String id = UUID.randomUUID().toString();
    private String name;
    private String fullPath;
    private Type type;
    private Type folderType;
    private boolean lock;
    private String lockInfo;
    @JsonIgnore
    private LibType libType;
    @JsonIgnore
    private RepositoryFile parentFile;
    private List<RepositoryFile> children;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RepositoryFile getParentFile() {
        return this.parentFile;
    }

    public void setParentFile(RepositoryFile parentFile) {
        this.parentFile = parentFile;
    }

    public LibType getLibType() {
        return this.libType;
    }

    public void setLibType(LibType libType) {
        this.libType = libType;
    }

    public List<RepositoryFile> getChildren() {
        return this.children;
    }

    public void addChild(RepositoryFile fileInfo, boolean isdir) {
        if (this.children == null) {
            this.children = new ArrayList<RepositoryFile>();
        }
        fileInfo.setParentFile(this);
        if (isdir) {
            this.children.add(0, fileInfo);
        } else {
            this.children.add(fileInfo);
        }
    }

    public void setChildren(List<RepositoryFile> children) {
        this.children = children;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.parentFile != null ? this.parentFile.getFullPath() : "";
            if (this.fullPath.equals("/")) {
                this.fullPath = "";
            }
            this.fullPath = this.fullPath + "/" + this.name;
        }
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getFolderType() {
        return this.folderType;
    }

    public void setFolderType(Type folderType) {
        this.folderType = folderType;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public String getLockInfo() {
        return this.lockInfo;
    }

    public void setLockInfo(String lockInfo) {
        this.lockInfo = lockInfo;
    }
}

