/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.updater;

import com.bstek.urule.RuleException;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.repository.updater.AbstractReferenceUpdater;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FlowDefinitionReferenceUpdater
extends AbstractReferenceUpdater {
    @Override
    public boolean contain(String path, String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Element element = doc.getRootElement();
            for (Object obj : element.elements()) {
                String filePath;
                if (!(obj instanceof Element)) continue;
                Element ele = (Element)obj;
                String name = ele.getName();
                boolean match = false;
                if (name.equals("import-variable-library")) {
                    match = true;
                } else if (name.equals("import-constant-library")) {
                    match = true;
                } else if (name.equals("import-action-library")) {
                    match = true;
                } else if (name.equals("import-parameter-library")) {
                    match = true;
                }
                if (!match || !(filePath = ele.attributeValue("path")).endsWith(path)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    @Override
    public String update(String oldPath, String newPath, String xml) {
        try {
            boolean modify = false;
            Document doc = DocumentHelper.parseText((String)xml);
            Element element = doc.getRootElement();
            for (Object obj : element.elements()) {
                String path;
                if (!(obj instanceof Element)) continue;
                Element ele = (Element)obj;
                String name = ele.getName();
                boolean match = false;
                if (name.equals("import-variable-library")) {
                    match = true;
                } else if (name.equals("import-constant-library")) {
                    match = true;
                } else if (name.equals("import-action-library")) {
                    match = true;
                } else if (name.equals("import-parameter-library")) {
                    match = true;
                }
                if (!match || !(path = ele.attributeValue("path")).endsWith(oldPath)) continue;
                ele.addAttribute("path", newPath);
                modify = true;
            }
            if (modify) {
                return this.xmlToString(doc);
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    @Override
    public boolean support(String path) {
        return path.endsWith(FileType.RuleFlow.toString());
    }
}

