/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.diagram;

import com.bstek.urule.console.servlet.diagram.Box;
import com.bstek.urule.console.servlet.diagram.NodeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReteNodeLayout {
    private final int leftMargin = 50;
    private final int topMargin = 50;
    private final int nodeWidth = 30;
    private final int nodeHeight = 30;

    public Box layout(NodeInfo rootNode) {
        List<NodeInfo> children = rootNode.getChildren();
        if (children == null) {
            return null;
        }
        HashMap<Integer, Integer> levelXPositionMap = new HashMap<Integer, Integer>();
        HashMap<Integer, List<NodeInfo>> nodeLevelMap = new HashMap<Integer, List<NodeInfo>>();
        this.buildNodesLevelMap(children, nodeLevelMap);
        int maxSize = this.buildMaxSize(nodeLevelMap) - 1;
        int maxWidth = maxSize * 30 + maxSize * 50;
        int x = maxWidth / 2 + 50 + 30;
        rootNode.setX(x);
        rootNode.setY(5);
        this.buildChildrenNodeLocation(children, rootNode, nodeLevelMap, levelXPositionMap);
        Box box = new Box();
        box.setWidth(maxWidth + 100 + 30);
        int maxHeight = nodeLevelMap.size() * 30 * 3 + 100;
        box.setHeight(maxHeight);
        return box;
    }

    private void buildChildrenNodeLocation(List<NodeInfo> nodes, NodeInfo rootNode, Map<Integer, List<NodeInfo>> nodeLevelMap, Map<Integer, Integer> levelXPositionMap) {
        for (int i = 0; i < nodes.size(); ++i) {
            NodeInfo node = nodes.get(i);
            int level = node.getLevel();
            node.setY(level * 50 + level * 30);
            List<NodeInfo> children = node.getChildren();
            int xposition = 0;
            if (levelXPositionMap.containsKey(level)) {
                xposition = levelXPositionMap.get(level);
            }
            int rootX = rootNode.getX();
            int levelSize = nodeLevelMap.get(level).size();
            if (xposition == 0) {
                if (levelSize > 1) {
                    int levelWidth = levelSize * 30 + levelSize * 50;
                    xposition = rootX - levelWidth / 2 - 50;
                } else {
                    xposition = rootX;
                }
            }
            int x = 80 + xposition;
            if (levelSize == 1) {
                x = xposition;
            }
            node.setX(x);
            levelXPositionMap.put(level, x);
            if (children == null) continue;
            this.buildChildrenNodeLocation(children, rootNode, nodeLevelMap, levelXPositionMap);
        }
    }

    private int buildMaxSize(Map<Integer, List<NodeInfo>> nodeLevelMap) {
        int maxSize = 1;
        for (List<NodeInfo> list : nodeLevelMap.values()) {
            if (list.size() <= maxSize) continue;
            maxSize = list.size();
        }
        return maxSize;
    }

    private void buildNodesLevelMap(List<NodeInfo> nodes, Map<Integer, List<NodeInfo>> nodeLevelMap) {
        for (NodeInfo node : nodes) {
            List<Object> levelNodes;
            int level = node.getLevel();
            if (nodeLevelMap.containsKey(level)) {
                levelNodes = nodeLevelMap.get(level);
                levelNodes.add(node);
            } else {
                levelNodes = new ArrayList<NodeInfo>();
                levelNodes.add(node);
                nodeLevelMap.put(level, levelNodes);
            }
            List<NodeInfo> children = node.getChildren();
            if (children == null) continue;
            this.buildNodesLevelMap(children, nodeLevelMap);
        }
    }
}

