/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.flow;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.ResourcePackage;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.flow.FlowDefinitionWrapper;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.flow.ProcessDefinition;
import com.bstek.urule.parse.deserializer.FlowDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RuleFlowDesignerServletHandler
extends RenderPageServletHandler {
    private RepositoryService repositoryService;
    private FlowDeserializer flowDeserializer;

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)req.getContextPath());
            String file = req.getParameter("file");
            String project = this.buildProjectNameFromFile(file);
            if (project != null) {
                context.put("project", (Object)project);
            }
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/rule-flow-designer.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    public void loadFlowDefinition(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String file = req.getParameter("file");
        String version = req.getParameter("version");
        file = Utils.decodeURL((String)file);
        InputStream inputStream = StringUtils.isEmpty((String)version) ? this.repositoryService.readFile(file, null) : this.repositoryService.readFile(file, version);
        Element root = this.parseXml(inputStream);
        FlowDefinition fd = this.flowDeserializer.deserialize(root, true);
        inputStream.close();
        this.writeObjectToJson(resp, new FlowDefinitionWrapper((ProcessDefinition)fd));
    }

    protected Element parseXml(InputStream stream) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(stream);
            Element root = document.getRootElement();
            return root;
        }
        catch (DocumentException e) {
            throw new RuleException((Exception)((Object)e));
        }
    }

    public void loadPackages(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String project = req.getParameter("project");
        try {
            List<ResourcePackage> packages = this.repositoryService.loadProjectResourcePackages(project);
            this.writeObjectToJson(resp, packages);
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setFlowDeserializer(FlowDeserializer flowDeserializer) {
        this.flowDeserializer = flowDeserializer;
    }

    @Override
    public String url() {
        return "/ruleflowdesigner";
    }
}

