/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.permission;

import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.User;
import com.bstek.urule.console.exception.NoPermissionException;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.RepositoryFile;
import com.bstek.urule.console.repository.permission.PermissionService;
import com.bstek.urule.console.repository.permission.PermissionStore;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import com.bstek.urule.console.servlet.permission.ProjectConfig;
import com.bstek.urule.console.servlet.permission.UserPermission;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class PermissionConfigServletHandler
extends RenderPageServletHandler {
    private RepositoryService repositoryService;
    private PermissionStore permissionStore;

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!((PermissionService)((Object)this.permissionStore)).isAdmin()) {
            throw new NoPermissionException();
        }
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)req.getContextPath());
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/permission-config-editor.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    public void loadResourceSecurityConfigs(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String companyId = EnvironmentUtils.getLoginUser(new RequestContext(req, resp)).getCompanyId();
        List<UserPermission> permissions = this.repositoryService.loadResourceSecurityConfigs(companyId);
        List<User> users = EnvironmentUtils.getEnvironmentProvider().getUsers();
        if (users == null) {
            users = new ArrayList<User>();
        }
        ArrayList<UserPermission> result = new ArrayList<UserPermission>();
        for (User user : users) {
            if (user.isAdmin() || companyId != null && (user.getCompanyId() == null || !user.getCompanyId().equals(companyId))) continue;
            boolean exist = false;
            for (UserPermission p : permissions) {
                if (!p.getUsername().equals(user.getUsername())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            UserPermission up = new UserPermission();
            up.setProjectConfigs(new ArrayList<ProjectConfig>());
            up.setUsername(user.getUsername());
            result.add(up);
        }
        result.addAll(permissions);
        List<RepositoryFile> projects = this.repositoryService.loadProject(companyId);
        for (UserPermission p : result) {
            this.buildProjectConfigs(projects, p);
        }
        this.writeObjectToJson(resp, result);
    }

    private void buildProjectConfigs(List<RepositoryFile> projects, UserPermission p) {
        List<ProjectConfig> configs = p.getProjectConfigs();
        if (configs == null) {
            configs = new ArrayList<ProjectConfig>();
            p.setProjectConfigs(configs);
        }
        for (RepositoryFile project : projects) {
            boolean exist = false;
            for (ProjectConfig c : p.getProjectConfigs()) {
                if (!project.getName().equals(c.getProject())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            ProjectConfig config = new ProjectConfig();
            config.setProject(project.getName());
            configs.add(config);
        }
    }

    public void saveResourceSecurityConfigs(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        User user = EnvironmentUtils.getLoginUser(new RequestContext(req, resp));
        String companyId = user.getCompanyId();
        String content = req.getParameter("content");
        String path = "___resource_security_config__file__" + (companyId == null ? "" : companyId);
        this.repositoryService.saveFile(path, content, user, false, null);
        this.permissionStore.refreshPermissionStore();
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setPermissionStore(PermissionStore permissionStore) {
        this.permissionStore = permissionStore;
    }

    @Override
    public String url() {
        return "/permission";
    }
}

