/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.respackage;

import com.bstek.urule.console.servlet.respackage.SessionObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HttpSessionKnowledgeCache {
    private Map<String, SessionObject> sessionMap = new HashMap<String, SessionObject>();

    public Object get(HttpServletRequest req, String key) {
        SessionObject sessionObject = this.getSessionObject(req);
        return sessionObject.get(key);
    }

    public void put(HttpServletRequest req, String key, Object obj) {
        SessionObject sessionObject = this.getSessionObject(req);
        sessionObject.put(key, obj);
    }

    public void remove(HttpServletRequest req, String key) {
        SessionObject sessionObject = this.getSessionObject(req);
        sessionObject.remove(key);
    }

    private SessionObject getSessionObject(HttpServletRequest req) {
        this.clean();
        String sessionId = req.getSession().getId();
        SessionObject sessionObject = null;
        if (this.sessionMap.containsKey(sessionId)) {
            sessionObject = this.sessionMap.get(sessionId);
        } else {
            sessionObject = new SessionObject();
            this.sessionMap.put(sessionId, sessionObject);
        }
        return sessionObject;
    }

    private void clean() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.sessionMap.keySet()) {
            SessionObject obj = this.sessionMap.get(key);
            if (!obj.isExpired()) continue;
            list.add(key);
        }
        for (String key : list) {
            this.sessionMap.remove(key);
        }
    }
}

