/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.ul;

import com.bstek.urule.Utils;
import com.bstek.urule.builder.ResourceLibraryBuilder;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.rule.RuleSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class ULEditorServletHandler
extends RenderPageServletHandler {
    private DSLRuleSetBuilder dslRuleSetBuilder;
    private ResourceLibraryBuilder resourceLibraryBuilder;
    private RepositoryService repositoryService;

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)req.getContextPath());
            String file = req.getParameter("file");
            String project = this.buildProjectNameFromFile(file);
            if (project != null) {
                context.put("project", (Object)project);
            }
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/ul-editor.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUL(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String file = req.getParameter("file");
        file = Utils.decodeURL((String)file);
        ServletOutputStream outputStream = resp.getOutputStream();
        String version = req.getParameter("version");
        InputStream inputStream = null;
        inputStream = StringUtils.isEmpty((String)version) ? this.repositoryService.readFile(file, null) : this.repositoryService.readFile(file, version);
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    public void loadULLibs(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String content = req.getParameter("content");
        RuleSet ruleSet = this.dslRuleSetBuilder.build(content);
        ResourceLibrary library = this.resourceLibraryBuilder.buildResourceLibrary((Collection)ruleSet.getLibraries());
        this.writeObjectToJson(resp, library);
    }

    public void setDslRuleSetBuilder(DSLRuleSetBuilder dslRuleSetBuilder) {
        this.dslRuleSetBuilder = dslRuleSetBuilder;
    }

    public void setResourceLibraryBuilder(ResourceLibraryBuilder resourceLibraryBuilder) {
        this.resourceLibraryBuilder = resourceLibraryBuilder;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public String url() {
        return "/uleditor";
    }
}

