/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.variable;

import com.bstek.urule.ClassUtils;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.variable.Act;
import com.bstek.urule.model.library.variable.Variable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class VariableEditorServletHandler
extends RenderPageServletHandler {
    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)req.getContextPath());
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/variable-editor.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    public void importXml(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletContext servletContext = req.getSession().getServletContext();
        File repository = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        factory.setRepository(repository);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        InputStream inputStream = null;
        try {
            List items = upload.parseRequest(req);
            if (items.size() != 1) {
                throw new ServletException("Upload xml file is invalid.");
            }
            FileItem item = (FileItem)items.get(0);
            inputStream = item.getInputStream();
            String xmlContent = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
            ArrayList<Variable> variables = new ArrayList<Variable>();
            Document doc = DocumentHelper.parseText((String)xmlContent);
            Element root = doc.getRootElement();
            String clazz = root.attributeValue("clazz");
            for (Object obj : root.elements()) {
                if (obj == null || !(obj instanceof Element)) continue;
                Element ele = (Element)obj;
                Variable var = new Variable();
                var.setAct(Act.InOut);
                var.setDefaultValue(ele.attributeValue("defaultValue"));
                var.setLabel(ele.attributeValue("label"));
                var.setName(ele.attributeValue("name"));
                var.setType(Datatype.valueOf((String)ele.attributeValue("type")));
                variables.add(var);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("clazz", clazz);
            result.put("variables", variables);
            this.writeObjectToJson(resp, result);
        }
        catch (Exception e) {
            try {
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void generateFields(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String clazz = req.getParameter("clazz");
        try {
            List variables = ClassUtils.classToVariables(Class.forName(clazz));
            this.writeObjectToJson(resp, variables);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public String url() {
        return "/variableeditor";
    }
}

