/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.network.api.utils;

import java.util.Arrays;
import shade.io.netty.buffer.ByteBuf;
import shade.io.netty.util.internal.MathUtil;
import shade.io.netty.util.internal.PlatformDependent;

public class NettyByteBufUtils {
    public static byte[] getBytes(ByteBuf buf) {
        return NettyByteBufUtils.getBytes(buf, buf.readerIndex(), buf.readableBytes(), true);
    }

    public static byte[] getBytes(ByteBuf buf, int start, int length, boolean copy) {
        int capacity = buf.capacity();
        if (MathUtil.isOutOfBounds(start, length, capacity)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= buf.capacity(" + capacity + ')');
        }
        if (buf.hasArray()) {
            int baseOffset = buf.arrayOffset() + start;
            byte[] bytes = buf.array();
            if (copy || baseOffset != 0 || length != bytes.length) {
                return Arrays.copyOfRange(bytes, baseOffset, baseOffset + length);
            }
            return bytes;
        }
        byte[] bytes = PlatformDependent.allocateUninitializedArray(length);
        buf.getBytes(start, bytes);
        return bytes;
    }
}

