/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.tagging.IPdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfMcrDictionary;
import com.itextpdf.kernel.pdf.tagging.PdfMcrNumber;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PdfStructElem
extends PdfObjectWrapper<PdfDictionary>
implements IPdfStructElem {
    private static final long serialVersionUID = 7204356181229674005L;
    public static int Unknown = 0;
    public static int Grouping = 1;
    public static int BlockLevel = 2;
    public static int InlineLevel = 3;
    public static int Illustration = 4;
    public static Set<PdfName> groupingRoles = new HashSet<PdfName>(){
        {
            this.add(PdfName.Document);
            this.add(PdfName.Part);
            this.add(PdfName.Art);
            this.add(PdfName.Sect);
            this.add(PdfName.Div);
            this.add(PdfName.BlockQuote);
            this.add(PdfName.Caption);
            this.add(PdfName.Caption);
            this.add(PdfName.TOC);
            this.add(PdfName.TOCI);
            this.add(PdfName.Index);
            this.add(PdfName.NonStruct);
            this.add(PdfName.Private);
        }
    };
    public static Set<PdfName> blockLevelRoles = new HashSet<PdfName>(){
        {
            this.add(PdfName.P);
            this.add(PdfName.H);
            this.add(PdfName.H1);
            this.add(PdfName.H2);
            this.add(PdfName.H3);
            this.add(PdfName.H4);
            this.add(PdfName.H5);
            this.add(PdfName.H6);
            this.add(PdfName.L);
            this.add(PdfName.Lbl);
            this.add(PdfName.LI);
            this.add(PdfName.LBody);
            this.add(PdfName.Table);
            this.add(PdfName.TR);
            this.add(PdfName.TH);
            this.add(PdfName.TD);
            this.add(PdfName.THead);
            this.add(PdfName.TBody);
            this.add(PdfName.TFoot);
        }
    };
    public static Set<PdfName> inlineLevelRoles = new HashSet<PdfName>(){
        {
            this.add(PdfName.Span);
            this.add(PdfName.Quote);
            this.add(PdfName.Note);
            this.add(PdfName.Reference);
            this.add(PdfName.BibEntry);
            this.add(PdfName.Code);
            this.add(PdfName.Link);
            this.add(PdfName.Annot);
            this.add(PdfName.Ruby);
            this.add(PdfName.Warichu);
            this.add(PdfName.RB);
            this.add(PdfName.RT);
            this.add(PdfName.RP);
            this.add(PdfName.WT);
            this.add(PdfName.WP);
        }
    };
    public static Set<PdfName> illustrationRoles = new HashSet<PdfName>(){
        {
            this.add(PdfName.Figure);
            this.add(PdfName.Formula);
            this.add(PdfName.Form);
        }
    };
    protected int type = Unknown;

    public PdfStructElem(PdfDictionary pdfObject) {
        super(pdfObject);
        PdfStructElem.ensureObjectIsAddedToDocument(pdfObject);
        this.setForbidRelease();
    }

    public PdfStructElem(PdfDocument document, PdfName role, PdfPage page) {
        this(document, role);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Pg, (PdfObject)page.getPdfObject());
    }

    public PdfStructElem(PdfDocument document, PdfName role, PdfAnnotation annot) {
        this(document, role);
        if (annot.getPage() == null) {
            throw new PdfException("annot.shall.have.reference.to.page");
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Pg, (PdfObject)annot.getPage().getPdfObject());
    }

    public PdfStructElem(PdfDocument document, PdfName role) {
        this(new PdfDictionary().makeIndirect(document));
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.StructElem);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.S, role);
    }

    public static boolean isStructElem(PdfDictionary dictionary) {
        return PdfName.StructElem.equals(dictionary.getAsName(PdfName.Type)) || dictionary.containsKey(PdfName.S);
    }

    public PdfObject getAttributes(boolean createNewIfNull) {
        PdfObject attributes = ((PdfDictionary)this.getPdfObject()).get(PdfName.A);
        if (attributes == null && createNewIfNull) {
            attributes = new PdfDictionary();
            this.setAttributes(attributes);
        }
        return attributes;
    }

    public void setAttributes(PdfObject attributes) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.A, attributes);
    }

    public PdfString getLang() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Lang);
    }

    public void setLang(PdfString lang) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Lang, lang);
    }

    public PdfString getAlt() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Alt);
    }

    public void setAlt(PdfString alt) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Alt, alt);
    }

    public PdfString getActualText() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.ActualText);
    }

    public void setActualText(PdfString actualText) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ActualText, actualText);
    }

    public PdfString getE() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.E);
    }

    public void setE(PdfString e) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.E, e);
    }

    @Override
    public PdfName getRole() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.S);
    }

    public void setRole(PdfName role) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.S, role);
    }

    public PdfStructElem addKid(PdfStructElem kid) {
        return this.addKid(-1, kid);
    }

    public PdfStructElem addKid(int index, PdfStructElem kid) {
        if (this.getType() == InlineLevel || this.getType() == Illustration) {
            throw new PdfException("inline.level.or.illustration.element.cannot.contain.kids", this.getPdfObject());
        }
        PdfStructElem.addKidObject((PdfDictionary)this.getPdfObject(), index, kid.getPdfObject());
        return kid;
    }

    public PdfMcr addKid(PdfMcr kid) {
        return this.addKid(-1, kid);
    }

    public PdfMcr addKid(int index, PdfMcr kid) {
        this.getDocument().getStructTreeRoot().getParentTreeHandler().registerMcr(kid);
        PdfStructElem.addKidObject((PdfDictionary)this.getPdfObject(), index, kid.getPdfObject());
        return kid;
    }

    public IPdfStructElem removeKid(int index) {
        PdfObject k = this.getK();
        if (k == null || !k.isArray() && index != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (k.isArray()) {
            PdfArray kidsArray = (PdfArray)k;
            k = kidsArray.get(index);
            kidsArray.remove(index);
            if (kidsArray.isEmpty()) {
                ((PdfDictionary)this.getPdfObject()).remove(PdfName.K);
            }
        } else {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.K);
        }
        IPdfStructElem removedKid = this.convertPdfObjectToIPdfStructElem(k);
        if (removedKid instanceof PdfMcr) {
            this.getDocument().getStructTreeRoot().getParentTreeHandler().unregisterMcr((PdfMcr)removedKid);
        }
        return removedKid;
    }

    public int removeKid(IPdfStructElem kid) {
        if (kid instanceof PdfMcr) {
            PdfMcr mcr = (PdfMcr)kid;
            this.getDocument().getStructTreeRoot().getParentTreeHandler().unregisterMcr(mcr);
            return this.removeKidObject((PdfObject)mcr.getPdfObject());
        }
        if (kid instanceof PdfStructElem) {
            return this.removeKidObject((PdfObject)((PdfStructElem)kid).getPdfObject());
        }
        return -1;
    }

    @Override
    public IPdfStructElem getParent() {
        PdfDictionary parent = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.P);
        if (parent == null || parent.isFlushed()) {
            return null;
        }
        if (PdfStructElem.isStructElem(parent)) {
            return new PdfStructElem(parent);
        }
        PdfName type = parent.getAsName(PdfName.Type);
        if (PdfName.StructTreeRoot.equals(type)) {
            return this.getDocument().getStructTreeRoot();
        }
        return null;
    }

    @Override
    public List<IPdfStructElem> getKids() {
        PdfObject k = this.getK();
        ArrayList<IPdfStructElem> kids = new ArrayList<IPdfStructElem>();
        if (k != null) {
            if (k.isArray()) {
                PdfArray a = (PdfArray)k;
                for (int i = 0; i < a.size(); ++i) {
                    this.addKidObjectToStructElemList(a.get(i), kids);
                }
            } else {
                this.addKidObjectToStructElemList(k, kids);
            }
        }
        return kids;
    }

    public PdfObject getK() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.K);
    }

    public static int identifyType(PdfDocument doc, PdfName role) {
        PdfDictionary roleMap = doc.getStructTreeRoot().getRoleMap();
        if (roleMap.containsKey(role)) {
            role = roleMap.getAsName(role);
        }
        if (groupingRoles.contains(role)) {
            return Grouping;
        }
        if (blockLevelRoles.contains(role)) {
            return BlockLevel;
        }
        if (inlineLevelRoles.contains(role)) {
            return InlineLevel;
        }
        if (illustrationRoles.contains(role)) {
            return Illustration;
        }
        return Unknown;
    }

    public PdfStructElem put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    @Override
    public void flush() {
        super.flush();
    }

    protected int getType() {
        if (this.type == Unknown) {
            PdfName role = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.S);
            this.type = PdfStructElem.identifyType(this.getDocument(), role);
        }
        return this.type;
    }

    static void addKidObject(PdfDictionary parent, int index, PdfObject kid) {
        if (parent.isFlushed()) {
            throw new PdfException("cannot.add.kid.to.the.flushed.element");
        }
        if (!parent.containsKey(PdfName.P)) {
            throw new PdfException("structure.element.shall.contain.parent.object", parent);
        }
        PdfObject k = parent.get(PdfName.K);
        if (k == null) {
            parent.put(PdfName.K, kid);
        } else {
            PdfArray a;
            if (k instanceof PdfArray) {
                a = (PdfArray)k;
            } else {
                a = new PdfArray();
                a.add(k);
                parent.put(PdfName.K, a);
            }
            if (index == -1) {
                a.add(kid);
            } else {
                a.add(index, kid);
            }
        }
        if (kid instanceof PdfDictionary && PdfStructElem.isStructElem((PdfDictionary)kid)) {
            ((PdfDictionary)kid).put(PdfName.P, parent);
        }
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    private void addKidObjectToStructElemList(PdfObject k, List<IPdfStructElem> list) {
        if (k.isFlushed()) {
            list.add(null);
            return;
        }
        list.add(this.convertPdfObjectToIPdfStructElem(k));
    }

    private IPdfStructElem convertPdfObjectToIPdfStructElem(PdfObject obj) {
        if (obj.isIndirectReference()) {
            obj = ((PdfIndirectReference)obj).getRefersTo();
        }
        PdfObjectWrapper elem = null;
        switch (obj.getType()) {
            case 3: {
                PdfDictionary d = (PdfDictionary)obj;
                if (PdfStructElem.isStructElem(d)) {
                    elem = new PdfStructElem(d);
                    break;
                }
                if (PdfName.MCR.equals(d.getAsName(PdfName.Type))) {
                    elem = new PdfMcrDictionary(d, this);
                    break;
                }
                if (!PdfName.OBJR.equals(d.getAsName(PdfName.Type))) break;
                elem = new PdfObjRef(d, this);
                break;
            }
            case 8: {
                elem = new PdfMcrNumber((PdfNumber)obj, this);
                break;
            }
        }
        return elem;
    }

    private int removeKidObject(PdfObject kid) {
        PdfObject k = this.getK();
        if (k == null || !k.isArray() && k != kid && k != kid.getIndirectReference()) {
            return -1;
        }
        int removedIndex = -1;
        if (k.isArray()) {
            PdfArray kidsArray = (PdfArray)k;
            removedIndex = PdfStructElem.removeObjectFromArray(kidsArray, kid);
            if (kidsArray.isEmpty()) {
                ((PdfDictionary)this.getPdfObject()).remove(PdfName.K);
            }
        }
        if (!k.isArray() || k.isArray() && ((PdfArray)k).isEmpty()) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.K);
            removedIndex = 0;
        }
        return removedIndex;
    }

    static int removeObjectFromArray(PdfArray array, PdfObject toRemove) {
        int i;
        for (i = 0; i < array.size(); ++i) {
            PdfObject obj = array.get(i);
            if (obj != toRemove && obj != toRemove.getIndirectReference()) continue;
            array.remove(i);
            break;
        }
        return i;
    }
}

