/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReaderASCII;
import com.alibaba.fastjson2.JSONReaderJSONB;
import com.alibaba.fastjson2.JSONReaderStr;
import com.alibaba.fastjson2.JSONReaderUTF16;
import com.alibaba.fastjson2.JSONReaderUTF8;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.ReferenceKey;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public abstract class JSONReader
implements Closeable {
    static final int MAX_EXP = 512;
    static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    static final ZoneId UTC = ZoneId.of("UTC");
    static final ZoneId SHANGHAI = ZoneId.of("Asia/Shanghai");
    static final long LONG_MASK = 0xFFFFFFFFL;
    static final byte JSON_TYPE_INT = 1;
    static final byte JSON_TYPE_DEC = 2;
    static final byte JSON_TYPE_STRING = 3;
    static final byte JSON_TYPE_BOOL = 4;
    static final byte JSON_TYPE_NULL = 5;
    static final byte JSON_TYPE_OBJECT = 6;
    static final byte JSON_TYPE_ARRAY = 7;
    static final byte JSON_TYPE_BIG_DEC = 8;
    static final char EOI = '\u001a';
    static final long SPACE = 4294981376L;
    final Context context;
    List<ResolveTask> resolveTasks;
    protected int offset;
    protected char ch;
    protected boolean comma;
    protected boolean nameEscape = false;
    protected boolean valueEscape = false;
    protected boolean wasNull = false;
    protected boolean boolValue = false;
    protected boolean negative = false;
    protected byte valueType = 0;
    protected byte exponent;
    protected byte scale;
    protected int mag0;
    protected int mag1;
    protected int mag2;
    protected int mag3;
    protected String stringValue;
    protected Object complex;
    protected boolean typeRedirect;

    public final char current() {
        return this.ch;
    }

    public final boolean isEnd() {
        return this.ch == '\u001a';
    }

    public byte getType() {
        return -128;
    }

    public boolean isInt() {
        return this.ch == '-' || this.ch == '+' || this.ch >= '0' && this.ch <= '9';
    }

    public boolean isNull() {
        return this.ch == 'n';
    }

    public boolean nextIfNull() {
        if (this.ch == 'n') {
            this.readNull();
            return true;
        }
        return false;
    }

    public JSONReader(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public Locale getLocale() {
        return this.context.getLocale();
    }

    public ZoneId getZoneId() {
        return this.context.getZoneId();
    }

    public long features(long features) {
        return this.context.features | features;
    }

    public void handleResolveTasks(Object root) {
        if (this.resolveTasks == null) {
            return;
        }
        Object previous = null;
        for (ResolveTask resolveTask : this.resolveTasks) {
            Object fieldValue;
            JSONPath path = resolveTask.reference;
            FieldReader fieldReader = resolveTask.fieldReader;
            if (path.isPrevious()) {
                fieldValue = previous;
            } else {
                if (!path.isRef()) {
                    throw new JSONException("reference path invalid : " + path);
                }
                path.setReaderContext(this.context);
                if ((this.context.features & Feature.FieldBased.mask) != 0L) {
                    JSONWriter.Context writeContext = JSONFactory.createWriteContext();
                    writeContext.features |= JSONWriter.Feature.FieldBased.mask;
                    path.setWriterContext(writeContext);
                }
                previous = fieldValue = path.eval(root);
            }
            Object resolvedName = resolveTask.name;
            Object resolvedObject = resolveTask.object;
            if (resolvedName != null) {
                if (resolvedObject instanceof Map) {
                    Map map = (Map)resolvedObject;
                    if (resolvedName instanceof ReferenceKey) {
                        if (map instanceof LinkedHashMap) {
                            int size = map.size();
                            if (size == 0) continue;
                            Object[] keys2 = new Object[size];
                            Object[] values2 = new Object[size];
                            int index = 0;
                            for (Map.Entry o : map.entrySet()) {
                                Map.Entry entry = o;
                                Object entryKey = entry.getKey();
                                keys2[index] = resolvedName == entryKey ? fieldValue : entryKey;
                                values2[index++] = entry.getValue();
                            }
                            map.clear();
                            for (int j = 0; j < keys2.length; ++j) {
                                map.put(keys2[j], values2[j]);
                            }
                            continue;
                        }
                        map.put(fieldValue, map.remove(resolvedName));
                        continue;
                    }
                    map.put(resolvedName, fieldValue);
                    continue;
                }
                if (resolvedName instanceof Integer) {
                    if (resolvedObject instanceof List) {
                        int index = (Integer)resolvedName;
                        List list = (List)resolvedObject;
                        list.set(index, fieldValue);
                        continue;
                    }
                    if (resolvedObject instanceof Object[]) {
                        int index = (Integer)resolvedName;
                        Object[] array = (Object[])resolvedObject;
                        array[index] = fieldValue;
                        continue;
                    }
                    if (resolvedObject instanceof Collection) {
                        Collection collection = (Collection)resolvedObject;
                        collection.add(fieldValue);
                        continue;
                    }
                }
            }
            fieldReader.accept(resolvedObject, fieldValue);
        }
    }

    public ObjectReader getObjectReader(Type type) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        return this.context.provider.getObjectReader(type, fieldBased);
    }

    public boolean isSupportSmartMatch() {
        return (this.context.features & Feature.SupportSmartMatch.mask) != 0L;
    }

    public boolean isSupportSmartMatch(long features) {
        return ((this.context.features | features) & Feature.SupportSmartMatch.mask) != 0L;
    }

    public boolean isSupportBeanArray() {
        return (this.context.features & Feature.SupportArrayToBean.mask) != 0L;
    }

    public boolean isSupportBeanArray(long features) {
        return ((this.context.features | features) & Feature.SupportArrayToBean.mask) != 0L;
    }

    public boolean isSupportAutoType(long features) {
        return ((this.context.features | features) & Feature.SupportAutoType.mask) != 0L;
    }

    public boolean isJSONB() {
        return false;
    }

    public boolean isIgnoreNoneSerializable() {
        return (this.context.features & Feature.IgnoreNoneSerializable.mask) != 0L;
    }

    public ObjectReader checkAutoType(Class expectClass, long expectClassHash, long features) {
        return null;
    }

    static char char1(int c) {
        switch (c) {
            case 48: {
                return '\u0000';
            }
            case 49: {
                return '\u0001';
            }
            case 50: {
                return '\u0002';
            }
            case 51: {
                return '\u0003';
            }
            case 52: {
                return '\u0004';
            }
            case 53: {
                return '\u0005';
            }
            case 54: {
                return '\u0006';
            }
            case 55: {
                return '\u0007';
            }
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 118: {
                return '\u000b';
            }
            case 70: 
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 64: 
            case 91: 
            case 92: 
            case 93: {
                return (char)c;
            }
        }
        throw new JSONException("unclosed.str.lit " + (char)c);
    }

    static char char2(int c1, int c2) {
        return (char)(JSONFactory.DIGITS2[c1] * 16 + JSONFactory.DIGITS2[c2]);
    }

    static char char4(int c1, int c2, int c3, int c4) {
        return (char)(JSONFactory.DIGITS2[c1] * 4096 + JSONFactory.DIGITS2[c2] * 256 + JSONFactory.DIGITS2[c3] * 16 + JSONFactory.DIGITS2[c4]);
    }

    public boolean nextIfObjectStart() {
        if (this.ch != '{') {
            return false;
        }
        this.next();
        return true;
    }

    public boolean nextIfObjectEnd() {
        if (this.ch != '}') {
            return false;
        }
        this.next();
        return true;
    }

    public int startArray() {
        this.next();
        return 0;
    }

    public boolean isReference() {
        return false;
    }

    public String readReference() {
        throw new JSONException("TODO");
    }

    public void addResolveTask(FieldReader fieldReader, Object object, JSONPath path) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(fieldReader, object, null, path));
    }

    public void addResolveTask(Map object, Object key, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        if (object instanceof LinkedHashMap) {
            object.put(key, null);
        }
        this.resolveTasks.add(new ResolveTask(null, object, key, reference));
    }

    public void addResolveTask(Collection object, int i, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(null, object, i, reference));
    }

    public void addResolveTask(Object[] object, int i, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(null, object, i, reference));
    }

    public boolean isArray() {
        return this.ch == '[';
    }

    public boolean isObject() {
        return this.ch == '{';
    }

    public boolean isNumber() {
        switch (this.ch) {
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public boolean isString() {
        return this.ch == '\"' || this.ch == '\'';
    }

    public void endArray() {
        this.next();
    }

    public boolean nextIfMatch(char ch) {
        if (this.ch != ch) {
            return false;
        }
        this.next();
        return true;
    }

    public abstract String readPattern();

    public final int getOffset() {
        return this.offset;
    }

    public abstract void next();

    public abstract long readValueHashCode();

    public long readTypeHashCode() {
        return this.readValueHashCode();
    }

    public abstract long readFieldNameHashCode();

    public abstract long getNameHashCodeLCase();

    public abstract String readFieldName();

    public abstract String getFieldName();

    public void setTypeRedirect(boolean typeRedirect) {
        this.typeRedirect = typeRedirect;
    }

    public boolean isTypeRedirect() {
        return this.typeRedirect;
    }

    public long readFieldNameHashCodeUnquote() {
        throw new UnsupportedOperationException();
    }

    public String readFieldNameUnquote() {
        this.readFieldNameHashCodeUnquote();
        return this.getFieldName();
    }

    public boolean skipName() {
        this.readFieldNameHashCode();
        return true;
    }

    public abstract void skipValue();

    public boolean isBinary() {
        throw new UnsupportedOperationException();
    }

    public byte[] readBinary() {
        throw new UnsupportedOperationException();
    }

    public abstract int readInt32Value();

    public boolean nextIfMatch(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public boolean nextIfMatch(byte type) {
        throw new UnsupportedOperationException();
    }

    public Integer readInt32() {
        this.readNumber0();
        if (this.valueType == 1) {
            return this.negative ? -this.mag3 : this.mag3;
        }
        if (this.valueType == 5) {
            return null;
        }
        Number number = this.getNumber();
        return number == null ? 0 : number.intValue();
    }

    public int getInt32Value() {
        switch (this.valueType) {
            case 1: {
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    return this.negative ? -this.mag3 : this.mag3;
                }
                return this.getNumber().intValue();
            }
            case 2: {
                return this.getNumber().intValue();
            }
            case 4: {
                return this.boolValue ? 1 : 0;
            }
            case 5: {
                return 0;
            }
            case 3: {
                return this.toInt32(this.stringValue);
            }
            case 6: {
                Number num = this.toNumber((Map)this.complex);
                if (num != null) {
                    return num.intValue();
                }
                return 0;
            }
            case 7: {
                return this.toInt((List)this.complex);
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    protected long getInt64Value() {
        switch (this.valueType) {
            case 2: {
                return this.getNumber().longValue();
            }
            case 4: {
                return this.boolValue ? 1L : 0L;
            }
            case 5: {
                return 0L;
            }
            case 3: {
                return this.toInt64(this.stringValue);
            }
            case 6: {
                return this.toLong((Map)this.complex);
            }
            case 7: {
                return this.toInt((List)this.complex);
            }
        }
        throw new JSONException("TODO");
    }

    protected Long getInt64() {
        switch (this.valueType) {
            case 1: {
                int[] mag;
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    return this.negative ? (long)(-this.mag3) : (long)this.mag3;
                }
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        if (this.mag2 == Integer.MIN_VALUE && this.mag3 == 0 && !this.negative) {
                            return Long.MIN_VALUE;
                        }
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 >= Integer.MIN_VALUE && v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            return this.negative ? -v23 : v23;
                        }
                        mag = new int[]{this.mag2, this.mag3};
                    } else {
                        mag = new int[]{this.mag1, this.mag2, this.mag3};
                    }
                } else {
                    mag = new int[]{this.mag0, this.mag1, this.mag2, this.mag3};
                }
                return JSONReader.getBigInt(this.negative, mag).longValue();
            }
            case 2: {
                return this.getNumber().longValue();
            }
            case 4: {
                return this.boolValue ? 1L : 0L;
            }
            case 5: {
                return null;
            }
            case 3: {
                return this.toInt64(this.stringValue);
            }
            case 6: {
                Number num = this.toNumber((Map)this.complex);
                if (num != null) {
                    return num.longValue();
                }
                return null;
            }
        }
        throw new JSONException("TODO");
    }

    public abstract long readInt64Value();

    public abstract Long readInt64();

    public float readFloatValue() {
        this.readNumber();
        Number number = this.getNumber();
        return number == null ? 0.0f : number.floatValue();
    }

    public Float readFloat() {
        this.readNumber();
        Number number = this.getNumber();
        if (number instanceof Float) {
            return (Float)number;
        }
        return number == null ? null : Float.valueOf(number.floatValue());
    }

    public double readDoubleValue() {
        this.readNumber();
        Number number = this.getNumber();
        return number == null ? 0.0 : number.doubleValue();
    }

    public Double readDouble() {
        this.readNumber();
        Number number = this.getNumber();
        if (number instanceof Double) {
            return (Double)number;
        }
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    public Number readNumber() {
        this.readNumber0();
        return this.getNumber();
    }

    public BigInteger readBigInteger() {
        this.readNumber0();
        return this.getBigInteger();
    }

    public BigDecimal readBigDecimal() {
        this.readNumber0();
        return this.getBigDecimal();
    }

    public abstract UUID readUUID();

    public boolean isLocalDate() {
        LocalDateTime localDateTime;
        if (!this.isString()) {
            return false;
        }
        int len = this.getStringLength();
        switch (len) {
            case 8: {
                localDateTime = this.readLocalDate8();
                break;
            }
            case 9: {
                localDateTime = this.readLocalDate9();
                break;
            }
            case 10: {
                localDateTime = this.readLocalDate10();
                break;
            }
            case 11: {
                localDateTime = this.readLocalDate11();
                break;
            }
            default: {
                return false;
            }
        }
        if (localDateTime == null) {
            return false;
        }
        return localDateTime.getHour() == 0 && localDateTime.getMinute() == 0 && localDateTime.getSecond() == 0 && localDateTime.getNano() == 0;
    }

    public LocalDate readLocalDate() {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.isInt()) {
            long millis = this.readInt64Value();
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalDate();
        }
        int len = this.getStringLength();
        switch (len) {
            case 8: {
                return this.readLocalDate8().toLocalDate();
            }
            case 9: {
                return this.readLocalDate9().toLocalDate();
            }
            case 10: {
                return this.readLocalDate10().toLocalDate();
            }
            case 11: {
                return this.readLocalDate11().toLocalDate();
            }
        }
        String str = this.readString();
        if (str.isEmpty() || str.equals("null")) {
            return null;
        }
        if (IOUtils.isNumber(str)) {
            long millis = Long.parseLong(str);
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalDate();
        }
        throw new JSONException("not support input : " + str);
    }

    public boolean isLocalDateTime() {
        if (!this.isString()) {
            return false;
        }
        int len = this.getStringLength();
        switch (len) {
            case 16: {
                return this.readLocalDateTime16() != null;
            }
            case 17: {
                return this.readLocalDateTime17() != null;
            }
            case 18: {
                return this.readLocalDateTime18() != null;
            }
            case 19: {
                return this.readLocalDateTime19() != null;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return this.readLocalDateTimeX(len) != null;
            }
        }
        return false;
    }

    public LocalDateTime readLocalDateTime() {
        if (this.isInt()) {
            long millis = this.readInt64Value();
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalDateTime();
        }
        int len = this.getStringLength();
        switch (len) {
            case 8: {
                return this.readLocalDate8();
            }
            case 9: {
                return this.readLocalDate9();
            }
            case 10: {
                return this.readLocalDate10();
            }
            case 11: {
                return this.readLocalDate11();
            }
            case 16: {
                return this.readLocalDateTime16();
            }
            case 17: {
                return this.readLocalDateTime17();
            }
            case 18: {
                return this.readLocalDateTime18();
            }
            case 19: {
                return this.readLocalDateTime19();
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return this.readLocalDateTimeX(len);
            }
        }
        String strVal = this.readString();
        if (strVal.isEmpty() || strVal.equals("null")) {
            this.wasNull = true;
            return null;
        }
        if (IOUtils.isNumber(strVal)) {
            long millis = Long.parseLong(strVal);
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDateTime.ofInstant(instant, this.context.getZoneId());
        }
        throw new JSONException("TODO : " + len + ", " + strVal);
    }

    public ZonedDateTime readZonedDateTime() {
        if (this.isInt()) {
            long millis = this.readInt64Value();
            Instant instant = Instant.ofEpochMilli(millis);
            return instant.atZone(this.context.getZoneId());
        }
        if (this.ch == '\"') {
            LocalDateTime ldt;
            int len = this.getStringLength();
            if (len == 10 && (ldt = this.readLocalDate10()) != null) {
                return ZonedDateTime.of(ldt, this.context.getZoneId());
            }
            ZonedDateTime zdt = this.readZonedDateTimeX(len);
            if (zdt != null) {
                return zdt;
            }
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            if (IOUtils.isNumber(str)) {
                long millis = Long.parseLong(str);
                Instant instant = Instant.ofEpochMilli(millis);
                return instant.atZone(this.context.getZoneId());
            }
            throw new JSONException("TODO : " + str + ", len : " + len);
        }
        throw new JSONException("TODO : " + this.ch);
    }

    public LocalTime readLocalTime() {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.isInt()) {
            long millis = this.readInt64Value();
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalTime();
        }
        int len = this.getStringLength();
        switch (len) {
            case 8: {
                return this.readLocalTime8();
            }
            case 10: {
                return this.readLocalTime10();
            }
            case 11: {
                return this.readLocalTime11();
            }
            case 12: {
                return this.readLocalTime12();
            }
            case 18: {
                return this.readLocalTime18();
            }
        }
        String str = this.readString();
        if (str.isEmpty() || str.equals("null")) {
            return null;
        }
        if (IOUtils.isNumber(str)) {
            long millis = Long.parseLong(str);
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalTime();
        }
        throw new JSONException("not support len : " + len);
    }

    protected abstract int getStringLength();

    public Instant readInstant() {
        if (this.isString()) {
            int len = this.getStringLength();
            ZonedDateTime zdt = this.readZonedDateTimeX(len);
            if (zdt == null) {
                String str = this.readString();
                if (str.isEmpty() || str.equals("null")) {
                    return null;
                }
                if (IOUtils.isNumber(str)) {
                    long millis = Long.parseLong(str);
                    return Instant.ofEpochMilli(millis);
                }
                throw new JSONException("TODO : " + str + ", len : " + len);
            }
            return zdt.toInstant();
        }
        if (this.isNumber()) {
            long millis = this.readInt64Value();
            return Instant.ofEpochMilli(millis);
        }
        if (this.isObject()) {
            return (Instant)this.getObjectReader((Type)((Object)Instant.class)).createInstance(this.readObject(), 0L);
        }
        if (this.nextIfNull()) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public long readMillisFromString() {
        ZonedDateTime zdt;
        int len = this.getStringLength();
        switch (len) {
            case 8: {
                LocalDateTime date = this.readLocalDate8();
                if (date != null) {
                    return ZonedDateTime.of(date, this.context.getZoneId()).toInstant().toEpochMilli();
                }
                throw new JSONException("TODO : " + this.readString());
            }
            case 9: {
                LocalDateTime date = this.readLocalDate9();
                if (date == null) break;
                return ZonedDateTime.of(date, this.context.getZoneId()).toInstant().toEpochMilli();
            }
            case 10: {
                LocalDateTime date = this.readLocalDate10();
                if (date != null) {
                    return ZonedDateTime.of(date, this.context.getZoneId()).toInstant().toEpochMilli();
                }
                String str = this.readString();
                if ("0000-00-00".equals(str)) {
                    return 0L;
                }
                throw new JSONException("TODO : " + str);
            }
            case 11: {
                LocalDateTime date = this.readLocalDate11();
                return ZonedDateTime.of(date, this.context.getZoneId()).toInstant().toEpochMilli();
            }
            case 16: {
                LocalDateTime date = this.readLocalDateTime16();
                return ZonedDateTime.of(date, this.context.getZoneId()).toInstant().toEpochMilli();
            }
            case 17: {
                LocalDateTime ldt = this.readLocalDateTime17();
                return ZonedDateTime.of(ldt, this.context.getZoneId()).toInstant().toEpochMilli();
            }
            case 18: {
                LocalDateTime date = this.readLocalDateTime18();
                return ZonedDateTime.of(date, this.context.getZoneId()).toInstant().toEpochMilli();
            }
            case 19: {
                LocalDateTime date = this.readLocalDateTime19();
                return ZonedDateTime.of(date, this.context.getZoneId()).toInstant().toEpochMilli();
            }
        }
        if (len >= 20 && (zdt = this.readZonedDateTimeX(len)) != null) {
            return zdt.toInstant().toEpochMilli();
        }
        String str = this.readString();
        if (str.isEmpty() || str.equals("null")) {
            this.wasNull = true;
            return 0L;
        }
        String utilDateFormat = this.context.getUtilDateFormat();
        if (utilDateFormat != null && !utilDateFormat.isEmpty()) {
            SimpleDateFormat utilFormat = new SimpleDateFormat(utilDateFormat);
            try {
                return utilFormat.parse(str).getTime();
            }
            catch (ParseException e) {
                throw new JSONException("parse date error, " + str + ", expect format " + utilFormat);
            }
        }
        if ("0000-00-00T00:00:00".equals(str) || "0001-01-01T00:00:00+08:00".equals(str)) {
            return 0L;
        }
        if (str.startsWith("/Date(") && str.endsWith(")/")) {
            String dotnetDateStr = str.substring(6, str.length() - 2);
            int i = dotnetDateStr.indexOf(43);
            if (i == -1) {
                i = dotnetDateStr.indexOf(45);
            }
            if (i != -1) {
                dotnetDateStr = dotnetDateStr.substring(0, i);
            }
            return Long.parseLong(dotnetDateStr);
        }
        if (IOUtils.isNumber(str)) {
            return Long.parseLong(str);
        }
        throw new JSONException("TODO : " + str + ", len : " + len);
    }

    protected LocalDateTime readLocalDateTime16() {
        throw new UnsupportedOperationException();
    }

    protected LocalDateTime readLocalDateTime17() {
        throw new UnsupportedOperationException();
    }

    protected LocalDateTime readLocalDateTime18() {
        throw new UnsupportedOperationException();
    }

    protected abstract LocalDateTime readLocalDateTime19();

    protected abstract LocalDateTime readLocalDateTimeX(int var1);

    protected abstract LocalTime readLocalTime8();

    protected LocalTime readLocalTime10() {
        throw new UnsupportedOperationException();
    }

    protected LocalTime readLocalTime11() {
        throw new UnsupportedOperationException();
    }

    protected abstract LocalTime readLocalTime12();

    protected abstract LocalTime readLocalTime18();

    protected abstract LocalDateTime readLocalDate8();

    protected abstract LocalDateTime readLocalDate9();

    protected abstract LocalDateTime readLocalDate10();

    protected LocalDateTime readLocalDate11() {
        throw new UnsupportedOperationException();
    }

    protected ZonedDateTime readZonedDateTimeX(int len) {
        throw new UnsupportedOperationException();
    }

    public void readNumber(ValueConsumer consumer, boolean quoted) {
        this.readNumber0();
        Number number = this.getNumber();
        consumer.accept(number);
    }

    public void readString(ValueConsumer consumer, boolean quoted) {
        String str = this.readString();
        if (quoted) {
            consumer.accept(JSON.toJSONString(str));
        } else {
            consumer.accept(str);
        }
    }

    protected abstract void readNumber0();

    public abstract String readString();

    public abstract void readNull();

    public abstract boolean readIfNull();

    public abstract String getString();

    public boolean wasNull() {
        return this.wasNull;
    }

    public <T> T read(Type type) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readObject(this, 0L);
    }

    public <T> T read(Class<T> type) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readObject(this, 0L);
    }

    public Map<String, Object> readObject() {
        JSONObject object;
        this.nextIfObjectStart();
        if (this.context.objectClass == null || this.context.objectClass == Object.class) {
            object = (this.context.features & Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject();
        } else {
            try {
                object = (JSONObject)this.context.objectClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException("create object instance error, objectClass " + this.context.objectClass.getName(), e);
            }
        }
        block11: while (true) {
            Object val;
            if (this.ch == '}') break;
            String name = this.readFieldName();
            if (name == null) {
                name = this.readFieldNameUnquote();
                this.nextIfMatch(':');
            }
            switch (this.ch) {
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.readNumber0();
                    val = this.getNumber();
                    break;
                }
                case '[': {
                    val = this.readArray();
                    break;
                }
                case '{': {
                    val = this.readObject();
                    break;
                }
                case '\"': 
                case '\'': {
                    val = this.readString();
                    break;
                }
                case 'f': 
                case 't': {
                    val = this.readBoolValue();
                    break;
                }
                case 'n': {
                    this.readNull();
                    val = null;
                    break;
                }
                case '/': {
                    this.next();
                    if (this.ch != '/') continue block11;
                    this.skipLineComment();
                    continue block11;
                }
                default: {
                    throw new JSONException("illegal input offset " + this.offset + ", char " + this.ch);
                }
            }
            object.put(name, val);
        }
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return object;
    }

    public void skipLineComment() {
        throw new UnsupportedOperationException();
    }

    public Boolean readBool() {
        if (this.isNull()) {
            this.readNull();
            return null;
        }
        return this.readBoolValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readBoolValue() {
        boolean val;
        this.wasNull = false;
        if (this.ch == 't') {
            this.next();
            char c1 = this.ch;
            this.next();
            char c2 = this.ch;
            this.next();
            char c3 = this.ch;
            if (c1 != 'r' || c2 != 'u') {
                if (c3 != 'e') throw new JSONException("syntax error : " + this.ch);
            }
            val = true;
        } else if (this.ch == 'f') {
            this.next();
            char c1 = this.ch;
            this.next();
            char c2 = this.ch;
            this.next();
            char c3 = this.ch;
            this.next();
            char c4 = this.ch;
            if ((c1 != 'a' || c2 != 'l') && c3 != 's') {
                if (c4 != 'e') throw new JSONException("syntax error : " + this.ch);
            }
            val = false;
        } else {
            if (this.ch == '-' || this.ch >= '0' && this.ch <= '9') {
                this.readNumber();
                if (this.valueType != 1) return false;
                if (this.mag1 != 0) return false;
                if (this.mag2 != 0) return false;
                if (this.mag3 != 1) return false;
                return true;
            }
            if (this.ch == 'n') {
                this.wasNull = true;
                this.readNull();
                return false;
            }
            if (this.ch != '\"') throw new JSONException("syntax error : " + this.ch);
            int len = this.getStringLength();
            if (len == 1) {
                this.next();
                if (this.ch == '0' || this.ch == 'N') {
                    this.next();
                    this.next();
                    this.nextIfMatch(',');
                    return false;
                }
                if (this.ch != '1') {
                    if (this.ch != 'Y') throw new JSONException("can not convert to boolean : " + this.ch);
                }
                this.next();
                this.next();
                this.nextIfMatch(',');
                return true;
            }
            String str = this.readString();
            if ("true".equalsIgnoreCase(str)) {
                return true;
            }
            if (!"false".equalsIgnoreCase(str)) throw new JSONException("can not convert to boolean : " + str);
            return false;
        }
        this.next();
        this.nextIfMatch(',');
        return val;
    }

    public Object readAny() {
        return this.read(Object.class);
    }

    public List readArray(Type itemType) {
        ArrayList list = new ArrayList();
        if (!this.nextIfMatch('[')) {
            throw new JSONException("syntax error : " + this.ch);
        }
        while (!this.nextIfMatch(']')) {
            Object item = this.read(itemType);
            list.add(item);
        }
        if (this.ch == ',') {
            this.next();
        }
        return list;
    }

    public List readArray() {
        this.next();
        JSONArray list = new JSONArray();
        block9: while (true) {
            Object val;
            switch (this.ch) {
                case ']': {
                    this.next();
                    break block9;
                }
                case '[': {
                    val = this.readArray();
                    break;
                }
                case '{': {
                    val = this.readObject();
                    break;
                }
                case '\"': 
                case '\'': {
                    val = this.readString();
                    break;
                }
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.readNumber0();
                    val = this.getNumber();
                    break;
                }
                case 'f': 
                case 't': {
                    val = this.readBoolValue();
                    break;
                }
                case 'n': {
                    this.readNull();
                    val = null;
                    break;
                }
                default: {
                    throw new JSONException("TODO : " + this.ch);
                }
            }
            list.add(val);
        }
        if (this.ch == ',') {
            this.next();
        }
        return list;
    }

    public BigInteger getBigInteger() {
        Number number = this.getNumber();
        if (number == null) {
            return null;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        return BigInteger.valueOf(number.longValue());
    }

    public BigDecimal getBigDecimal() {
        if (this.wasNull) {
            return null;
        }
        switch (this.valueType) {
            case 1: {
                int[] mag;
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    return BigDecimal.valueOf(this.negative ? (long)(-this.mag3) : (long)this.mag3);
                }
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 >= Integer.MIN_VALUE && v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            return BigDecimal.valueOf(this.negative ? -v23 : v23);
                        }
                        mag = new int[]{this.mag2, this.mag3};
                    } else {
                        mag = new int[]{this.mag1, this.mag2, this.mag3};
                    }
                } else {
                    mag = new int[]{this.mag0, this.mag1, this.mag2, this.mag3};
                }
                return new BigDecimal(JSONReader.getBigInt(this.negative, mag));
            }
            case 2: {
                int[] nArray;
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        if (this.mag2 == 0) {
                            int[] nArray2 = new int[1];
                            nArray = nArray2;
                            nArray2[0] = this.mag3;
                        } else {
                            int[] nArray3 = new int[2];
                            nArray3[0] = this.mag2;
                            nArray = nArray3;
                            nArray3[1] = this.mag3;
                        }
                    } else {
                        int[] nArray4 = new int[3];
                        nArray4[0] = this.mag1;
                        nArray4[1] = this.mag2;
                        nArray = nArray4;
                        nArray4[2] = this.mag3;
                    }
                } else {
                    int[] nArray5 = new int[4];
                    nArray5[0] = this.mag0;
                    nArray5[1] = this.mag1;
                    nArray5[2] = this.mag2;
                    nArray = nArray5;
                    nArray5[3] = this.mag3;
                }
                int[] mag = nArray;
                BigInteger bigInt = JSONReader.getBigInt(this.negative, mag);
                return new BigDecimal(bigInt, this.scale);
            }
            case 8: {
                return new BigDecimal(this.stringValue);
            }
            case 4: {
                return this.boolValue ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case 5: {
                return null;
            }
            case 3: {
                try {
                    return new BigDecimal(this.stringValue);
                }
                catch (NumberFormatException ex) {
                    throw new JSONException("read decimal error, value " + this.stringValue, ex);
                }
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    public Number getNumber() {
        if (this.wasNull) {
            return null;
        }
        switch (this.valueType) {
            case 1: {
                int[] mag;
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    if (this.negative) {
                        if (this.mag3 < 0) {
                            return -((long)this.mag3 & 0xFFFFFFFFL);
                        }
                        return -this.mag3;
                    }
                    if (this.mag3 < 0) {
                        return (long)this.mag3 & 0xFFFFFFFFL;
                    }
                    return this.mag3;
                }
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 >= Integer.MIN_VALUE && v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            return this.negative ? -v23 : v23;
                        }
                        mag = new int[]{this.mag2, this.mag3};
                    } else {
                        mag = new int[]{this.mag1, this.mag2, this.mag3};
                    }
                } else {
                    mag = new int[]{this.mag0, this.mag1, this.mag2, this.mag3};
                }
                return JSONReader.getBigInt(this.negative, mag);
            }
            case 2: {
                int[] nArray;
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        if (this.mag2 == 0) {
                            int[] nArray2 = new int[1];
                            nArray = nArray2;
                            nArray2[0] = this.mag3;
                        } else {
                            int[] nArray3 = new int[2];
                            nArray3[0] = this.mag2;
                            nArray = nArray3;
                            nArray3[1] = this.mag3;
                        }
                    } else {
                        int[] nArray4 = new int[3];
                        nArray4[0] = this.mag1;
                        nArray4[1] = this.mag2;
                        nArray = nArray4;
                        nArray4[2] = this.mag3;
                    }
                } else {
                    int[] nArray5 = new int[4];
                    nArray5[0] = this.mag0;
                    nArray5[1] = this.mag1;
                    nArray5[2] = this.mag2;
                    nArray = nArray5;
                    nArray5[3] = this.mag3;
                }
                int[] mag = nArray;
                BigInteger bigInt = JSONReader.getBigInt(this.negative, mag);
                BigDecimal decimal = new BigDecimal(bigInt, this.scale);
                if (this.exponent != 0) {
                    double doubleValue = Double.parseDouble(decimal + "E" + this.exponent);
                    return doubleValue;
                }
                if ((this.context.features & Feature.UseBigDecimalForFloats.mask) != 0L) {
                    return Float.valueOf(decimal.floatValue());
                }
                if ((this.context.features & Feature.UseBigDecimalForDoubles.mask) != 0L) {
                    return decimal.doubleValue();
                }
                return decimal;
            }
            case 8: {
                if (this.scale > 0) {
                    return new BigDecimal(this.stringValue);
                }
                return new BigInteger(this.stringValue);
            }
            case 4: {
                return this.boolValue ? 1 : 0;
            }
            case 5: {
                return null;
            }
            case 3: {
                return this.toInt64(this.stringValue);
            }
            case 6: {
                return this.toNumber((Map)this.complex);
            }
            case 7: {
                return this.toNumber((List)this.complex);
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    @Override
    public void close() {
    }

    static BigInteger getBigInt(boolean negative, int[] mag) {
        int bitLength;
        int signum;
        int n = mag.length == 0 ? 0 : (signum = negative ? -1 : 1);
        if (mag.length == 0) {
            bitLength = 0;
        } else {
            int bitLengthForInt = 32 - Integer.numberOfLeadingZeros(mag[0]);
            int magBitLength = (mag.length - 1 << 5) + bitLengthForInt;
            if (signum < 0) {
                boolean pow2 = Integer.bitCount(mag[0]) == 1;
                for (int i = 1; i < mag.length && pow2; ++i) {
                    pow2 = mag[i] == 0;
                }
                bitLength = pow2 ? magBitLength - 1 : magBitLength;
            } else {
                bitLength = magBitLength;
            }
        }
        int byteLen = bitLength / 8 + 1;
        byte[] bytes = new byte[byteLen];
        int bytesCopied = 4;
        int nextInt = 0;
        int intIndex = 0;
        for (int i = byteLen - 1; i >= 0; --i) {
            if (bytesCopied == 4) {
                int n2;
                if ((n2 = intIndex++) < 0) {
                    nextInt = 0;
                } else if (n2 >= mag.length) {
                    nextInt = signum < 0 ? -1 : 0;
                } else {
                    int magInt = mag[mag.length - n2 - 1];
                    if (signum >= 0) {
                        nextInt = magInt;
                    } else {
                        int j;
                        int mlen = mag.length;
                        for (j = mlen - 1; j >= 0 && mag[j] == 0; --j) {
                        }
                        int firstNonzeroIntNum = mlen - j - 1;
                        nextInt = n2 <= firstNonzeroIntNum ? -magInt : ~magInt;
                    }
                }
                bytesCopied = 1;
            } else {
                nextInt >>>= 8;
                ++bytesCopied;
            }
            bytes[i] = (byte)nextInt;
        }
        return new BigInteger(bytes);
    }

    protected final int toInt32(String val) {
        if (IOUtils.isNumber(val)) {
            return Integer.parseInt(val);
        }
        throw new JSONException("parseInt error, value : " + val);
    }

    protected final long toInt64(String val) {
        if (IOUtils.isNumber(val)) {
            return Long.parseLong(val);
        }
        throw new JSONException("parseLong error, value : " + val);
    }

    protected final long toLong(Map map) {
        Object val = map.get("val");
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        throw new JSONException("parseLong error, value : " + map);
    }

    protected final int toInt(List list) {
        if (list.size() == 1) {
            Object val = list.get(0);
            if (val instanceof Number) {
                return ((Number)val).intValue();
            }
            if (val instanceof String) {
                return Integer.parseInt((String)val);
            }
        }
        throw new JSONException("parseLong error, field : value " + list);
    }

    protected final Number toNumber(Map map) {
        Object val = map.get("val");
        if (val instanceof Number) {
            return (Number)val;
        }
        return null;
    }

    protected final Number toNumber(List list) {
        if (list.size() == 1) {
            Object val = list.get(0);
            if (val instanceof Number) {
                return (Number)val;
            }
            if (val instanceof String) {
                return new BigDecimal((String)val);
            }
        }
        return null;
    }

    protected final String toString(List array) {
        JSONWriter writer = JSONWriter.of();
        writer.write(array);
        return writer.toString();
    }

    protected final String toString(Map object) {
        JSONWriter writer = JSONWriter.of();
        writer.write(object);
        return writer.toString();
    }

    public static JSONReader of(byte[] utf8Bytes) {
        return new JSONReaderUTF8(JSONFactory.createReadContext(), utf8Bytes, 0, utf8Bytes.length);
    }

    public static JSONReader of(char[] chars) {
        return new JSONReaderUTF16(JSONFactory.createReadContext(), null, chars, 0, chars.length);
    }

    public static JSONReader of(Context context, char[] chars) {
        return new JSONReaderUTF16(context, null, chars, 0, chars.length);
    }

    public static JSONReader ofJSONB(byte[] jsonbBytes) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(), jsonbBytes, 0, jsonbBytes.length, null);
    }

    public static JSONReader ofJSONB(byte[] jsonbBytes, Feature ... features) {
        Context context = JSONFactory.createReadContext();
        context.config(features);
        return new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length, null);
    }

    public static JSONReader ofJSONB(byte[] bytes, int offset, int length) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(), bytes, offset, length, null);
    }

    public static JSONReader ofJSONB(byte[] bytes, int offset, int length, JSONB.SymbolTable symbolTable) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(), bytes, offset, length, symbolTable);
    }

    public static JSONReader of(byte[] bytes, int offset, int length, Charset charset) {
        Context ctx = JSONFactory.createReadContext();
        if (charset == StandardCharsets.UTF_8) {
            return new JSONReaderUTF8(ctx, bytes, offset, length);
        }
        if (charset == StandardCharsets.UTF_16) {
            return new JSONReaderUTF16(ctx, bytes, offset, length);
        }
        if (charset == StandardCharsets.US_ASCII) {
            return new JSONReaderASCII(ctx, null, bytes, offset, length);
        }
        throw new JSONException("TODO");
    }

    public static JSONReader of(byte[] bytes, int offset, int length) {
        return new JSONReaderUTF8(JSONFactory.createReadContext(), bytes, offset, length);
    }

    public static JSONReader of(char[] chars, int offset, int length) {
        return new JSONReaderUTF16(JSONFactory.createReadContext(), null, chars, offset, length);
    }

    public static JSONReader of(InputStream is, Charset charset) {
        Context ctx = JSONFactory.createReadContext();
        byte[] bytes = JSONFactory.BYTES0_UPDATER.getAndSet(JSONFactory.CACHE, null);
        if (bytes == null) {
            bytes = new byte[8192];
        }
        int off = 0;
        try {
            int n;
            while ((n = is.read(bytes, off, bytes.length - off)) != -1) {
                if ((off += n) != bytes.length) continue;
                bytes = Arrays.copyOf(bytes, bytes.length + 8192);
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        if (charset == StandardCharsets.UTF_8 || charset == null) {
            return new JSONReaderUTF8(ctx, bytes, 0, off);
        }
        if (charset == StandardCharsets.UTF_16) {
            if (off % 2 == 1) {
                throw new JSONException("illegal input utf16 bytes, length " + off);
            }
            char[] chars = new char[off / 2];
            int i = 0;
            int j = 0;
            while (i < off) {
                byte c0 = bytes[i];
                byte c1 = bytes[i + 1];
                chars[j] = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                i += 2;
                ++j;
            }
            return new JSONReaderUTF16(ctx, null, chars, 0, chars.length);
        }
        throw new JSONException("not support input charset : " + charset);
    }

    public static JSONReader of(Reader is) {
        char[] chars = JSONFactory.CHARS_UPDATER.getAndSet(JSONFactory.CACHE, null);
        if (chars == null) {
            chars = new char[8192];
        }
        int off = 0;
        try {
            int n;
            while ((n = is.read(chars, off, chars.length - off)) != -1) {
                if ((off += n) != chars.length) continue;
                chars = Arrays.copyOf(chars, chars.length + 8192);
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        return new JSONReaderUTF16(JSONFactory.createReadContext(), null, chars, 0, off);
    }

    public static JSONReader of(String str) {
        int coder;
        if (str == null) {
            throw new NullPointerException();
        }
        Context ctx = JSONFactory.createReadContext();
        if (JDKUtils.STRING_BYTES_INTERNAL_API && JSONFactory.Utils.CODER_FUNCTION == null && !JSONFactory.Utils.CODER_FUNCTION_ERROR) {
            try {
                JSONFactory.Utils.CODER_FUNCTION = JDKUtils.getStringCode11();
                JSONFactory.Utils.VALUE_FUNCTION = JDKUtils.getStringValue11();
            }
            catch (Throwable ignored) {
                JSONFactory.Utils.CODER_FUNCTION_ERROR = true;
            }
        }
        if (JSONFactory.Utils.CODER_FUNCTION != null && JSONFactory.Utils.VALUE_FUNCTION != null && (coder = JSONFactory.Utils.CODER_FUNCTION.applyAsInt(str)) == 0) {
            byte[] value = JSONFactory.Utils.VALUE_FUNCTION.apply(str);
            return new JSONReaderASCII(ctx, str, value, 0, value.length);
        }
        if (JDKUtils.JVM_VERSION > 8) {
            try {
                byte coder2 = UnsafeUtils.getStringCoder(str);
                if (coder2 == 0) {
                    byte[] bytes = UnsafeUtils.getStringValue(str);
                    return new JSONReaderASCII(ctx, str, bytes, 0, bytes.length);
                }
            }
            catch (Exception e) {
                throw new JSONException("unsafe get String.coder error");
            }
            return new JSONReaderStr(ctx, str, 0, str.length());
        }
        char[] chars = JDKUtils.getCharArray(str);
        return new JSONReaderUTF16(ctx, str, chars, 0, chars.length);
    }

    void bigInt(char[] chars, int off, int len) {
        char c;
        int cursor = off;
        int numDigits = len - cursor;
        if (this.scale > 0) {
            --numDigits;
        }
        if (numDigits > 38) {
            throw new JSONException("number too large : " + new String(chars, off, numDigits));
        }
        int firstGroupLen = numDigits % 9;
        if (firstGroupLen == 0) {
            firstGroupLen = 9;
        }
        int start = cursor;
        cursor += firstGroupLen;
        int end = cursor++;
        if ((c = chars[start++]) == '.') {
            c = chars[start++];
        }
        int result = c - 48;
        for (int index = start; index < end; ++index) {
            c = chars[index];
            if (c == '.') {
                c = chars[++index];
                ++cursor;
                if (end < len) {
                    ++end;
                }
            }
            int nextVal = c - 48;
            result = 10 * result + nextVal;
        }
        this.mag3 = result;
        while (cursor < len) {
            char c2;
            int start2 = cursor;
            cursor += 9;
            int end2 = cursor++;
            if ((c2 = chars[start2++]) == '.') {
                c2 = chars[start2++];
                ++end2;
            }
            int result2 = c2 - 48;
            for (int index = start2; index < end2; ++index) {
                c2 = chars[index];
                if (c2 == '.') {
                    c2 = chars[++index];
                    ++cursor;
                    ++end2;
                }
                int nextVal = c2 - 48;
                result2 = 10 * result2 + nextVal;
            }
            int groupVal = result2;
            long ylong = 1000000000L;
            long product = 0L;
            long carry = 0L;
            for (int i = 3; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        product = ylong * ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)product;
                        break;
                    }
                    case 1: {
                        product = ylong * ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)product;
                        break;
                    }
                    case 2: {
                        product = ylong * ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)product;
                        break;
                    }
                    case 3: {
                        product = ylong * ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)product;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = product >>> 32;
            }
            long zlong = (long)groupVal & 0xFFFFFFFFL;
            long sum = ((long)this.mag3 & 0xFFFFFFFFL) + zlong;
            this.mag3 = (int)sum;
            carry = sum >>> 32;
            for (int i = 2; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        sum = ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)sum;
                        break;
                    }
                    case 1: {
                        sum = ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)sum;
                        break;
                    }
                    case 2: {
                        sum = ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)sum;
                        break;
                    }
                    case 3: {
                        sum = ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)sum;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = sum >>> 32;
            }
        }
    }

    void bigInt(byte[] chars, int off, int len) {
        char c;
        int cursor = off;
        int numDigits = len - cursor;
        if (this.scale > 0) {
            --numDigits;
        }
        if (numDigits > 38) {
            throw new JSONException("number too large : " + new String(chars, off, numDigits));
        }
        int firstGroupLen = numDigits % 9;
        if (firstGroupLen == 0) {
            firstGroupLen = 9;
        }
        int start = cursor;
        cursor += firstGroupLen;
        int end = cursor++;
        if ((c = (char)chars[start++]) == '.') {
            c = (char)chars[start++];
        }
        int result = c - 48;
        for (int index = start; index < end; ++index) {
            c = (char)chars[index];
            if (c == '.') {
                c = (char)chars[++index];
                ++cursor;
                if (end < len) {
                    ++end;
                }
            }
            int nextVal = c - 48;
            result = 10 * result + nextVal;
        }
        this.mag3 = result;
        while (cursor < len) {
            char c2;
            int start2 = cursor;
            cursor += 9;
            int end2 = cursor++;
            if ((c2 = (char)chars[start2++]) == '.') {
                c2 = (char)chars[start2++];
                ++end2;
            }
            int result2 = c2 - 48;
            for (int index = start2; index < end2; ++index) {
                c2 = (char)chars[index];
                if (c2 == '.') {
                    c2 = (char)chars[++index];
                    ++cursor;
                    ++end2;
                }
                int nextVal = c2 - 48;
                result2 = 10 * result2 + nextVal;
            }
            int groupVal = result2;
            long ylong = 1000000000L;
            long zlong = (long)groupVal & 0xFFFFFFFFL;
            long product = 0L;
            long carry = 0L;
            for (int i = 3; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        product = ylong * ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)product;
                        break;
                    }
                    case 1: {
                        product = ylong * ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)product;
                        break;
                    }
                    case 2: {
                        product = ylong * ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)product;
                        break;
                    }
                    case 3: {
                        product = ylong * ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)product;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = product >>> 32;
            }
            long sum = ((long)this.mag3 & 0xFFFFFFFFL) + zlong;
            this.mag3 = (int)sum;
            carry = sum >>> 32;
            for (int i = 2; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        sum = ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)sum;
                        break;
                    }
                    case 1: {
                        sum = ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)sum;
                        break;
                    }
                    case 2: {
                        sum = ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)sum;
                        break;
                    }
                    case 3: {
                        sum = ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)sum;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = sum >>> 32;
            }
        }
    }

    static LocalDateTime getLocalDateTime(char y0, char y1, char y2, char y3, char m0, char m1, char d0, char d1, char h0, char h1, char i0, char i1, char s0, char s1, char S0, char S1, char S2, char S3, char S4, char S5, char S6, char S7, char S8) {
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 < '0' || S0 > '9' || S1 < '0' || S1 > '9' || S2 < '0' || S2 > '9' || S3 < '0' || S3 > '9' || S4 < '0' || S4 > '9' || S5 < '0' || S5 > '9' || S6 < '0' || S6 > '9' || S7 < '0' || S7 > '9' || S8 < '0' || S8 > '9') {
            return null;
        }
        int nanos = (S0 - 48) * 100000000 + (S1 - 48) * 10000000 + (S2 - 48) * 1000000 + (S3 - 48) * 100000 + (S4 - 48) * 10000 + (S5 - 48) * 1000 + (S6 - 48) * 100 + (S7 - 48) * 10 + (S8 - 48);
        return LocalDateTime.of(year, month, dom, hour, minute, second, nanos);
    }

    static ZonedDateTime getZonedDateTime(char y0, char y1, char y2, char y3, char m0, char m1, char d0, char d1, char h0, char h1, char i0, char i1, char s0, char s1, char S0, char S1, char S2, char S3, char S4, char S5, char S6, char S7, char S8, ZoneId zoneId) {
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 < '0' || S0 > '9' || S1 < '0' || S1 > '9' || S2 < '0' || S2 > '9' || S3 < '0' || S3 > '9' || S4 < '0' || S4 > '9' || S5 < '0' || S5 > '9' || S6 < '0' || S6 > '9' || S7 < '0' || S7 > '9' || S8 < '0' || S8 > '9') {
            return null;
        }
        int nanos = (S0 - 48) * 100000000 + (S1 - 48) * 10000000 + (S2 - 48) * 1000000 + (S3 - 48) * 100000 + (S4 - 48) * 10000 + (S5 - 48) * 1000 + (S6 - 48) * 100 + (S7 - 48) * 10 + (S8 - 48);
        return ZonedDateTime.of(year, month, dom, hour, minute, second, nanos, zoneId);
    }

    protected ZoneId getZoneId(LocalDateTime ldt, String zoneIdStr) {
        ZoneId zoneId;
        if (zoneIdStr != null) {
            if ("000".equals(zoneIdStr)) {
                zoneId = UTC;
            } else {
                int p1;
                int p0 = zoneIdStr.indexOf(91);
                if (p0 > 0 && (p1 = zoneIdStr.indexOf(93, p0)) > 0) {
                    String str = zoneIdStr.substring(p0 + 1, p1);
                    zoneId = ZoneId.of(str);
                } else {
                    zoneId = ZoneId.of(zoneIdStr);
                }
            }
        } else {
            zoneId = this.context.getZoneId();
        }
        return zoneId;
    }

    public static class Context {
        String utilDateFormat;
        DateTimeFormatter dateFormat;
        ZoneId zoneId;
        long features;
        Locale locale;
        TimeZone timeZone;
        Class objectClass;
        AutoTypeBeforeHandler autoTypeBeforeHandler;
        protected final ObjectReaderProvider provider;

        public Context(ObjectReaderProvider provider) {
            this.provider = provider;
        }

        public ObjectReader getObjectReader(Type type) {
            boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
            return this.provider.getObjectReader(type, fieldBased);
        }

        public ObjectReaderProvider getProvider() {
            return this.provider;
        }

        public ObjectReader getObjectReaderAutoType(long hashCode) {
            return this.provider.getObjectReader(hashCode);
        }

        public ObjectReader getObjectReaderAutoType(String typeName, Class expectClass) {
            Class<?> autoTypeClass;
            if (this.autoTypeBeforeHandler != null && !ObjectReaderProvider.SAFE_MODE && (autoTypeClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, this.features)) != null) {
                boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
                return this.provider.getObjectReader(autoTypeClass, fieldBased);
            }
            return this.provider.getObjectReader(typeName, expectClass, this.features);
        }

        public ObjectReader getObjectReaderAutoType(String typeName, Class expectClass, long features) {
            return this.provider.getObjectReader(typeName, expectClass, this.features | features);
        }

        public Class getObjectClass() {
            return this.objectClass;
        }

        public void setObjectClass(Class objectClass) {
            this.objectClass = objectClass;
        }

        public DateTimeFormatter getDateFormat() {
            return this.dateFormat;
        }

        public void setDateFormat(DateTimeFormatter dateFormat) {
            this.dateFormat = dateFormat;
        }

        public String getUtilDateFormat() {
            return this.utilDateFormat;
        }

        public void setUtilDateFormat(String utilDateFormat) {
            this.utilDateFormat = utilDateFormat;
        }

        public ZoneId getZoneId() {
            if (this.zoneId == null) {
                this.zoneId = DEFAULT_ZONE_ID;
            }
            return this.zoneId;
        }

        public long getFeatures() {
            return this.features;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        public void config(Feature ... features) {
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public void config(Filter filter, Feature ... features) {
            if (filter instanceof AutoTypeBeforeHandler) {
                this.autoTypeBeforeHandler = (AutoTypeBeforeHandler)filter;
            }
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public boolean isEnable(Feature feature) {
            return (this.features & feature.mask) != 0L;
        }

        public void config(Feature feature, boolean state) {
            this.features = state ? (this.features |= feature.mask) : (this.features &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    static class ResolveTask {
        final FieldReader fieldReader;
        final Object object;
        final Object name;
        final JSONPath reference;

        ResolveTask(FieldReader fieldReader, Object object, Object name, JSONPath reference) {
            this.fieldReader = fieldReader;
            this.object = object;
            this.name = name;
            this.reference = reference;
        }

        public String toString() {
            return this.reference.toString();
        }
    }

    public static enum Feature {
        FieldBased(1L),
        IgnoreNoneSerializable(2L),
        SupportArrayToBean(4L),
        InitStringFieldAsEmpty(8L),
        SupportAutoType(16L),
        SupportSmartMatch(32L),
        UseNativeObject(64L),
        SupportClassForName(128L),
        IgnoreSetNullValue(256L),
        UseDefaultConstructorAsPossible(512L),
        UseBigDecimalForFloats(1024L),
        UseBigDecimalForDoubles(2048L),
        ErrorOnEnumNotMatch(4096L);

        public final long mask;

        private Feature(long mask) {
            this.mask = mask;
        }
    }

    public static interface AutoTypeBeforeHandler
    extends Filter {
        public Class<?> apply(String var1, Class<?> var2, long var3);
    }

    public static interface Filter {
    }
}

