/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectArrayReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

final class ObjectArrayTypedReader
extends ObjectReaderBaseModule.PrimitiveImpl {
    final Class objectClass;
    final Class componentType;
    final Class componentClass;
    final long componentClassHash;
    ObjectReader itemObjectReader = null;
    final String typeName;
    final long typeNameHashCode;

    ObjectArrayTypedReader(Class objectClass) {
        this.objectClass = objectClass;
        this.componentType = objectClass.getComponentType();
        String componentTypeName = TypeUtils.getTypeName(this.componentType);
        this.componentClassHash = Fnv.hashCode64(componentTypeName);
        this.typeName = '[' + componentTypeName;
        this.typeNameHashCode = Fnv.hashCode64(this.typeName);
        this.componentClass = TypeUtils.getClass(this.componentType);
    }

    @Override
    public Object readObject(JSONReader jsonReader, long features) {
        String str;
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, 0L);
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.nextIfMatch('[')) {
            Object[] values2 = (Object[])Array.newInstance(this.componentType, 16);
            int size = 0;
            while (!jsonReader.nextIfMatch(']')) {
                int minCapacity = size + 1;
                if (minCapacity - values2.length > 0) {
                    int oldCapacity = values2.length;
                    int newCapacity = oldCapacity + (oldCapacity >> 1);
                    if (newCapacity - minCapacity < 0) {
                        newCapacity = minCapacity;
                    }
                    values2 = Arrays.copyOf(values2, newCapacity);
                }
                Object value = jsonReader.read(this.componentType);
                values2[size++] = value;
                jsonReader.nextIfMatch(',');
            }
            jsonReader.nextIfMatch(',');
            return Arrays.copyOf(values2, size);
        }
        if (jsonReader.current() == '\"' && (str = jsonReader.readString()).isEmpty()) {
            return null;
        }
        throw new JSONException("TODO");
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, long features) {
        int entryCnt;
        if (jsonReader.getType() == -110) {
            jsonReader.next();
            long typeHash = jsonReader.readTypeHashCode();
            if (typeHash != ObjectArrayReader.TYPE_HASH_CODE && typeHash != this.typeNameHashCode) {
                JSONReader.Context context = jsonReader.getContext();
                if (jsonReader.isSupportAutoType(features)) {
                    ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                    if (autoTypeObjectReader == null) {
                        String typeName = jsonReader.getString();
                        autoTypeObjectReader = context.getObjectReaderAutoType(typeName, this.objectClass, features);
                    }
                    if (autoTypeObjectReader == null) {
                        throw new JSONException("auotype not support : " + jsonReader.getString());
                    }
                    return autoTypeObjectReader.readObject(jsonReader, features);
                }
                throw new JSONException("not support autotype : " + jsonReader.getString());
            }
        }
        if ((entryCnt = jsonReader.startArray()) == -1) {
            return null;
        }
        Object[] values2 = (Object[])Array.newInstance(this.componentClass, entryCnt);
        for (int i = 0; i < entryCnt; ++i) {
            Object value;
            if (jsonReader.isReference()) {
                String reference = jsonReader.readReference();
                if ("..".equals(reference)) {
                    value = values2;
                } else {
                    value = null;
                    jsonReader.addResolveTask(values2, i, JSONPath.of(reference));
                }
            } else {
                ObjectReader autoTypeReader = jsonReader.checkAutoType(this.componentClass, this.componentClassHash, features);
                value = autoTypeReader != null ? autoTypeReader.readJSONBObject(jsonReader, features) : jsonReader.read(this.componentType);
            }
            values2[i] = value;
        }
        return values2;
    }

    @Override
    public Object createInstance(Collection collection) {
        Object[] values2 = (Object[])Array.newInstance(this.componentClass, collection.size());
        int index = 0;
        for (Object item : collection) {
            ObjectReaderProvider provider;
            Function typeConvert;
            Class<?> valueClass;
            if (item != null && (valueClass = item.getClass()) != this.componentType && (typeConvert = (provider = JSONFactory.getDefaultObjectReaderProvider()).getTypeConvert(valueClass, this.componentType)) != null) {
                item = typeConvert.apply(item);
            }
            if (this.componentType.isInstance(item)) {
                values2[index++] = item;
                continue;
            }
            ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(this.componentType);
            if (item instanceof Map) {
                item = objectReader.createInstance((Map)item, new JSONReader.Feature[0]);
            } else if (item != null) {
                throw new JSONException("component type not match, expect " + this.componentType.getName() + ", but " + item.getClass());
            }
            values2[index++] = item;
        }
        return values2;
    }
}

