/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.util.function.Function;

public abstract class ObjectReaderBean<T>
implements ObjectReader<T> {
    protected final Class objectClass;
    protected final String typeName;
    protected final long typeNameHash;
    protected FieldReader extraFieldReader = null;
    protected boolean hasDefaultValue;
    protected final JSONSchema schema;

    protected ObjectReaderBean(Class objectClass, String typeName) {
        this(objectClass, typeName, null);
    }

    protected ObjectReaderBean(Class objectClass, String typeName, JSONSchema schema) {
        if (typeName == null && objectClass != null) {
            typeName = TypeUtils.getTypeName(objectClass);
        }
        this.objectClass = objectClass;
        this.typeName = typeName;
        this.typeNameHash = typeName != null ? Fnv.hashCode64(typeName) : 0L;
        this.schema = schema;
    }

    @Override
    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    protected void processExtra(JSONReader jsonReader, Object object) {
        if (this.extraFieldReader == null || object == null) {
            jsonReader.skipValue();
            return;
        }
        this.extraFieldReader.processExtra(jsonReader, object);
    }

    public ObjectReader checkAutoType(JSONReader jsonReader, Class listClass, long features) {
        ObjectReader autoTypeObjectReader = null;
        if (jsonReader.nextIfMatch((byte)-110)) {
            boolean isSupportAutoType;
            long typeHash = jsonReader.readTypeHashCode();
            JSONReader.Context context = jsonReader.getContext();
            autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
            if (autoTypeObjectReader == null) {
                String typeName = jsonReader.getString();
                autoTypeObjectReader = context.getObjectReaderAutoType(typeName, listClass, features);
            }
            if (autoTypeObjectReader == null) {
                throw new JSONException("auotype not support : " + jsonReader.getString());
            }
            if (typeHash == this.typeNameHash) {
                return this;
            }
            boolean bl = isSupportAutoType = ((context.getFeatures() | features) & JSONReader.Feature.SupportAutoType.mask) != 0L;
            if (!isSupportAutoType) {
                return null;
            }
        }
        return autoTypeObjectReader;
    }

    protected void initDefaultValue(T object) {
    }

    @Override
    public T readObject(JSONReader jsonReader, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, features);
        }
        if (jsonReader.nextIfNull()) {
            jsonReader.nextIfMatch(',');
            return null;
        }
        if (jsonReader.isArray() && jsonReader.isSupportBeanArray(this.getFeatures() | features)) {
            return this.readArrayMappingObject(jsonReader);
        }
        Object object = null;
        jsonReader.nextIfMatch('{');
        int i = 0;
        while (true) {
            long features3;
            if (jsonReader.nextIfMatch('}')) {
                if (object != null) break;
                object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                break;
            }
            long hash = jsonReader.readFieldNameHashCode();
            if (hash == this.getTypeKeyHash() && i == 0 && ((features3 = features | this.getFeatures() | jsonReader.getContext().getFeatures()) & JSONReader.Feature.SupportAutoType.mask) != 0L) {
                long typeHash = jsonReader.readTypeHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader reader = this.autoType(context, typeHash);
                String typeName = null;
                if (reader == null && (reader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.getObjectClass(), features3)) == null) {
                    throw new JSONException("No suitable ObjectReader found for" + typeName);
                }
                if (reader != this) {
                    FieldReader fieldReader = reader.getFieldReader(hash);
                    if (fieldReader != null && typeName == null) {
                        typeName = jsonReader.getString();
                    }
                    object = reader.readObject(jsonReader, features | this.getFeatures());
                    if (fieldReader != null) {
                        fieldReader.accept(object, typeName);
                    }
                    return object;
                }
            } else {
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.getFeatures())) {
                    long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (object == null) {
                    object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                }
                if (fieldReader == null) {
                    if (this instanceof ObjectReaderBean) {
                        this.processExtra(jsonReader, object);
                    } else {
                        jsonReader.skipValue();
                    }
                } else {
                    fieldReader.readFieldValue(jsonReader, object);
                }
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        Function buildFunction = this.getBuildFunction();
        if (buildFunction != null) {
            object = buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }
}

