/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

class ObjectReaderImplDoubleValueArray
extends ObjectReaderBaseModule.PrimitiveImpl {
    static final ObjectReaderImplDoubleValueArray INSTANCE = new ObjectReaderImplDoubleValueArray();

    ObjectReaderImplDoubleValueArray() {
    }

    @Override
    public Object readObject(JSONReader jsonReader, long features) {
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.nextIfMatch('[')) {
            double[] values2 = new double[16];
            int size = 0;
            while (!jsonReader.nextIfMatch(']')) {
                int minCapacity = size + 1;
                if (minCapacity - values2.length > 0) {
                    int oldCapacity = values2.length;
                    int newCapacity = oldCapacity + (oldCapacity >> 1);
                    if (newCapacity - minCapacity < 0) {
                        newCapacity = minCapacity;
                    }
                    values2 = Arrays.copyOf(values2, newCapacity);
                }
                values2[size++] = jsonReader.readDoubleValue();
            }
            jsonReader.nextIfMatch(',');
            return Arrays.copyOf(values2, size);
        }
        throw new JSONException("TODO");
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, long features) {
        int entryCnt = jsonReader.startArray();
        if (entryCnt == -1) {
            return null;
        }
        double[] array = new double[entryCnt];
        for (int i = 0; i < entryCnt; ++i) {
            array[i] = jsonReader.readDoubleValue();
        }
        return array;
    }

    @Override
    public Object createInstance(Collection collection) {
        double[] array = new double[collection.size()];
        int i = 0;
        for (Object item : collection) {
            double value;
            if (item == null) {
                value = 0.0;
            } else if (item instanceof Number) {
                value = ((Number)item).doubleValue();
            } else {
                Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(item.getClass(), Double.TYPE);
                if (typeConvert == null) {
                    throw new JSONException("can not cast to double " + item.getClass());
                }
                value = (Double)typeConvert.apply(item);
            }
            array[i++] = value;
        }
        return array;
    }
}

