/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import java.util.Arrays;

abstract class FieldWriterEnum
extends FieldWriterImpl {
    volatile byte[][] valueNameCacheUTF8;
    volatile char[][] valueNameCacheUTF16;
    final Class enumType;
    final Enum[] enumConstants;
    final long[] hashCodes;

    protected FieldWriterEnum(String name, int ordinal, long features, String format, Class<? extends Enum> enumType) {
        super(name, ordinal, features, format, enumType, enumType);
        this.enumType = enumType;
        this.enumConstants = enumType.getEnumConstants();
        this.hashCodes = new long[this.enumConstants.length];
        for (int i = 0; i < this.enumConstants.length; ++i) {
            this.hashCodes[i] = Fnv.hashCode64(this.enumConstants[i].name());
        }
    }

    @Override
    public final void writeEnumJSONB(JSONWriter jsonWriter, Enum e) {
        int namingOrdinal;
        if (e == null) {
            return;
        }
        long features = this.features | jsonWriter.getFeatures();
        boolean usingOrdinal = (features & (JSONWriter.Feature.WriteEnumUsingToString.mask | JSONWriter.Feature.WriteEnumsUsingName.mask)) == 0L;
        boolean usingToString = (features & JSONWriter.Feature.WriteEnumUsingToString.mask) != 0L;
        int ordinal = e.ordinal();
        JSONB.SymbolTable symbolTable = jsonWriter.getSymbolTable();
        if (symbolTable != null && usingOrdinal && !usingToString && (namingOrdinal = symbolTable.getOrdinalByHashCode(this.hashCodes[ordinal])) >= 0) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeRaw((byte)121);
            jsonWriter.writeInt32(-namingOrdinal);
            return;
        }
        if (usingToString) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeString(e.toString());
            return;
        }
        if (usingOrdinal) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeInt32(e.ordinal());
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeString(e.name());
    }

    @Override
    public final void writeEnum(JSONWriter jsonWriter, Enum e) {
        boolean usingOrdinal;
        long features = jsonWriter.getFeatures();
        boolean bl = usingOrdinal = (features & (JSONWriter.Feature.WriteEnumUsingToString.mask | JSONWriter.Feature.WriteEnumsUsingName.mask)) == 0L;
        if ((features & JSONWriter.Feature.WriteEnumUsingToString.mask) != 0L) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeString(e.toString());
            return;
        }
        if (usingOrdinal) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeInt32(e.ordinal());
            return;
        }
        if (jsonWriter.isUTF8()) {
            int ordinal = e.ordinal();
            byte[] bytes = null;
            if (this.valueNameCacheUTF8 == null) {
                this.valueNameCacheUTF8 = new byte[this.enumConstants.length][];
            } else {
                bytes = this.valueNameCacheUTF8[ordinal];
            }
            if (bytes == null) {
                String name = this.enumConstants[ordinal].name();
                bytes = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + name.length() + 2);
                bytes[this.nameWithColonUTF8.length] = 34;
                name.getBytes(0, name.length(), bytes, this.nameWithColonUTF8.length + 1);
                bytes[bytes.length - 1] = 34;
                this.valueNameCacheUTF8[ordinal] = bytes;
            }
            jsonWriter.writeNameRaw(bytes);
            return;
        }
        if (jsonWriter.isUTF16()) {
            int ordinal = e.ordinal();
            char[] chars = null;
            if (this.valueNameCacheUTF16 == null) {
                this.valueNameCacheUTF16 = new char[this.enumConstants.length][];
            } else {
                chars = this.valueNameCacheUTF16[ordinal];
            }
            if (chars == null) {
                String name = this.enumConstants[ordinal].name();
                chars = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + name.length() + 2);
                chars[this.nameWithColonUTF16.length] = 34;
                name.getChars(0, name.length(), chars, this.nameWithColonUTF16.length + 1);
                chars[chars.length - 1] = 34;
                this.valueNameCacheUTF16[ordinal] = chars;
            }
            jsonWriter.writeNameRaw(chars);
            return;
        }
        if (jsonWriter.isJSONB()) {
            this.writeEnumJSONB(jsonWriter, e);
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeString(e.name());
    }
}

