/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.cloud.config;

import com.lframework.starter.cloud.components.DefaultErrorDecoder;
import com.lframework.starter.cloud.interceptors.FeignRequestInterceptor;
import feign.Retryer;
import feign.codec.ErrorDecoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignFormatterRegistrar;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class CloudAutoConfiguration {
    @Autowired
    private ObjectFactory<HttpMessageConverters> messageConverters;

    @Bean
    public Retryer retryer() {
        return Retryer.NEVER_RETRY;
    }

    @Bean
    public FeignFormatterRegistrar localDateTimeFormatRegister() {
        return registry -> registry.addConverter((Converter)new Converter<LocalDateTime, String>(){

            public String convert(LocalDateTime source) {
                return source.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
        });
    }

    @Bean
    public FeignFormatterRegistrar localDateFormatRegister() {
        return registry -> registry.addConverter((Converter)new Converter<LocalDate, String>(){

            public String convert(LocalDate source) {
                return source.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            }
        });
    }

    @Bean
    public FeignFormatterRegistrar localTimeFormatRegister() {
        return registry -> registry.addConverter((Converter)new Converter<LocalTime, String>(){

            public String convert(LocalTime source) {
                return source.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
            }
        });
    }

    @Bean
    public ErrorDecoder errorDecoder() {
        return new DefaultErrorDecoder();
    }

    @Bean
    public FeignRequestInterceptor feignRequestInterceptor() {
        return new FeignRequestInterceptor();
    }
}

