/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.api;

import com.alibaba.dchain.api.ClientConfig;
import com.alibaba.dchain.api.spi.Invocation;
import com.alibaba.dchain.api.spi.InvokeFilter;
import com.alibaba.dchain.inner.exception.OpenApiException;
import com.alibaba.dchain.inner.extension.FilterBuilder;
import com.alibaba.dchain.inner.invoker.InvokerFactory;
import com.alibaba.dchain.inner.invoker.OpenApiInvoker;
import com.alibaba.dchain.inner.model.OpenApiRequest;
import com.alibaba.dchain.inner.model.OpenApiResponse;
import com.alibaba.dchain.inner.utils.CollectionUtil;
import java.util.List;

public class OpenApiClient {
    private final OpenApiInvoker openApiInvoker;
    private final ClientConfig clientConfig;

    public OpenApiClient(ClientConfig config) throws OpenApiException {
        this.clientConfig = InvokerFactory.clone(config);
        OpenApiInvoker realInvoker = InvokerFactory.build(config);
        List<InvokeFilter> filterList = FilterBuilder.getInvokeFilterList();
        this.openApiInvoker = CollectionUtil.isNotEmpty(filterList) ? FilterBuilder.buildInvokerChain(realInvoker, filterList) : realInvoker;
    }

    public <T extends OpenApiResponse> T execute(OpenApiRequest<T> request) throws OpenApiException {
        request.validate();
        Invocation<T> invocation = new Invocation<T>(request, InvokerFactory.clone(this.clientConfig));
        return this.openApiInvoker.invoke(invocation);
    }
}

