/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.inner.converter;

import com.alibaba.dchain.inner.annotation.NameMapping;
import com.alibaba.dchain.inner.exception.ErrorEnum;
import com.alibaba.dchain.inner.exception.OpenApiException;
import com.alibaba.dchain.inner.model.Model;
import com.alibaba.dchain.inner.shaded.com.google.gson.Gson;
import com.alibaba.dchain.inner.utils.Assert;
import com.alibaba.dchain.inner.utils.MapUtil;
import com.alibaba.dchain.inner.utils.ReflectUtil;
import com.alibaba.dchain.inner.utils.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ModelConverter {
    private static final String TRUE = "1";
    private static final String FALSE = "0";

    public static Object parseObject(Object object) throws OpenApiException {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)object;
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                result.put((String)entry.getKey(), ModelConverter.parseObject(entry.getValue()));
            }
            return result;
        }
        if (List.class.isAssignableFrom(clazz)) {
            List list = (List)object;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object obj : list) {
                result.add(ModelConverter.parseObject(obj));
            }
            return result;
        }
        if (Model.class.isAssignableFrom(clazz)) {
            return ModelConverter.changeToMap((Model)object);
        }
        return object;
    }

    public static Map<String, String> parseMapToMapString(Map<String, Object> map) throws OpenApiException {
        if (MapUtil.isEmpty(map)) {
            return new HashMap<String, String>(16);
        }
        HashMap<String, Object> parsedMap = new HashMap<String, Object>(16);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            parsedMap.put(entry.getKey(), ModelConverter.parseObject(entry.getValue()));
        }
        return ModelConverter.objectToStringInMap(parsedMap);
    }

    public static <T extends Model> T toModel(Map<String, ?> map, T model) throws OpenApiException {
        for (Field field : ReflectUtil.getAllField(model.getClass())) {
            String fieldName = ModelConverter.getMappingFieldName(field);
            Object value = map.get(fieldName);
            if (value == null) continue;
            ModelConverter.setField(model, field, value);
        }
        return model;
    }

    private static <T> void setField(T model, Field field, Object value) throws OpenApiException {
        try {
            Class<?> fieldCls = field.getType();
            Class<?> valueCls = value.getClass();
            if (Model.class.isAssignableFrom(fieldCls)) {
                if (Map.class.isAssignableFrom(valueCls)) {
                    Model fieldModel = (Model)fieldCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    ModelConverter.setFieldValue(field, model, ModelConverter.toModel((Map)ModelConverter.cast(value), fieldModel));
                } else {
                    ModelConverter.setFieldValue(field, model, value);
                }
            } else if (ModelConverter.isCollectionOrMapType(fieldCls)) {
                ModelConverter.setFieldValue(field, model, ModelConverter.convertToCollectionOrMapType(value, (ParameterizedType)field.getGenericType()));
            } else if (ModelConverter.isPrimitive(fieldCls)) {
                ModelConverter.setFieldValue(field, model, ModelConverter.processPrimitiveType(fieldCls, value));
            } else if (fieldCls.isInstance(value)) {
                ModelConverter.setFieldValue(field, model, value);
            }
        }
        catch (Exception e) {
            throw new OpenApiException(ErrorEnum.SET_FIELD_ERROR, (Throwable)e);
        }
    }

    private static Object convertClass(Object value, Class clazz) throws OpenApiException {
        Class<?> valueCls = value.getClass();
        if (Model.class.isAssignableFrom(clazz) && Map.class.isAssignableFrom(valueCls)) {
            try {
                return ModelConverter.toModel((Map)ModelConverter.cast(value), (Model)clazz.newInstance());
            }
            catch (Exception e) {
                throw new OpenApiException(ErrorEnum.INIT_MODEL_ERROR, (Throwable)e);
            }
        }
        return value;
    }

    private static Object convertParameterizedType(Object value, ParameterizedType type) throws OpenApiException {
        Class rawType = (Class)type.getRawType();
        if (ModelConverter.isCollectionOrMapType(rawType)) {
            return ModelConverter.convertToCollectionOrMapType(value, type);
        }
        return ModelConverter.convertClass(value, rawType);
    }

    private static Object convertToCollectionOrMapType(Object value, ParameterizedType type) throws OpenApiException {
        Class rawType = (Class)type.getRawType();
        if (Map.class.isAssignableFrom(rawType)) {
            return ModelConverter.convertToMapType(value, type);
        }
        if (List.class.isAssignableFrom(rawType)) {
            return ModelConverter.convertToListType(value, type);
        }
        throw new OpenApiException(ErrorEnum.FIELD_TYPE_NOT_SUPPORT);
    }

    private static Map<String, Object> convertToMapType(Object value, ParameterizedType type) throws OpenApiException {
        Type[] actualTypeArguments = type.getActualTypeArguments();
        Assert.assertEquals(actualTypeArguments[0].getTypeName(), "java.lang.String", ErrorEnum.FIELD_TYPE_NOT_SUPPORT);
        Type mapValueType = actualTypeArguments[1];
        Map valueMap = (Map)ModelConverter.cast(value);
        HashMap<String, Object> result = new HashMap<String, Object>(valueMap.size());
        for (Map.Entry entry : valueMap.entrySet()) {
            if (mapValueType == null || mapValueType instanceof WildcardType) {
                result.put((String)entry.getKey(), entry.getValue());
                continue;
            }
            if (mapValueType instanceof Class) {
                result.put((String)entry.getKey(), ModelConverter.convertClass(entry.getValue(), (Class)mapValueType));
                continue;
            }
            if (mapValueType instanceof ParameterizedType) {
                result.put((String)entry.getKey(), ModelConverter.convertParameterizedType(entry.getValue(), (ParameterizedType)mapValueType));
                continue;
            }
            throw new OpenApiException(ErrorEnum.FIELD_TYPE_NOT_SUPPORT);
        }
        return result;
    }

    private static List<Object> convertToListType(Object value, ParameterizedType type) throws OpenApiException {
        Type[] actualTypeArguments = type.getActualTypeArguments();
        Type listValueType = actualTypeArguments[0];
        List valueMap = (List)ModelConverter.cast(value);
        ArrayList<Object> result = new ArrayList<Object>(valueMap.size());
        for (Object element : valueMap) {
            if (listValueType == null || listValueType instanceof WildcardType) {
                result.add(element);
                continue;
            }
            if (listValueType instanceof Class) {
                result.add(ModelConverter.convertClass(element, (Class)listValueType));
                continue;
            }
            if (listValueType instanceof ParameterizedType) {
                result.add(ModelConverter.convertParameterizedType(element, (ParameterizedType)listValueType));
                continue;
            }
            throw new OpenApiException(ErrorEnum.FIELD_TYPE_NOT_SUPPORT);
        }
        return result;
    }

    private static Object processPrimitiveType(Class expect, Object object) throws Exception {
        if (String.class.isAssignableFrom(expect)) {
            if (object instanceof Number || object instanceof Boolean) {
                return object.toString();
            }
        } else if (Boolean.class.isAssignableFrom(expect)) {
            if (object instanceof String) {
                return Boolean.parseBoolean(String.valueOf(object));
            }
            if (object instanceof Integer) {
                if (object.toString().equals(TRUE)) {
                    return true;
                }
                if (object.toString().equals(FALSE)) {
                    return false;
                }
            }
        } else if (Integer.class.isAssignableFrom(expect)) {
            if (object instanceof String) {
                return Integer.parseInt(object.toString());
            }
            if (object instanceof Long && (Long)object <= Integer.MAX_VALUE) {
                return Integer.parseInt(object.toString());
            }
            if (object instanceof Double && (Double)object <= 2.147483647E9) {
                return new BigDecimal(object.toString()).intValue();
            }
        } else if (Long.class.isAssignableFrom(expect)) {
            if (object instanceof String || object instanceof Integer) {
                return Long.parseLong(object.toString());
            }
            if (object instanceof Double) {
                return new BigDecimal(object.toString()).longValue();
            }
        } else if (Float.class.isAssignableFrom(expect)) {
            if (object instanceof String || object instanceof Integer || object instanceof Long) {
                return Float.valueOf(Float.parseFloat(object.toString()));
            }
            if (object instanceof Double && (Double)object <= 3.4028234663852886E38) {
                return Float.valueOf(new BigDecimal(object.toString()).floatValue());
            }
        } else if (Double.class.isAssignableFrom(expect) && (object instanceof String || object instanceof Integer || object instanceof Long || object instanceof Float)) {
            return Double.parseDouble(object.toString());
        }
        return object;
    }

    private static boolean isCollectionOrMapType(Class clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private static void setFieldValue(Field field, Object object, Object value) throws IllegalAccessException {
        if (field.isAccessible()) {
            field.set(object, value);
            return;
        }
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        finally {
            field.setAccessible(false);
        }
    }

    private static Map<String, String> objectToStringInMap(Map<String, Object> map) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof String) {
                result.put(entry.getKey(), (String)entry.getValue());
                continue;
            }
            result.put(entry.getKey(), new Gson().toJson(entry.getValue()));
        }
        return result;
    }

    private static Map<String, Object> changeToMap(Model model) throws OpenApiException {
        Class<?> clazz = model.getClass();
        List<Field> fields = ReflectUtil.getAllField(clazz);
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        try {
            for (Field field : fields) {
                String fieldName = ModelConverter.getMappingFieldName(field);
                Object fieldObj = ModelConverter.getFieldValue(field, model);
                if (fieldObj == null) continue;
                result.put(fieldName, ModelConverter.parseObject(fieldObj));
            }
        }
        catch (Exception e) {
            throw new OpenApiException(ErrorEnum.PARSE_OBJECT_TO_MAP_ERROR, (Throwable)e);
        }
        return result;
    }

    private static Object getFieldValue(Field field, Object object) throws IllegalAccessException {
        if (field.isAccessible()) {
            return field.get(object);
        }
        field.setAccessible(true);
        try {
            Object object2 = field.get(object);
            return object2;
        }
        finally {
            field.setAccessible(false);
        }
    }

    private static String getMappingFieldName(Field field) {
        NameMapping annotation = field.getAnnotation(NameMapping.class);
        if (annotation == null || StringUtil.isEmpty(annotation.value())) {
            return field.getName();
        }
        return annotation.value();
    }

    private static boolean isInteger(Class cls) {
        return cls == Integer.class || cls == Integer.TYPE || cls == Byte.class || cls == Byte.TYPE || cls == Short.class || cls == Short.TYPE || cls == Long.class || cls == Long.TYPE;
    }

    private static boolean isFloat(Class cls) {
        return cls == Float.class || cls == Float.TYPE || cls == Double.class || cls == Double.TYPE;
    }

    private static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls == String.class || cls == Boolean.class || cls == Character.class || Number.class.isAssignableFrom(cls);
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }
}

