/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.inner.extension;

import com.alibaba.dchain.inner.exception.ErrorEnum;
import com.alibaba.dchain.inner.exception.OpenApiException;
import com.alibaba.dchain.inner.utils.MapUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;

public class ExtensionLoader<T> {
    private Map<String, Class<?>> cachedClasses;
    private final Map<String, T> cachedInstances = new LinkedHashMap<String, T>();
    private final Class<T> type;
    private final ClassLoader classLoader;
    private static final String PREFIX = "META-INF/services/";

    public ExtensionLoader(Class<T> type) {
        this.type = type;
        this.classLoader = ExtensionLoader.class.getClassLoader();
    }

    public ExtensionLoader(Class<T> type, ClassLoader classLoader) {
        this.type = type;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getExtensionObject() throws OpenApiException {
        Map<String, Class<?>> extensionClasses = this.getExtensionClasses();
        if (MapUtil.isEmpty(extensionClasses)) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Map.Entry<String, Class<?>> entry : extensionClasses.entrySet()) {
            if (this.cachedInstances.get(entry.getKey()) == null) {
                ExtensionLoader extensionLoader = this;
                synchronized (extensionLoader) {
                    if (this.cachedInstances.get(entry.getKey()) == null) {
                        T instance = this.newInstance(entry.getValue());
                        this.cachedInstances.put(entry.getKey(), instance);
                    }
                }
            }
            result.add(this.cachedInstances.get(entry.getKey()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> getExtensionClasses() throws OpenApiException {
        if (this.cachedClasses == null) {
            ExtensionLoader extensionLoader = this;
            synchronized (extensionLoader) {
                if (this.cachedClasses == null) {
                    this.cachedClasses = this.loadExtensionClasses();
                }
            }
        }
        return new LinkedHashMap(this.cachedClasses);
    }

    private <T> T newInstance(Class<?> cls) throws OpenApiException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cls.getClassLoader());
            Object obj = cls.newInstance();
            return (T)obj;
        }
        catch (Exception ex) {
            throw new OpenApiException(ErrorEnum.INSTANTIATE_INSTANCE_ERROR, (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private Map<String, Class<?>> loadExtensionClasses() throws OpenApiException {
        String fullName = PREFIX + this.type.getName();
        LinkedHashMap extensionClasses = new LinkedHashMap(8);
        try {
            Enumeration<URL> resources = this.classLoader.getResources(fullName);
            while (resources.hasMoreElements()) {
                Iterator<String> classNamesIterator = this.parse(this.type, resources.nextElement(), extensionClasses);
                while (classNamesIterator.hasNext()) {
                    String className = classNamesIterator.next();
                    Class<?> cls = null;
                    try {
                        cls = Class.forName(className, false, this.classLoader);
                    }
                    catch (ClassNotFoundException x) {
                        this.fail(this.type, "Provider " + className + " not found");
                    }
                    if (!this.type.isAssignableFrom(cls)) {
                        this.fail(this.type, "Provider " + className + " not a subtype");
                    }
                    extensionClasses.put(className, cls);
                }
            }
        }
        catch (Exception e) {
            throw new OpenApiException(ErrorEnum.LOAD_SPI_ERROR, (Throwable)e);
        }
        return extensionClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<String> parse(Class<?> service, URL u, Map<String, Class<?>> extensionClasses) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = this.parseLine(service, u, r, lc, names, extensionClasses)) >= 0) {
            }
        }
        catch (IOException x) {
            this.fail(service, "Error reading configuration file", x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                this.fail(service, "Error closing configuration file", y);
            }
        }
        return names.iterator();
    }

    private int parseLine(Class<?> service, URL u, BufferedReader r, int lc, List<String> names, Map<String, Class<?>> extensionClasses) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                this.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                this.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                this.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!extensionClasses.containsKey(ln) && !names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    private void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
        this.fail(service, u + ":" + line + ": " + msg);
    }
}

