/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.inner.invoker;

import com.alibaba.dchain.api.pop.PopClientConfig;
import com.alibaba.dchain.api.spi.Invocation;
import com.alibaba.dchain.inner.converter.PopRequestConverter;
import com.alibaba.dchain.inner.converter.PopResponseConverter;
import com.alibaba.dchain.inner.enums.BodyTypeEnum;
import com.alibaba.dchain.inner.enums.GatewayTypeEnum;
import com.alibaba.dchain.inner.enums.SystemHeaderEnum;
import com.alibaba.dchain.inner.exception.ErrorEnum;
import com.alibaba.dchain.inner.exception.OpenApiException;
import com.alibaba.dchain.inner.invoker.OpenApiInvoker;
import com.alibaba.dchain.inner.model.BasePopRequest;
import com.alibaba.dchain.inner.model.FileUploadRequest;
import com.alibaba.dchain.inner.model.OpenApiResponse;
import com.alibaba.dchain.inner.model.extend.IsvGatewayAuthorizedFileUploadRequest;
import com.alibaba.dchain.inner.model.extend.IsvGatewayAuthorizedFileUploadResponse;
import com.alibaba.dchain.inner.shaded.com.aliyun.fileform.models.FileField;
import com.alibaba.dchain.inner.shaded.com.aliyun.oss.Client;
import com.alibaba.dchain.inner.shaded.com.aliyun.oss.models.Config;
import com.alibaba.dchain.inner.shaded.com.aliyun.oss.models.PostObjectRequest;
import com.alibaba.dchain.inner.shaded.com.aliyun.tea.TeaException;
import com.alibaba.dchain.inner.shaded.com.aliyun.tea.TeaUnretryableException;
import com.alibaba.dchain.inner.shaded.com.aliyun.teaopenapi.models.OpenApiRequest;
import com.alibaba.dchain.inner.shaded.com.aliyun.teautil.models.RuntimeOptions;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class PopInvoker
implements OpenApiInvoker {
    private final com.alibaba.dchain.inner.shaded.com.aliyun.teaopenapi.Client client;

    public PopInvoker(PopClientConfig popClientConfig) throws OpenApiException {
        com.alibaba.dchain.inner.shaded.com.aliyun.teaopenapi.models.Config popConfig = new com.alibaba.dchain.inner.shaded.com.aliyun.teaopenapi.models.Config();
        popConfig.setEndpoint(popClientConfig.getEndpoint());
        popConfig.setRegionId(popClientConfig.getRegionId());
        popConfig.setAccessKeyId(popClientConfig.getAccessKeyId());
        popConfig.setAccessKeySecret(popClientConfig.getAccessKeySecret());
        popConfig.setReadTimeout(popClientConfig.getReadTimeout());
        popConfig.setConnectTimeout(popClientConfig.getConnectTimeout());
        try {
            this.client = new com.alibaba.dchain.inner.shaded.com.aliyun.teaopenapi.Client(popConfig);
        }
        catch (Exception e) {
            throw new OpenApiException(ErrorEnum.INIT_POP_CLIENT_ERROR, (Throwable)e);
        }
    }

    @Override
    public <T extends OpenApiResponse> T invoke(Invocation<T> invocation) throws OpenApiException {
        com.alibaba.dchain.inner.model.OpenApiRequest<T> request = invocation.getOpenApiRequest();
        if (!(request instanceof BasePopRequest)) {
            throw new OpenApiException(ErrorEnum.REQUEST_NOT_POP_REQUEST);
        }
        if (request instanceof FileUploadRequest) {
            return this.invokeFileApi(invocation);
        }
        return this.invokeInner(invocation);
    }

    private <T extends OpenApiResponse> T invokeInner(Invocation<T> invocation) throws OpenApiException {
        com.alibaba.dchain.inner.model.OpenApiRequest<T> request = invocation.getOpenApiRequest();
        BasePopRequest.PopApiInfo popApiInfo = ((BasePopRequest)request).findPopApiInfo();
        OpenApiRequest openApiRequest = PopRequestConverter.toPopRequest(request);
        Map<String, String> headers = openApiRequest.getHeaders();
        headers.put(SystemHeaderEnum.PRODUCT_CODE.getCode(), popApiInfo.getProductCode());
        headers.put(SystemHeaderEnum.DCHAIN_PRODUCT_CODE.getCode(), popApiInfo.getDchainApiCode());
        headers.put(SystemHeaderEnum.GATEWAY_TYPE.getCode(), GatewayTypeEnum.POP.name());
        PopClientConfig config = (PopClientConfig)invocation.getClientConfig();
        headers.put(SystemHeaderEnum.ENDPOINT.getCode(), config.getEndpoint());
        headers.put(SystemHeaderEnum.DCHAIN_API_CODE.getCode(), popApiInfo.getDchainApiCode());
        try {
            Map<String, ?> resultMap = this.callApi(popApiInfo, openApiRequest);
            return PopResponseConverter.toOpenApiResponse(resultMap, request.getResponseClass());
        }
        catch (Exception e) {
            if (e instanceof TeaException) {
                TeaException teaException = (TeaException)e;
                throw new OpenApiException(teaException.getCode(), teaException.getMessage(), teaException.getData(), teaException.getCause());
            }
            if (e instanceof TeaUnretryableException) {
                TeaUnretryableException teaException = (TeaUnretryableException)e;
                throw new OpenApiException(teaException.getLastRequest() != null ? teaException.getLastRequest().toString() : teaException.getMessage(), teaException.getCause());
            }
            throw new OpenApiException(e);
        }
    }

    private <T extends OpenApiResponse> T invokeFileApi(Invocation<T> invocation) throws OpenApiException {
        Client ossClient;
        com.alibaba.dchain.inner.model.OpenApiRequest<T> request = invocation.getOpenApiRequest();
        BasePopRequest.PopApiInfo popApiInfo = ((BasePopRequest)request).findPopApiInfo();
        FileUploadRequest fileUploadRequest = (FileUploadRequest)request;
        FileUploadRequest.PopFileUploadInfo popFileUploadInfo = fileUploadRequest.findPopFileUploadInfo();
        PopClientConfig popClientConfig = (PopClientConfig)invocation.getClientConfig();
        IsvGatewayAuthorizedFileUploadRequest authRequest = new IsvGatewayAuthorizedFileUploadRequest();
        IsvGatewayAuthorizedFileUploadRequest.Request authSubRequest = new IsvGatewayAuthorizedFileUploadRequest.Request();
        authRequest.setRequest(authSubRequest);
        authSubRequest.setApiCode(popApiInfo.getDchainApiCode());
        authSubRequest.setUserId(popFileUploadInfo.getUserId());
        Invocation<IsvGatewayAuthorizedFileUploadResponse> authInvocation = new Invocation<IsvGatewayAuthorizedFileUploadResponse>(authRequest, invocation.getClientConfig());
        IsvGatewayAuthorizedFileUploadResponse authResponse = this.invokeInner(authInvocation);
        IsvGatewayAuthorizedFileUploadResponse.IsvGatewayAuthorizedFileUploadResponseBody.Result result = authResponse.getBody().getResult();
        Config ossConfig = new Config();
        ossConfig.setAccessKeyId(popClientConfig.getAccessKeyId());
        ossConfig.setAccessKeySecret(popClientConfig.getAccessKeySecret());
        ossConfig.setRegionId(result.getRegionId());
        ossConfig.setType("access_key");
        try {
            ossClient = new Client(ossConfig);
        }
        catch (Exception e) {
            throw new OpenApiException(e);
        }
        FileField fileObj = new FileField();
        fileObj.filename = popFileUploadInfo.getFileName();
        fileObj.content = popFileUploadInfo.getInputStream();
        fileObj.contentType = "";
        String objectKey = result.getPathPrefix() + popFileUploadInfo.getFileName();
        PostObjectRequest.PostObjectRequestHeader ossHeader = new PostObjectRequest.PostObjectRequestHeader();
        ossHeader.setAccessKeyId(result.getAccessKeyId());
        ossHeader.setPolicy(result.getEncodedPolicy());
        ossHeader.setSignature(result.getSignature());
        ossHeader.setKey(objectKey);
        ossHeader.setFile(fileObj);
        PostObjectRequest uploadRequest = new PostObjectRequest();
        uploadRequest.setBucketName(result.getBucket());
        uploadRequest.setHeader(ossHeader);
        try {
            ossClient.postObject(uploadRequest, new com.alibaba.dchain.inner.shaded.com.aliyun.ossutil.models.RuntimeOptions());
        }
        catch (Exception e) {
            throw new OpenApiException(e);
        }
        if (result.getSendRequest().booleanValue()) {
            return this.invokeInner(invocation);
        }
        return PopResponseConverter.toOpenApiResponse(Collections.emptyMap(), request.getResponseClass());
    }

    private Map<String, ?> callApi(BasePopRequest.PopApiInfo popApiInfo, OpenApiRequest openApiRequest) throws Exception {
        if (Objects.equals(popApiInfo.getReqBodyType(), BodyTypeEnum.JSON.getCode())) {
            return this.doROARequest(popApiInfo, openApiRequest);
        }
        if (Objects.equals(popApiInfo.getReqBodyType(), BodyTypeEnum.FORM.getCode())) {
            return this.doROARequestWithForm(popApiInfo, openApiRequest);
        }
        throw new OpenApiException(ErrorEnum.BODY_TYPE_NOT_SUPPORTED);
    }

    private Map<String, ?> doROARequest(BasePopRequest.PopApiInfo popApiInfo, OpenApiRequest openApiRequest) throws Exception {
        return this.client.doROARequest(popApiInfo.getApiCode(), popApiInfo.getApiVersion(), popApiInfo.getHttpProtocol(), popApiInfo.getHttpMethod(), popApiInfo.getAuthType(), popApiInfo.getPath(), popApiInfo.getBodyType(), openApiRequest, new RuntimeOptions());
    }

    private Map<String, ?> doROARequestWithForm(BasePopRequest.PopApiInfo popApiInfo, OpenApiRequest openApiRequest) throws Exception {
        return this.client.doROARequestWithForm(popApiInfo.getApiCode(), popApiInfo.getApiVersion(), popApiInfo.getHttpProtocol(), popApiInfo.getHttpMethod(), popApiInfo.getAuthType(), popApiInfo.getPath(), popApiInfo.getBodyType(), openApiRequest, new RuntimeOptions());
    }
}

