/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.inner.shaded.com.aliyun.credentials;

import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.AlibabaCloudCredentials;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.utils.ParameterHelper;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.utils.RefreshUtils;
import java.text.ParseException;

public class EcsRamRoleCredential
implements AlibabaCloudCredentials {
    private long expiration;
    private String accessKeyId;
    private String accessKeySecret;
    private String securityToken;
    private AlibabaCloudCredentialsProvider provider;

    public EcsRamRoleCredential() {
    }

    public EcsRamRoleCredential(String accessKeyId, String accessKeySecret, String securityToken, String expiration, AlibabaCloudCredentialsProvider provider) throws ParseException {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
        this.provider = provider;
        this.expiration = ParameterHelper.getUTCDate(expiration).getTime();
    }

    public void refreshCredential() {
        if (RefreshUtils.withShouldRefresh(this.expiration)) {
            EcsRamRoleCredential credential = (EcsRamRoleCredential)RefreshUtils.getNewCredential(this.provider);
            this.expiration = credential.getExpiration();
            this.accessKeyId = credential.getAccessKeyId();
            this.accessKeySecret = credential.getAccessKeySecret();
            this.securityToken = credential.getSecurityToken();
        }
    }

    @Override
    public String getAccessKeyId() {
        this.refreshCredential();
        return this.accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        this.refreshCredential();
        return this.accessKeySecret;
    }

    @Override
    public String getSecurityToken() {
        this.refreshCredential();
        return this.securityToken;
    }

    @Override
    public String getType() {
        return "ecs_ram_role";
    }

    @Override
    public String getBearerToken() {
        return null;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }
}

