/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.inner.shaded.com.aliyun.credentials;

import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.AlibabaCloudCredentials;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.utils.RefreshUtils;

public class RsaKeyPairCredential
implements AlibabaCloudCredentials {
    private String privateKeySecret;
    private String publicKeyId;
    private long expiration;
    private AlibabaCloudCredentialsProvider provider;

    public RsaKeyPairCredential(String publicKeyId, String privateKeySecret, long expiration, AlibabaCloudCredentialsProvider provider) {
        if (publicKeyId == null || privateKeySecret == null) {
            throw new IllegalArgumentException("You must provide a valid pair of Public Key ID and Private Key Secret.");
        }
        this.publicKeyId = publicKeyId;
        this.privateKeySecret = privateKeySecret;
        this.expiration = expiration;
        this.provider = provider;
    }

    public void refreshCredential() {
        if (RefreshUtils.withShouldRefresh(this.expiration)) {
            RsaKeyPairCredential credential = (RsaKeyPairCredential)RefreshUtils.getNewCredential(this.provider);
            this.publicKeyId = credential.publicKeyId;
            this.expiration = credential.expiration;
            this.privateKeySecret = credential.privateKeySecret;
        }
    }

    @Override
    public String getAccessKeyId() {
        this.refreshCredential();
        return this.publicKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        this.refreshCredential();
        return this.privateKeySecret;
    }

    @Override
    public String getSecurityToken() {
        return null;
    }

    @Override
    public String getType() {
        return "rsa_key_pair";
    }

    @Override
    public String getBearerToken() {
        return null;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public AlibabaCloudCredentialsProvider getProvider() {
        return this.provider;
    }
}

