/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.inner.shaded.com.aliyun.credentials.http;

import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.exception.CredentialException;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.http.FormatType;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.http.MethodType;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.utils.Base64Helper;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class HttpMessage {
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String CONTENT_MD5 = "Content-MD5";
    protected static final String CONTENT_LENGTH = "Content-Length";
    protected FormatType httpContentType = null;
    protected byte[] httpContent = null;
    protected String encoding = null;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Integer connectTimeout = null;
    protected Integer readTimeout = null;
    private String url = null;
    private MethodType method = null;

    public HttpMessage(String strUrl) {
        this.url = strUrl;
    }

    public HttpMessage() {
    }

    public FormatType getHttpContentType() {
        return this.httpContentType;
    }

    public void putHeaderParameter(String name, String value) {
        if (null != name && null != value) {
            this.headers.put(name, value);
        }
    }

    public void setHttpContentType(FormatType httpContentType) {
        this.httpContentType = httpContentType;
    }

    public byte[] getHttpContent() {
        return this.httpContent;
    }

    public void setHttpContent(byte[] content, String encoding, FormatType format) throws NoSuchAlgorithmException {
        if (null == content) {
            this.headers.remove(CONTENT_MD5);
            this.headers.put(CONTENT_LENGTH, "0");
            this.headers.remove(CONTENT_TYPE);
            this.httpContentType = null;
            this.httpContent = null;
            this.encoding = null;
            return;
        }
        if (this.getSysMethod() != null && !this.getSysMethod().hasContent()) {
            content = new byte[]{};
        }
        this.httpContent = content;
        this.encoding = encoding;
        String contentLen = String.valueOf(content.length);
        String strMd5 = HttpMessage.md5Sum(content);
        this.headers.put(CONTENT_MD5, strMd5);
        this.headers.put(CONTENT_LENGTH, contentLen);
        if (null != format) {
            this.headers.put(CONTENT_TYPE, FormatType.mapFormatToAccept(format));
        }
    }

    public static String md5Sum(byte[] buff) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] messageDigest = md.digest(buff);
        return Base64Helper.encode(messageDigest);
    }

    public String getHeaderValue(String name) {
        return this.headers.get(name);
    }

    public String getHttpContentString() throws CredentialException {
        String stringContent = "";
        if (this.httpContent != null) {
            try {
                stringContent = this.encoding == null ? new String(this.httpContent) : new String(this.httpContent, this.encoding);
            }
            catch (UnsupportedEncodingException exp) {
                throw new CredentialException("Can not parse response due to unsupported encoding.");
            }
        }
        return stringContent;
    }

    public String getSysUrl() {
        return this.url;
    }

    public void setSysUrl(String url) {
        this.url = url;
    }

    public MethodType getSysMethod() {
        return this.method;
    }

    public void setSysMethod(MethodType method) {
        this.method = method;
        if (MethodType.PUT == method) {
            this.setHttpContentType(FormatType.JSON);
        }
    }

    public String getSysEncoding() {
        return this.encoding;
    }

    public void setSysEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Integer getSysConnectTimeout() {
        return this.connectTimeout;
    }

    public void setSysConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getSysReadTimeout() {
        return this.readTimeout;
    }

    public void setSysReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Map<String, String> getSysHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }
}

