/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.inner.shaded.com.aliyun.credentials.provider;

import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.AlibabaCloudCredentials;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.exception.CredentialException;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.provider.EcsRamRoleCredentialProvider;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.provider.EnvironmentVariableCredentialsProvider;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.provider.ProfileCredentialsProvider;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.provider.SystemPropertiesCredentialsProvider;
import com.alibaba.dchain.inner.shaded.com.aliyun.credentials.utils.AuthUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DefaultCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private List<AlibabaCloudCredentialsProvider> defaultProviders = new ArrayList<AlibabaCloudCredentialsProvider>();
    private static final List<AlibabaCloudCredentialsProvider> USER_CONFIGURATION_PROVIDERS = new Vector<AlibabaCloudCredentialsProvider>();

    public DefaultCredentialsProvider() throws CredentialException, MalformedURLException {
        this.defaultProviders.add(new SystemPropertiesCredentialsProvider());
        this.defaultProviders.add(new EnvironmentVariableCredentialsProvider());
        this.defaultProviders.add(new ProfileCredentialsProvider());
        String roleName = AuthUtils.getEnvironmentECSMetaData();
        if (roleName != null) {
            this.defaultProviders.add(new EcsRamRoleCredentialProvider(roleName));
        }
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws CredentialException, IOException, ParseException {
        AlibabaCloudCredentials credential;
        if (USER_CONFIGURATION_PROVIDERS.size() > 0) {
            for (AlibabaCloudCredentialsProvider provider : USER_CONFIGURATION_PROVIDERS) {
                credential = provider.getCredentials();
                if (null == credential) continue;
                return credential;
            }
        }
        for (AlibabaCloudCredentialsProvider provider : this.defaultProviders) {
            credential = provider.getCredentials();
            if (null == credential) continue;
            return credential;
        }
        throw new CredentialException("not found credentials");
    }

    public static boolean addCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.add(provider);
    }

    public static boolean removeCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.remove(provider);
    }

    public static boolean containsCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.contains(provider);
    }

    public static void clearCredentialsProvider() {
        USER_CONFIGURATION_PROVIDERS.clear();
    }
}

