/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.inner.shaded.com.aliyun.ossutil;

import com.alibaba.dchain.inner.shaded.com.aliyun.ossutil.CRC64;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;

public class VerifyInputStream
extends InputStream {
    private InputStream inputStream;
    private Map<String, String> map;
    private CRC64 crc64 = new CRC64();
    private MessageDigest md = MessageDigest.getInstance("MD5");

    public VerifyInputStream(InputStream inputStream, Map<String, String> map) throws NoSuchAlgorithmException {
        this.inputStream = inputStream;
        this.map = map;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int index = this.inputStream.read(bytes);
        if (index != -1) {
            this.crc64.update(bytes, index);
            this.md.update(bytes, 0, index);
        } else {
            this.map.put("crc", this.crc64.getValue());
            this.map.put("md5", Base64.getEncoder().encodeToString(this.md.digest()));
        }
        return index;
    }
}

