/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.inner.shaded.com.aliyun.tea;

import com.alibaba.dchain.inner.shaded.com.aliyun.tea.TeaException;
import com.alibaba.dchain.inner.shaded.com.aliyun.tea.utils.StringUtils;
import com.alibaba.dchain.inner.shaded.okhttp3.Headers;
import com.alibaba.dchain.inner.shaded.okhttp3.Response;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TeaResponse {
    public Response response;
    public int statusCode;
    public String statusMessage;
    public HashMap<String, String> headers = new HashMap();
    public InputStream body;

    public TeaResponse() {
    }

    public TeaResponse(Response response) {
        this.response = response;
        this.statusCode = response.code();
        this.statusMessage = response.message();
        this.body = response.body().byteStream();
        Headers headers = response.headers();
        Map<String, List<String>> resultHeaders = headers.toMultimap();
        for (Map.Entry<String, List<String>> entry : resultHeaders.entrySet()) {
            this.headers.put(entry.getKey(), StringUtils.join(";", (Iterable<? extends String>)entry.getValue()));
        }
    }

    public InputStream getResponse() {
        return this.body;
    }

    public String getResponseBody() {
        if (null == this.body) {
            return String.format("{\"message\":\"%s\"}", this.statusMessage);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        try {
            int read;
            while ((read = this.body.read(buff)) != -1) {
                os.write(buff, 0, read);
            }
        }
        catch (Exception e) {
            throw new TeaException(e.getMessage(), e);
        }
        return new String(os.toByteArray());
    }
}

