/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.inner.shaded.okhttp3.internal.http2;

import com.alibaba.dchain.inner.shaded.okhttp3.Headers;
import com.alibaba.dchain.inner.shaded.okhttp3.Interceptor;
import com.alibaba.dchain.inner.shaded.okhttp3.OkHttpClient;
import com.alibaba.dchain.inner.shaded.okhttp3.Protocol;
import com.alibaba.dchain.inner.shaded.okhttp3.Request;
import com.alibaba.dchain.inner.shaded.okhttp3.Response;
import com.alibaba.dchain.inner.shaded.okhttp3.ResponseBody;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.Internal;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.Util;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.connection.StreamAllocation;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.http.HttpCodec;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.http.HttpHeaders;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.http.RealResponseBody;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.http.RequestLine;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.http.StatusLine;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.http2.ErrorCode;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.http2.Header;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.http2.Http2Connection;
import com.alibaba.dchain.inner.shaded.okhttp3.internal.http2.Http2Stream;
import com.alibaba.dchain.inner.shaded.okio.Buffer;
import com.alibaba.dchain.inner.shaded.okio.ByteString;
import com.alibaba.dchain.inner.shaded.okio.ForwardingSource;
import com.alibaba.dchain.inner.shaded.okio.Okio;
import com.alibaba.dchain.inner.shaded.okio.Sink;
import com.alibaba.dchain.inner.shaded.okio.Source;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Http2Codec
implements HttpCodec {
    private static final String CONNECTION = "connection";
    private static final String HOST = "host";
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String PROXY_CONNECTION = "proxy-connection";
    private static final String TRANSFER_ENCODING = "transfer-encoding";
    private static final String TE = "te";
    private static final String ENCODING = "encoding";
    private static final String UPGRADE = "upgrade";
    private static final List<String> HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableList("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade", ":method", ":path", ":scheme", ":authority");
    private static final List<String> HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableList("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade");
    private final Interceptor.Chain chain;
    final StreamAllocation streamAllocation;
    private final Http2Connection connection;
    private Http2Stream stream;
    private final Protocol protocol;

    public Http2Codec(OkHttpClient client, Interceptor.Chain chain, StreamAllocation streamAllocation, Http2Connection connection) {
        this.chain = chain;
        this.streamAllocation = streamAllocation;
        this.connection = connection;
        this.protocol = client.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_2;
    }

    @Override
    public Sink createRequestBody(Request request, long contentLength) {
        return this.stream.getSink();
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        if (this.stream != null) {
            return;
        }
        boolean hasRequestBody = request.body() != null;
        List<Header> requestHeaders = Http2Codec.http2HeadersList(request);
        this.stream = this.connection.newStream(requestHeaders, hasRequestBody);
        this.stream.readTimeout().timeout(this.chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.stream.writeTimeout().timeout(this.chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void flushRequest() throws IOException {
        this.connection.flush();
    }

    @Override
    public void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public Response.Builder readResponseHeaders(boolean expectContinue) throws IOException {
        Headers headers = this.stream.takeHeaders();
        Response.Builder responseBuilder = Http2Codec.readHttp2HeadersList(headers, this.protocol);
        if (expectContinue && Internal.instance.code(responseBuilder) == 100) {
            return null;
        }
        return responseBuilder;
    }

    public static List<Header> http2HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<Header> result = new ArrayList<Header>(headers.size() + 4);
        result.add(new Header(Header.TARGET_METHOD, request.method()));
        result.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.url())));
        String host = request.header("Host");
        if (host != null) {
            result.add(new Header(Header.TARGET_AUTHORITY, host));
        }
        result.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            ByteString name = ByteString.encodeUtf8(headers.name(i).toLowerCase(Locale.US));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(name.utf8())) continue;
            result.add(new Header(name, headers.value(i)));
        }
        return result;
    }

    public static Response.Builder readHttp2HeadersList(Headers headerBlock, Protocol protocol) throws IOException {
        StatusLine statusLine = null;
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headerBlock.size();
        for (int i = 0; i < size; ++i) {
            String name = headerBlock.name(i);
            String value = headerBlock.value(i);
            if (name.equals(":status")) {
                statusLine = StatusLine.parse("HTTP/1.1 " + value);
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(name)) continue;
            Internal.instance.addLenient(headersBuilder, name, value);
        }
        if (statusLine == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        return new Response.Builder().protocol(protocol).code(statusLine.code).message(statusLine.message).headers(headersBuilder.build());
    }

    @Override
    public ResponseBody openResponseBody(Response response) throws IOException {
        this.streamAllocation.eventListener.responseBodyStart(this.streamAllocation.call);
        String contentType = response.header("Content-Type");
        long contentLength = HttpHeaders.contentLength(response);
        StreamFinishingSource source = new StreamFinishingSource(this.stream.getSource());
        return new RealResponseBody(contentType, contentLength, Okio.buffer(source));
    }

    @Override
    public void cancel() {
        if (this.stream != null) {
            this.stream.closeLater(ErrorCode.CANCEL);
        }
    }

    class StreamFinishingSource
    extends ForwardingSource {
        boolean completed;
        long bytesRead;

        StreamFinishingSource(Source delegate) {
            super(delegate);
            this.completed = false;
            this.bytesRead = 0L;
        }

        @Override
        public long read(Buffer sink, long byteCount) throws IOException {
            try {
                long read = this.delegate().read(sink, byteCount);
                if (read > 0L) {
                    this.bytesRead += read;
                }
                return read;
            }
            catch (IOException e) {
                this.endOfInput(e);
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.endOfInput(null);
        }

        private void endOfInput(IOException e) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            Http2Codec.this.streamAllocation.streamFinished(false, Http2Codec.this, this.bytesRead, e);
        }
    }
}

