/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dchain.inner.utils;

import com.alibaba.dchain.inner.exception.ErrorEnum;
import com.alibaba.dchain.inner.exception.OpenApiException;

public final class Assert {
    private Assert() {
    }

    public static void assertTrue(boolean condition, ErrorEnum errorEnum) throws OpenApiException {
        if (!condition) {
            Assert.fail(errorEnum);
        }
    }

    public static void assertEquals(Object expected, Object actual, ErrorEnum errorEnum) throws OpenApiException {
        if (Assert.equalsRegardingNull(expected, actual)) {
            return;
        }
        Assert.fail(errorEnum);
    }

    private static boolean equalsRegardingNull(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return Assert.isEquals(expected, actual);
    }

    private static boolean isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    private static void fail(ErrorEnum errorEnum) throws OpenApiException {
        throw new OpenApiException(errorEnum);
    }
}

